/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.component;

import java.util.Iterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DataTableIteratorBase<E>
implements Iterator<E> {
    private boolean isCompleted = false;
    private E next = null;

    private void setupNext() {
        if (!this.isCompleted && this.next == null) {
            this.next = this.nextItem();
            if (this.next == null) {
                this.isCompleted = true;
            }
        }
    }

    @Override
    public boolean hasNext() {
        this.setupNext();
        return this.next != null;
    }

    @Override
    public E next() {
        this.setupNext();
        if (this.next == null) {
            throw new NoSuchElementException();
        }
        E result = this.next;
        this.next = null;
        return result;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Iterator is read-only");
    }

    protected abstract E nextItem();
}

