/*
 * Decompiled with CFR 0.152.
 */
package org.powermock.api.mockito.internal.verification;

import java.lang.reflect.Method;
import org.powermock.api.mockito.verification.PrivateMethodVerification;
import org.powermock.api.mockito.verification.WithOrWithoutVerifiedArguments;
import org.powermock.reflect.Whitebox;

public class DefaultPrivateMethodVerification
implements PrivateMethodVerification {
    private final Object objectToVerify;

    public DefaultPrivateMethodVerification(Object objectToVerify) {
        this.objectToVerify = objectToVerify;
    }

    public void invoke(Object ... arguments) throws Exception {
        Whitebox.invokeMethod((Object)this.objectToVerify, (Object[])arguments);
    }

    public void invoke(String methodToExecute, Object ... arguments) throws Exception {
        Whitebox.invokeMethod((Object)this.objectToVerify, (String)methodToExecute, (Object[])arguments);
    }

    public WithOrWithoutVerifiedArguments invoke(Method method) throws Exception {
        return new VerificationArguments(method);
    }

    private class VerificationArguments
    implements WithOrWithoutVerifiedArguments {
        private final Method method;

        public VerificationArguments(Method method) {
            if (method == null) {
                throw new IllegalArgumentException("method cannot be null");
            }
            this.method = method;
            this.method.setAccessible(true);
        }

        public void withArguments(Object firstArgument, Object ... additionalArguments) throws Exception {
            if (additionalArguments == null || additionalArguments.length == 0) {
                this.method.invoke(DefaultPrivateMethodVerification.this.objectToVerify, firstArgument);
            } else {
                this.method.invoke(DefaultPrivateMethodVerification.this.objectToVerify, firstArgument, additionalArguments);
            }
        }

        public void withNoArguments() throws Exception {
            this.method.invoke(DefaultPrivateMethodVerification.this.objectToVerify, new Object[0]);
        }
    }
}

