/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.unittest.mocks;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import org.apache.aries.unittest.mocks.Skeleton;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultInvocationHandler
implements InvocationHandler {
    private Skeleton _s;

    public DefaultInvocationHandler(Skeleton s) {
        this._s = s;
    }

    @Override
    public Object invoke(Object target, Method method, Object[] arguments) throws Throwable {
        Class<?> returnType = method.getReturnType();
        Object obj = null;
        if (returnType.isInterface()) {
            obj = this.createProxy(returnType);
        } else {
            try {
                obj = returnType.newInstance();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return obj;
    }

    public Object createProxy(Class<?> ... returnTypes) {
        Object result = null;
        boolean allInterfaces = true;
        for (int i = 0; allInterfaces && i < returnTypes.length; ++i) {
            allInterfaces = returnTypes[i].isInterface();
        }
        if (allInterfaces) {
            result = this._s.createMock(returnTypes);
        }
        return result;
    }
}

