/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.exam.options.extra;

import org.ops4j.lang.NullArgumentException;
import org.ops4j.pax.exam.options.extra.RepositoryOption;

public class RepositoryOptionImpl
implements RepositoryOption {
    private final String m_repositoryUrl;
    private boolean m_allowSnapshots;
    private boolean m_allowReleases;

    public RepositoryOptionImpl(String repositoryUrl) {
        NullArgumentException.validateNotEmpty((String)repositoryUrl, (String)"Repository URL");
        this.m_repositoryUrl = repositoryUrl;
        this.m_allowSnapshots = false;
        this.m_allowReleases = true;
    }

    public RepositoryOptionImpl allowSnapshots() {
        this.m_allowSnapshots = true;
        return this;
    }

    public RepositoryOptionImpl disableReleases() {
        this.m_allowReleases = false;
        return this;
    }

    public String getRepository() {
        if (!this.m_allowReleases && !this.m_allowSnapshots) {
            throw new IllegalStateException("Does not make sense to disallow both releases and snapshots.");
        }
        StringBuilder repositoryUrl = new StringBuilder();
        repositoryUrl.append(this.m_repositoryUrl);
        if (this.m_allowSnapshots) {
            repositoryUrl.append("@snapshots");
        }
        if (!this.m_allowReleases) {
            repositoryUrl.append("@noreleases");
        }
        return repositoryUrl.toString();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("RepositoryOptionImpl");
        sb.append("{url=").append(this.getRepository());
        sb.append('}');
        return sb.toString();
    }
}

