/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.exam.options.extra;

import org.ops4j.lang.NullArgumentException;
import org.ops4j.pax.exam.options.AbstractProvisionOption;
import org.ops4j.pax.exam.options.extra.Scanner;
import org.ops4j.pax.exam.options.extra.ScannerUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PomScannerProvisionOption
extends AbstractProvisionOption<PomScannerProvisionOption>
implements Scanner {
    private String m_url;
    private String m_artifact;
    private String m_groupId;
    private String m_version = "";

    public PomScannerProvisionOption(String url) {
        NullArgumentException.validateNotEmpty((String)url, (boolean)true, (String)"url");
        this.m_url = url;
    }

    public PomScannerProvisionOption() {
    }

    @Override
    public String getURL() {
        if (this.m_url == null) {
            this.m_url = "mvn:" + this.m_groupId + "/" + this.m_artifact + "/" + this.m_version + "/pom";
        }
        StringBuilder url = new StringBuilder().append("scan-pom").append(":").append(this.m_url);
        url.append(ScannerUtils.getOptions(this));
        return url.toString();
    }

    public PomScannerProvisionOption artifactId(String s) {
        this.m_artifact = s;
        return this;
    }

    public PomScannerProvisionOption groupId(String s) {
        this.m_groupId = s;
        return this;
    }

    public PomScannerProvisionOption version(String s) {
        this.m_version = s;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("PomScannerProvisionOption");
        sb.append("{url='").append(this.getURL()).append('\'');
        sb.append('}');
        return sb.toString();
    }

    @Override
    protected PomScannerProvisionOption itself() {
        return this;
    }
}

