/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.exam.options;

import org.ops4j.pax.exam.options.AbstractUrlProvisionOption;
import org.ops4j.pax.exam.options.UrlReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WrappedUrlProvisionOption
extends AbstractUrlProvisionOption<WrappedUrlProvisionOption> {
    private String m_bundleSymbolicName;
    private String m_bundleVersion;
    private String[] m_imports;
    private String[] m_exports;
    private String[] m_instructions;
    private OverwriteMode m_overwriteMode;

    public WrappedUrlProvisionOption(String url) {
        super(url);
    }

    public WrappedUrlProvisionOption(UrlReference url) {
        super(url);
    }

    @Override
    public String getURL() {
        StringBuilder options = new StringBuilder();
        if (this.m_overwriteMode != null) {
            if (options.length() > 0) {
                options.append("&");
            }
            options.append("overwrite=").append((Object)this.m_overwriteMode);
        }
        if (this.m_bundleSymbolicName != null) {
            if (options.length() > 0) {
                options.append("&");
            }
            options.append("Bundle-SymboliName=").append(this.m_bundleSymbolicName);
        }
        if (this.m_bundleVersion != null) {
            if (options.length() > 0) {
                options.append("&");
            }
            options.append("Bundle-Version=").append(this.m_bundleVersion);
        }
        if (this.m_imports != null && this.m_imports.length > 0) {
            if (options.length() > 0) {
                options.append("&");
            }
            options.append("Import-Package=");
            for (String entry : this.m_imports) {
                options.append(entry).append(",");
            }
            options.delete(options.length() - 1, options.length());
        }
        if (this.m_exports != null && this.m_exports.length > 0) {
            if (options.length() > 0) {
                options.append("&");
            }
            options.append("Export-Package=");
            for (String entry : this.m_exports) {
                options.append(entry).append(",");
            }
            options.delete(options.length() - 1, options.length());
        }
        if (this.m_instructions != null && this.m_instructions.length > 0) {
            for (String entry : this.m_instructions) {
                if (options.length() > 0) {
                    options.append("&");
                }
                options.append(entry);
            }
        }
        if (options.length() > 0) {
            options.insert(0, "$");
        }
        return "wrap:" + super.getURL() + options.toString();
    }

    public WrappedUrlProvisionOption bundleSymbolicName(String bundleSymbolicName) {
        this.m_bundleSymbolicName = bundleSymbolicName;
        return this;
    }

    public WrappedUrlProvisionOption bundleVersion(String bundleVersion) {
        this.m_bundleVersion = bundleVersion;
        return this;
    }

    public WrappedUrlProvisionOption imports(String ... imports) {
        this.m_imports = imports;
        return this;
    }

    public WrappedUrlProvisionOption exports(String ... exports) {
        this.m_exports = exports;
        return this;
    }

    public WrappedUrlProvisionOption overwriteManifest(OverwriteMode mode) {
        this.m_overwriteMode = mode;
        return this;
    }

    public WrappedUrlProvisionOption instructions(String ... instructions) {
        this.m_instructions = instructions;
        return this;
    }

    @Override
    protected WrappedUrlProvisionOption itself() {
        return this;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum OverwriteMode {
        KEEP,
        MERGE,
        FULL;

    }
}

