/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.exam;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import org.ops4j.lang.NullArgumentException;
import org.ops4j.pax.exam.Info;
import org.ops4j.pax.exam.Option;
import org.ops4j.pax.exam.OptionUtils;
import org.ops4j.pax.exam.options.BootClasspathLibraryOption;
import org.ops4j.pax.exam.options.BootDelegationOption;
import org.ops4j.pax.exam.options.BundleStartLevelOption;
import org.ops4j.pax.exam.options.CompositeOption;
import org.ops4j.pax.exam.options.CustomFrameworkOption;
import org.ops4j.pax.exam.options.DebugClassLoadingOption;
import org.ops4j.pax.exam.options.DefaultCompositeOption;
import org.ops4j.pax.exam.options.EquinoxFrameworkOption;
import org.ops4j.pax.exam.options.FelixFrameworkOption;
import org.ops4j.pax.exam.options.FrameworkOption;
import org.ops4j.pax.exam.options.FrameworkPropertyOption;
import org.ops4j.pax.exam.options.FrameworkStartLevelOption;
import org.ops4j.pax.exam.options.KnopflerfishFrameworkOption;
import org.ops4j.pax.exam.options.MavenArtifactProvisionOption;
import org.ops4j.pax.exam.options.MavenArtifactUrlReference;
import org.ops4j.pax.exam.options.MavenPluginGeneratedConfigOption;
import org.ops4j.pax.exam.options.OptionalCompositeOption;
import org.ops4j.pax.exam.options.ProvisionOption;
import org.ops4j.pax.exam.options.ServerModeOption;
import org.ops4j.pax.exam.options.SystemPackageOption;
import org.ops4j.pax.exam.options.SystemPropertyOption;
import org.ops4j.pax.exam.options.TimeoutOption;
import org.ops4j.pax.exam.options.UrlProvisionOption;
import org.ops4j.pax.exam.options.UrlReference;
import org.ops4j.pax.exam.options.WrappedUrlProvisionOption;
import org.ops4j.pax.exam.options.extra.AutoWrapOption;
import org.ops4j.pax.exam.options.extra.BundleScannerProvisionOption;
import org.ops4j.pax.exam.options.extra.CleanCachesOption;
import org.ops4j.pax.exam.options.extra.CompositeScannerProvisionOption;
import org.ops4j.pax.exam.options.extra.DirScannerProvisionOption;
import org.ops4j.pax.exam.options.extra.ExcludeDefaultRepositoriesOption;
import org.ops4j.pax.exam.options.extra.FeaturesScannerProvisionOption;
import org.ops4j.pax.exam.options.extra.FileScannerProvisionOption;
import org.ops4j.pax.exam.options.extra.LocalRepositoryOption;
import org.ops4j.pax.exam.options.extra.PomScannerProvisionOption;
import org.ops4j.pax.exam.options.extra.ProfileOption;
import org.ops4j.pax.exam.options.extra.RawPaxRunnerOptionOption;
import org.ops4j.pax.exam.options.extra.RawScannerProvisionOption;
import org.ops4j.pax.exam.options.extra.RepositoryOption;
import org.ops4j.pax.exam.options.extra.RepositoryOptionImpl;
import org.ops4j.pax.exam.options.extra.VMOption;
import org.ops4j.pax.exam.options.extra.WorkingDirectoryOption;
import org.ops4j.pax.exam.options.libraries.EasyMockBundlesOption;
import org.ops4j.pax.exam.options.libraries.JMockBundlesOption;
import org.ops4j.pax.exam.options.libraries.JUnitBundlesOption;
import org.ops4j.pax.exam.options.libraries.MockitoBundlesOption;
import org.ops4j.store.Handle;
import org.ops4j.store.Store;
import org.ops4j.store.StoreFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CoreOptions {
    private static final String DEFAULT_CONFIGURATION = "META-INF/maven/paxexam-config.args";

    private CoreOptions() {
    }

    public static Option[] options(Option ... options) {
        return OptionUtils.expand(options);
    }

    public static Option composite(Option ... options) {
        return new DefaultCompositeOption(options);
    }

    public static Option frameworks(FrameworkOption ... frameworks) {
        return CoreOptions.composite(frameworks);
    }

    public static FelixFrameworkOption felix() {
        return new FelixFrameworkOption();
    }

    public static Option allFelixVersions() {
        return CoreOptions.composite(CoreOptions.felix().version("1.0.0"), CoreOptions.felix().version("1.0.1"), CoreOptions.felix().version("1.0.3"), CoreOptions.felix().version("1.0.4"), CoreOptions.felix().version("1.2.0"), CoreOptions.felix().version("1.2.1"), CoreOptions.felix().version("1.2.2"), CoreOptions.felix().version("1.4.0"), CoreOptions.felix().version("1.4.1"), CoreOptions.felix().version("1.6.0"), CoreOptions.felix().version("1.6.1"), CoreOptions.felix().version("1.8.0"), CoreOptions.felix().version("1.8.1"), CoreOptions.felix().version("2.0.0"), CoreOptions.felix().version("2.0.1"), CoreOptions.felix().version("3.0.8"), CoreOptions.felix().version("3.0.9"), CoreOptions.felix().version("3.2.0"), CoreOptions.felix().version("3.2.1"), CoreOptions.felix().version("3.2.2"));
    }

    public static EquinoxFrameworkOption equinox() {
        return new EquinoxFrameworkOption();
    }

    public static Option allEquinoxVersions() {
        return CoreOptions.composite(CoreOptions.equinox().version("3.2.1"), CoreOptions.equinox().version("3.3.0"), CoreOptions.equinox().version("3.3.1"), CoreOptions.equinox().version("3.3.2"), CoreOptions.equinox().version("3.4.0"), CoreOptions.equinox().version("3.4.1"), CoreOptions.equinox().version("3.4.2"), CoreOptions.equinox().version("3.5.0"), CoreOptions.equinox().version("3.5.1"), CoreOptions.equinox().version("3.6.2"), CoreOptions.equinox().version("3.7.0"));
    }

    public static KnopflerfishFrameworkOption knopflerfish() {
        return new KnopflerfishFrameworkOption();
    }

    public static Option allKnopflerfishVersions() {
        return CoreOptions.composite(CoreOptions.knopflerfish().version("2.0.1"), CoreOptions.knopflerfish().version("2.0.2"), CoreOptions.knopflerfish().version("2.0.3"), CoreOptions.knopflerfish().version("2.0.4"), CoreOptions.knopflerfish().version("2.0.5"), CoreOptions.knopflerfish().version("2.1.0"), CoreOptions.knopflerfish().version("2.1.1"), CoreOptions.knopflerfish().version("2.2.0"), CoreOptions.knopflerfish().version("2.3.0"), CoreOptions.knopflerfish().version("2.3.1"), CoreOptions.knopflerfish().version("2.3.2"), CoreOptions.knopflerfish().version("2.3.3"), CoreOptions.knopflerfish().version("3.0.0"), CoreOptions.knopflerfish().version("3.1.0"), CoreOptions.knopflerfish().version("3.2.0"));
    }

    public static Option allFrameworks() {
        return CoreOptions.composite(CoreOptions.felix(), CoreOptions.equinox(), CoreOptions.knopflerfish());
    }

    public static Option allFrameworksVersions() {
        return CoreOptions.composite(CoreOptions.allFelixVersions(), CoreOptions.allEquinoxVersions(), CoreOptions.allKnopflerfishVersions());
    }

    public static CustomFrameworkOption customFramework(String baseFrameworkName, String definitionURL, String name) {
        return new CustomFrameworkOption(definitionURL, baseFrameworkName, name);
    }

    public static Option provision(String ... urls) {
        NullArgumentException.validateNotEmptyContent((String[])urls, (boolean)true, (String)"URLs");
        ArrayList<UrlProvisionOption> options = new ArrayList<UrlProvisionOption>();
        for (String url : urls) {
            options.add(new UrlProvisionOption(url));
        }
        return CoreOptions.provision(options.toArray(new ProvisionOption[options.size()]));
    }

    public static Option provision(InputStream ... streams) {
        NullArgumentException.validateNotNull((Object)streams, (String)"streams");
        UrlProvisionOption[] options = new UrlProvisionOption[streams.length];
        int i = 0;
        for (InputStream stream : streams) {
            options[i++] = CoreOptions.streamBundle(stream);
        }
        return CoreOptions.provision(options);
    }

    public static Option provision(ProvisionOption<?> ... urls) {
        return CoreOptions.composite(urls);
    }

    public static UrlProvisionOption streamBundle(InputStream stream) {
        NullArgumentException.validateNotNull((Object)stream, (String)"stream");
        Store store = StoreFactory.defaultStore();
        try {
            Handle handle = store.store((Object)stream);
            URL url = store.getLocation(handle).toURL();
            UrlProvisionOption option = new UrlProvisionOption(url.toExternalForm());
            return option;
        }
        catch (IOException e) {
            throw new IllegalArgumentException("A supplied stream blew up..", e);
        }
    }

    public static UrlProvisionOption url(String url) {
        return new UrlProvisionOption(url);
    }

    public static UrlProvisionOption bundle(String url) {
        return new UrlProvisionOption(url);
    }

    public static MavenArtifactUrlReference maven() {
        return new MavenArtifactUrlReference();
    }

    public static MavenArtifactUrlReference maven(String groupId, String artifactId) {
        return CoreOptions.maven().groupId(groupId).artifactId(artifactId);
    }

    public static MavenArtifactUrlReference maven(String groupId, String artifactId, String version) {
        return CoreOptions.maven().groupId(groupId).artifactId(artifactId).version(version);
    }

    public static MavenArtifactProvisionOption mavenBundle() {
        return new MavenArtifactProvisionOption();
    }

    public static MavenArtifactProvisionOption mavenBundle(String groupId, String artifactId) {
        return CoreOptions.mavenBundle().groupId(groupId).artifactId(artifactId);
    }

    public static MavenArtifactProvisionOption mavenBundle(String groupId, String artifactId, String version) {
        return CoreOptions.mavenBundle().groupId(groupId).artifactId(artifactId).version(version);
    }

    public static MavenArtifactProvisionOption mavenBundle(MavenArtifactUrlReference artifact) {
        return new MavenArtifactProvisionOption(artifact);
    }

    public static WrappedUrlProvisionOption wrappedBundle(String jarToWrapUrl) {
        return new WrappedUrlProvisionOption(jarToWrapUrl);
    }

    public static WrappedUrlProvisionOption wrappedBundle(UrlReference jarToWrapUrl) {
        return new WrappedUrlProvisionOption(jarToWrapUrl);
    }

    public static Option bootDelegationPackages(String ... packages) {
        NullArgumentException.validateNotEmptyContent((String[])packages, (boolean)true, (String)"Packages");
        ArrayList<BootDelegationOption> options = new ArrayList<BootDelegationOption>();
        for (String pkg : packages) {
            options.add(CoreOptions.bootDelegationPackage(pkg));
        }
        return CoreOptions.bootDelegationPackages(options.toArray(new BootDelegationOption[options.size()]));
    }

    public static Option bootDelegationPackages(BootDelegationOption ... packages) {
        return CoreOptions.composite(packages);
    }

    public static BootDelegationOption bootDelegationPackage(String pkg) {
        return new BootDelegationOption(pkg);
    }

    public static Option bootClasspathLibraries(String ... urls) {
        NullArgumentException.validateNotEmptyContent((String[])urls, (boolean)true, (String)"Urls");
        ArrayList<BootClasspathLibraryOption> options = new ArrayList<BootClasspathLibraryOption>();
        for (String url : urls) {
            options.add(CoreOptions.bootClasspathLibrary(url));
        }
        return CoreOptions.bootClasspathLibraries(options.toArray(new BootClasspathLibraryOption[options.size()]));
    }

    public static Option bootClasspathLibraries(BootClasspathLibraryOption ... libraries) {
        return CoreOptions.composite(libraries);
    }

    public static BootClasspathLibraryOption bootClasspathLibrary(String libraryUrl) {
        return new BootClasspathLibraryOption(libraryUrl);
    }

    public static BootClasspathLibraryOption bootClasspathLibrary(UrlReference libraryUrl) {
        return new BootClasspathLibraryOption(libraryUrl);
    }

    public static Option systemPackages(String ... packages) {
        NullArgumentException.validateNotEmptyContent((String[])packages, (boolean)true, (String)"Packages");
        ArrayList<SystemPackageOption> options = new ArrayList<SystemPackageOption>();
        for (String pkg : packages) {
            options.add(CoreOptions.systemPackage(pkg));
        }
        return CoreOptions.systemPackages(options.toArray(new SystemPackageOption[options.size()]));
    }

    public static Option systemPackages(SystemPackageOption ... packages) {
        return CoreOptions.composite(packages);
    }

    public static SystemPackageOption systemPackage(String pkg) {
        return new SystemPackageOption(pkg);
    }

    public static Option systemProperties(SystemPropertyOption ... systemProperties) {
        return CoreOptions.composite(systemProperties);
    }

    public static SystemPropertyOption systemProperty(String key) {
        return new SystemPropertyOption(key);
    }

    public static FrameworkPropertyOption frameworkProperty(String key) {
        return new FrameworkPropertyOption(key);
    }

    public static Option frameworkProperties(FrameworkPropertyOption ... frameworkProperties) {
        return CoreOptions.composite(frameworkProperties);
    }

    public static DebugClassLoadingOption debugClassLoading() {
        return new DebugClassLoadingOption();
    }

    public static MavenPluginGeneratedConfigOption mavenConfiguration() {
        URL url = CoreOptions.class.getClassLoader().getResource(DEFAULT_CONFIGURATION);
        if (url != null) {
            return CoreOptions.mavenConfiguration(url);
        }
        throw new IllegalArgumentException("Maven PaxExam Plugin does not look like being configured or run properly. File (usually produced by the plugin upfront) META-INF/maven/paxexam-config.args has not been found.");
    }

    public static MavenPluginGeneratedConfigOption mavenConfiguration(String url) {
        NullArgumentException.validateNotEmpty((String)url, (String)"specified configuration url must not be empty ");
        try {
            return CoreOptions.mavenConfiguration(new URL(url));
        }
        catch (MalformedURLException mE) {
            throw new IllegalArgumentException("url " + url + " is not a valid url", mE);
        }
    }

    public static MavenPluginGeneratedConfigOption mavenConfiguration(URL url) {
        NullArgumentException.validateNotNull((Object)url, (String)"specified configuration url ");
        return new MavenPluginGeneratedConfigOption(url);
    }

    public static OptionalCompositeOption when(boolean condition) {
        return new OptionalCompositeOption(condition);
    }

    public static OptionalCompositeOption when(OptionalCompositeOption.Condition condition) {
        return new OptionalCompositeOption(condition);
    }

    public static FrameworkStartLevelOption frameworkStartLevel(int startLevel) {
        return new FrameworkStartLevelOption(startLevel);
    }

    public static BundleStartLevelOption bundleStartLevel(int startLevel) {
        return new BundleStartLevelOption(startLevel);
    }

    public static TimeoutOption systemTimeout(long timeoutInMillis) {
        return new TimeoutOption(timeoutInMillis);
    }

    public static EasyMockBundlesOption easyMockBundles() {
        return new EasyMockBundlesOption();
    }

    public static MockitoBundlesOption mockitoBundles() {
        return new MockitoBundlesOption();
    }

    public static CompositeOption junitBundles() {
        return new DefaultCompositeOption(new JUnitBundlesOption(), CoreOptions.systemProperty("pax.exam.invoker").value("junit"), CoreOptions.mavenBundle("org.ops4j.pax.exam", "pax-exam-invoker-junit", Info.getPaxExamVersion()));
    }

    public static JMockBundlesOption jmockBundles() {
        return new JMockBundlesOption();
    }

    public static Option profiles(ProfileOption ... profiles) {
        return new DefaultCompositeOption(profiles);
    }

    public static ProfileOption profile(String name) {
        return new ProfileOption(name);
    }

    public static ProfileOption profile(String name, String version) {
        return new ProfileOption(name, version);
    }

    public static ProfileOption webProfile() {
        return new ProfileOption("web");
    }

    public static ProfileOption logProfile() {
        return new ProfileOption("log");
    }

    public static ProfileOption configProfile() {
        return new ProfileOption("config");
    }

    public static ProfileOption dsProfile() {
        return new ProfileOption("ds");
    }

    public static ProfileOption compendiumProfile() {
        return new ProfileOption("compendium");
    }

    public static CleanCachesOption cleanCaches(boolean value) {
        return new CleanCachesOption(value);
    }

    public static CleanCachesOption cleanCaches() {
        return new CleanCachesOption();
    }

    public static CleanCachesOption keepCaches() {
        return new CleanCachesOption(Boolean.FALSE);
    }

    public static Option serverMode() {
        return CoreOptions.composite(CoreOptions.keepCaches(), CoreOptions.rawPaxRunnerOption("keepOriginalUrls"), new ServerModeOption());
    }

    public static Option vmOptions(String ... vmOptions) {
        NullArgumentException.validateNotEmptyContent((String[])vmOptions, (boolean)true, (String)"VM options");
        ArrayList<VMOption> options = new ArrayList<VMOption>();
        for (String vmOption : vmOptions) {
            options.add(CoreOptions.vmOption(vmOption));
        }
        return CoreOptions.vmOptions(options.toArray(new VMOption[options.size()]));
    }

    public static Option vmOptions(VMOption ... vmOptions) {
        return new DefaultCompositeOption(vmOptions);
    }

    public static VMOption vmOption(String vmOption) {
        return new VMOption(vmOption);
    }

    public static RawPaxRunnerOptionOption rawPaxRunnerOption(String key, String value) {
        return new RawPaxRunnerOptionOption(key, value);
    }

    public static RawPaxRunnerOptionOption rawPaxRunnerOption(String option) {
        return new RawPaxRunnerOptionOption(option);
    }

    public static Option repositories(String ... repositoryUrls) {
        NullArgumentException.validateNotEmptyContent((String[])repositoryUrls, (boolean)true, (String)"Repository URLs");
        ArrayList<RepositoryOption> options = new ArrayList<RepositoryOption>();
        for (String repositoryUrl : repositoryUrls) {
            options.add(CoreOptions.repository(repositoryUrl));
        }
        return CoreOptions.repositories(options.toArray(new RepositoryOption[options.size()]));
    }

    public static Option repositories(RepositoryOption ... repositoryOptions) {
        return new DefaultCompositeOption(repositoryOptions);
    }

    public static LocalRepositoryOption localRepository(String path) {
        return new LocalRepositoryOption(path);
    }

    public static RepositoryOption repository(String repositoryUrl) {
        return new RepositoryOptionImpl(repositoryUrl);
    }

    public static ExcludeDefaultRepositoriesOption excludeDefaultRepositories() {
        return new ExcludeDefaultRepositoriesOption();
    }

    public static RawScannerProvisionOption scan(String provisionSpec) {
        return new RawScannerProvisionOption(provisionSpec);
    }

    public static DirScannerProvisionOption scanDir(String directory) {
        return new DirScannerProvisionOption(directory);
    }

    public static PomScannerProvisionOption scanPom(String url) {
        return new PomScannerProvisionOption(url);
    }

    public static PomScannerProvisionOption scanPom() {
        return new PomScannerProvisionOption();
    }

    public static FileScannerProvisionOption scanFile(String fileUrl) {
        return new FileScannerProvisionOption(fileUrl);
    }

    public static FileScannerProvisionOption scanFile(UrlReference fileUrl) {
        return new FileScannerProvisionOption(fileUrl);
    }

    public static FeaturesScannerProvisionOption scanFeatures(String repositoryUrl, String ... features) {
        return new FeaturesScannerProvisionOption(repositoryUrl, features);
    }

    public static FeaturesScannerProvisionOption scanFeatures(UrlReference repositoryUrl, String ... features) {
        return new FeaturesScannerProvisionOption(repositoryUrl, features);
    }

    public static CompositeScannerProvisionOption scanComposite(String fileUrl) {
        return new CompositeScannerProvisionOption(fileUrl);
    }

    public static CompositeScannerProvisionOption scanComposite(UrlReference fileUrl) {
        return new CompositeScannerProvisionOption(fileUrl);
    }

    public static AutoWrapOption autoWrap() {
        return new AutoWrapOption();
    }

    public static BundleScannerProvisionOption scanBundle(String bundleUrl) {
        return new BundleScannerProvisionOption(bundleUrl);
    }

    public static BundleScannerProvisionOption scanBundle(UrlReference bundleUrl) {
        return new BundleScannerProvisionOption(bundleUrl);
    }

    public static WorkingDirectoryOption workingDirectory(String directory) {
        return new WorkingDirectoryOption(directory);
    }
}

