/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.exam;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import org.ops4j.lang.NullArgumentException;
import org.ops4j.pax.exam.Option;
import org.ops4j.pax.exam.OptionUtils;
import org.ops4j.pax.exam.options.BootClasspathLibraryOption;
import org.ops4j.pax.exam.options.BootDelegationOption;
import org.ops4j.pax.exam.options.BundleStartLevelOption;
import org.ops4j.pax.exam.options.CustomFrameworkOption;
import org.ops4j.pax.exam.options.DebugClassLoadingOption;
import org.ops4j.pax.exam.options.DefaultCompositeOption;
import org.ops4j.pax.exam.options.EquinoxFrameworkOption;
import org.ops4j.pax.exam.options.FelixFrameworkOption;
import org.ops4j.pax.exam.options.FrameworkOption;
import org.ops4j.pax.exam.options.FrameworkStartLevelOption;
import org.ops4j.pax.exam.options.KnopflerfishFrameworkOption;
import org.ops4j.pax.exam.options.MavenArtifactProvisionOption;
import org.ops4j.pax.exam.options.MavenArtifactUrlReference;
import org.ops4j.pax.exam.options.MavenPluginGeneratedConfigOption;
import org.ops4j.pax.exam.options.OptionalCompositeOption;
import org.ops4j.pax.exam.options.ProvisionOption;
import org.ops4j.pax.exam.options.RawUrlReference;
import org.ops4j.pax.exam.options.SystemPackageOption;
import org.ops4j.pax.exam.options.SystemPropertyOption;
import org.ops4j.pax.exam.options.TestContainerStartTimeoutOption;
import org.ops4j.pax.exam.options.UrlProvisionOption;
import org.ops4j.pax.exam.options.UrlReference;
import org.ops4j.pax.exam.options.WrappedUrlProvisionOption;
import org.ops4j.store.Store;
import org.ops4j.store.StoreFactory;

public class CoreOptions {
    private static final String DEFAULT_CONFIGURATION = "META-INF/maven/paxexam-config.args";

    private CoreOptions() {
    }

    public static Option[] options(Option ... options) {
        return OptionUtils.expand(options);
    }

    public static Option composite(Option ... options) {
        return new DefaultCompositeOption(options);
    }

    public static Option frameworks(FrameworkOption ... frameworks) {
        return CoreOptions.composite(frameworks);
    }

    public static FelixFrameworkOption felix() {
        return new FelixFrameworkOption();
    }

    public static Option allFelixVersions() {
        return CoreOptions.composite(CoreOptions.felix().version("1.0.0"), CoreOptions.felix().version("1.0.1"), CoreOptions.felix().version("1.0.3"), CoreOptions.felix().version("1.0.4"), CoreOptions.felix().version("1.2.0"), CoreOptions.felix().version("1.2.1"), CoreOptions.felix().version("1.2.2"), CoreOptions.felix().version("1.4.0"), CoreOptions.felix().version("1.4.1"), CoreOptions.felix().version("1.6.0"), CoreOptions.felix().version("1.6.1"), CoreOptions.felix().version("1.8.0"), CoreOptions.felix().version("1.8.1"), CoreOptions.felix().version("2.0.0"), CoreOptions.felix().version("2.0.1"), CoreOptions.felix().version("2.0.2"), CoreOptions.felix().version("3.0.0"), CoreOptions.felix().version("3.0.1"), CoreOptions.felix().version("3.0.2"));
    }

    public static EquinoxFrameworkOption equinox() {
        return new EquinoxFrameworkOption();
    }

    public static Option allEquinoxVersions() {
        return CoreOptions.composite(CoreOptions.equinox().version("3.2.1"), CoreOptions.equinox().version("3.3.0"), CoreOptions.equinox().version("3.3.1"), CoreOptions.equinox().version("3.3.2"), CoreOptions.equinox().version("3.4.0"), CoreOptions.equinox().version("3.4.1"), CoreOptions.equinox().version("3.4.2"), CoreOptions.equinox().version("3.5.0"), CoreOptions.equinox().version("3.5.1"), CoreOptions.equinox().version("3.6.0"));
    }

    public static KnopflerfishFrameworkOption knopflerfish() {
        return new KnopflerfishFrameworkOption();
    }

    public static Option allKnopflerfishVersions() {
        return CoreOptions.composite(CoreOptions.knopflerfish().version("2.0.1"), CoreOptions.knopflerfish().version("2.0.2"), CoreOptions.knopflerfish().version("2.0.3"), CoreOptions.knopflerfish().version("2.0.4"), CoreOptions.knopflerfish().version("2.0.5"), CoreOptions.knopflerfish().version("2.1.0"), CoreOptions.knopflerfish().version("2.1.1"), CoreOptions.knopflerfish().version("2.2.0"), CoreOptions.knopflerfish().version("2.3.0"), CoreOptions.knopflerfish().version("2.3.1"), CoreOptions.knopflerfish().version("2.3.2"), CoreOptions.knopflerfish().version("2.3.3"), CoreOptions.knopflerfish().version("3.0.0"));
    }

    public static Option allFrameworks() {
        return CoreOptions.composite(CoreOptions.felix(), CoreOptions.equinox(), CoreOptions.knopflerfish());
    }

    public static Option allFrameworksVersions() {
        return CoreOptions.composite(CoreOptions.allFelixVersions(), CoreOptions.allEquinoxVersions(), CoreOptions.allKnopflerfishVersions());
    }

    public static CustomFrameworkOption customFramework(String baseFrameworkName, String definitionURL, String name) {
        return new CustomFrameworkOption(definitionURL, baseFrameworkName, name);
    }

    public static Option provision(String ... urls) {
        NullArgumentException.validateNotEmptyContent((String[])urls, (boolean)true, (String)"URLs");
        ArrayList<UrlProvisionOption> options = new ArrayList<UrlProvisionOption>();
        for (String url : urls) {
            options.add(new UrlProvisionOption(url));
        }
        return CoreOptions.provision(options.toArray(new ProvisionOption[options.size()]));
    }

    public static Option provision(InputStream ... streams) {
        NullArgumentException.validateNotNull((Object)streams, (String)"streams");
        Store store = StoreFactory.defaultStore();
        ArrayList<UrlProvisionOption> options = new ArrayList<UrlProvisionOption>();
        for (InputStream stream : streams) {
            try {
                options.add(new UrlProvisionOption(store.getLocation(store.store((Object)stream)).toURL().toExternalForm()));
            }
            catch (IOException e) {
                throw new IllegalArgumentException("A supplied stream blew up..", e);
            }
        }
        return CoreOptions.provision(options.toArray(new ProvisionOption[options.size()]));
    }

    public static Option provision(ProvisionOption ... urls) {
        return CoreOptions.composite(urls);
    }

    public static RawUrlReference url(String url) {
        return new RawUrlReference(url);
    }

    public static UrlProvisionOption bundle(String url) {
        return new UrlProvisionOption(url);
    }

    public static MavenArtifactUrlReference maven() {
        return new MavenArtifactUrlReference();
    }

    public static MavenArtifactUrlReference maven(String groupId, String artifactId) {
        return CoreOptions.maven().groupId(groupId).artifactId(artifactId);
    }

    public static MavenArtifactUrlReference maven(String groupId, String artifactId, String version) {
        return CoreOptions.maven().groupId(groupId).artifactId(artifactId).version(version);
    }

    public static MavenArtifactProvisionOption mavenBundle() {
        return new MavenArtifactProvisionOption();
    }

    public static MavenArtifactProvisionOption mavenBundle(String groupId, String artifactId) {
        return CoreOptions.mavenBundle().groupId(groupId).artifactId(artifactId);
    }

    public static MavenArtifactProvisionOption mavenBundle(String groupId, String artifactId, String version) {
        return CoreOptions.mavenBundle().groupId(groupId).artifactId(artifactId).version(version);
    }

    public static MavenArtifactProvisionOption mavenBundle(MavenArtifactUrlReference artifact) {
        return new MavenArtifactProvisionOption(artifact);
    }

    public static WrappedUrlProvisionOption wrappedBundle(String jarToWrapUrl) {
        return new WrappedUrlProvisionOption(jarToWrapUrl);
    }

    public static WrappedUrlProvisionOption wrappedBundle(UrlReference jarToWrapUrl) {
        return new WrappedUrlProvisionOption(jarToWrapUrl);
    }

    public static Option bootDelegationPackages(String ... packages) {
        NullArgumentException.validateNotEmptyContent((String[])packages, (boolean)true, (String)"Packages");
        ArrayList<BootDelegationOption> options = new ArrayList<BootDelegationOption>();
        for (String pkg : packages) {
            options.add(CoreOptions.bootDelegationPackage(pkg));
        }
        return CoreOptions.bootDelegationPackages(options.toArray(new BootDelegationOption[options.size()]));
    }

    public static Option bootDelegationPackages(BootDelegationOption ... packages) {
        return CoreOptions.composite(packages);
    }

    public static BootDelegationOption bootDelegationPackage(String pkg) {
        return new BootDelegationOption(pkg);
    }

    public static Option bootClasspathLibraries(String ... urls) {
        NullArgumentException.validateNotEmptyContent((String[])urls, (boolean)true, (String)"Urls");
        ArrayList<BootClasspathLibraryOption> options = new ArrayList<BootClasspathLibraryOption>();
        for (String url : urls) {
            options.add(CoreOptions.bootClasspathLibrary(url));
        }
        return CoreOptions.bootClasspathLibraries(options.toArray(new BootClasspathLibraryOption[options.size()]));
    }

    public static Option bootClasspathLibraries(BootClasspathLibraryOption ... libraries) {
        return CoreOptions.composite(libraries);
    }

    public static BootClasspathLibraryOption bootClasspathLibrary(String libraryUrl) {
        return new BootClasspathLibraryOption(libraryUrl);
    }

    public static BootClasspathLibraryOption bootClasspathLibrary(UrlReference libraryUrl) {
        return new BootClasspathLibraryOption(libraryUrl);
    }

    public static Option systemPackages(String ... packages) {
        NullArgumentException.validateNotEmptyContent((String[])packages, (boolean)true, (String)"Packages");
        ArrayList<SystemPackageOption> options = new ArrayList<SystemPackageOption>();
        for (String pkg : packages) {
            options.add(CoreOptions.systemPackage(pkg));
        }
        return CoreOptions.systemPackages(options.toArray(new SystemPackageOption[options.size()]));
    }

    public static Option systemPackages(SystemPackageOption ... packages) {
        return CoreOptions.composite(packages);
    }

    public static SystemPackageOption systemPackage(String pkg) {
        return new SystemPackageOption(pkg);
    }

    public static Option systemProperties(SystemPropertyOption ... systemProperties) {
        return CoreOptions.composite(systemProperties);
    }

    public static SystemPropertyOption systemProperty(String key) {
        return new SystemPropertyOption(key);
    }

    public static DebugClassLoadingOption debugClassLoading() {
        return new DebugClassLoadingOption();
    }

    public static MavenPluginGeneratedConfigOption mavenConfiguration() {
        URL url = CoreOptions.class.getClassLoader().getResource(DEFAULT_CONFIGURATION);
        if (url != null) {
            return CoreOptions.mavenConfiguration(url);
        }
        throw new IllegalArgumentException("Maven PaxExam Plugin does not look like being configured or run properly. File (usually produced by the plugin upfront) META-INF/maven/paxexam-config.args has not been found.");
    }

    public static MavenPluginGeneratedConfigOption mavenConfiguration(String url) {
        NullArgumentException.validateNotEmpty((String)url, (String)"specified configuration url must not be empty ");
        try {
            return CoreOptions.mavenConfiguration(new URL(url));
        }
        catch (MalformedURLException mE) {
            throw new IllegalArgumentException("url " + url + " is not a valid url", mE);
        }
    }

    public static MavenPluginGeneratedConfigOption mavenConfiguration(URL url) {
        NullArgumentException.validateNotNull((Object)url, (String)"specified configuration url ");
        return new MavenPluginGeneratedConfigOption(url);
    }

    public static OptionalCompositeOption when(boolean condition) {
        return new OptionalCompositeOption(condition);
    }

    public static OptionalCompositeOption when(OptionalCompositeOption.Condition condition) {
        return new OptionalCompositeOption(condition);
    }

    public static FrameworkStartLevelOption frameworkStartLevel(int startLevel) {
        return new FrameworkStartLevelOption(startLevel);
    }

    public static BundleStartLevelOption bundleStartLevel(int startLevel) {
        return new BundleStartLevelOption(startLevel);
    }

    public static TestContainerStartTimeoutOption waitForFrameworkStartupFor(long timeoutInMillis) {
        return new TestContainerStartTimeoutOption(timeoutInMillis);
    }

    public static TestContainerStartTimeoutOption doNotWaitForFrameworkStartup() {
        return CoreOptions.waitForFrameworkStartupFor(0L);
    }

    public static TestContainerStartTimeoutOption waitForFrameworkStartup() {
        return CoreOptions.waitForFrameworkStartupFor(300000L);
    }
}

