/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven.search;

import java.util.Collections;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.Validated;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.marker.SearchResult;
import org.openrewrite.maven.MavenDownloadingException;
import org.openrewrite.maven.MavenIsoVisitor;
import org.openrewrite.maven.internal.MavenPomDownloader;
import org.openrewrite.maven.table.ParentPomsInUse;
import org.openrewrite.maven.tree.MavenResolutionResult;
import org.openrewrite.maven.tree.Parent;
import org.openrewrite.maven.tree.ResolvedPom;
import org.openrewrite.semver.Semver;
import org.openrewrite.semver.VersionComparator;
import org.openrewrite.xml.tree.Xml;

public final class ParentPomInsight
extends Recipe {
    private final transient ParentPomsInUse inUse = new ParentPomsInUse(this);
    @Option(displayName="Group pattern", description="Group glob pattern used to match dependencies.", example="org.springframework.boot")
    private final String groupIdPattern;
    @Option(displayName="Artifact pattern", description="Artifact glob pattern used to match dependencies.", example="spring-boot-starter-*")
    private final String artifactIdPattern;
    @Option(displayName="Version", description="Match only dependencies with the specified version. Node-style [version selectors](https://docs.openrewrite.org/reference/dependency-version-selectors) may be used.All versions are searched by default.", example="1.x", required=false)
    private final @Nullable String version;
    @Option(displayName="Recursive", description="Whether to search recursively through the parents. True by default.", required=false)
    private final @Nullable Boolean recursive;

    public String getDisplayName() {
        return "Maven parent insight";
    }

    public String getInstanceNameSuffix() {
        return String.format("for `%s:%s`", this.groupIdPattern, this.artifactIdPattern);
    }

    public String getDescription() {
        return "Find Maven parents matching a `groupId` and `artifactId`.";
    }

    public Validated<Object> validate() {
        Validated v = super.validate();
        if (this.version != null) {
            v = v.and(Semver.validate((String)this.version, null));
        }
        return v;
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new MavenIsoVisitor<ExecutionContext>(){
            final @Nullable VersionComparator versionComparator;
            {
                this.versionComparator = ParentPomInsight.this.version == null ? null : (VersionComparator)Semver.validate((String)ParentPomInsight.this.version, null).getValue();
            }

            @Override
            public Xml.Tag visitTag(Xml.Tag tag, ExecutionContext ctx) {
                Xml.Tag t = super.visitTag(tag, ctx);
                if (!this.isParentTag()) {
                    return t;
                }
                MavenResolutionResult mrr = this.getResolutionResult();
                MavenPomDownloader mpd = new MavenPomDownloader(mrr.getProjectPoms(), ctx, mrr.getMavenSettings(), mrr.getActiveProfiles());
                Parent ancestor = mrr.getPom().getRequested().getParent();
                String relativePath = tag.getChildValue("relativePath").orElse(null);
                while (ancestor != null) {
                    String groupId = ancestor.getGroupId();
                    String artifactId = ancestor.getArtifactId();
                    if (StringUtils.matchesGlob((String)groupId, (String)ParentPomInsight.this.groupIdPattern) && StringUtils.matchesGlob((String)artifactId, (String)ParentPomInsight.this.artifactIdPattern)) {
                        String parentVersion = ancestor.getVersion();
                        if (this.versionComparator == null || this.versionComparator.isValid(null, parentVersion)) {
                            ParentPomInsight.this.inUse.insertRow(ctx, new ParentPomsInUse.Row(mrr.getPom().getArtifactId(), groupId, artifactId, parentVersion, relativePath));
                            return (Xml.Tag)SearchResult.found((Tree)t);
                        }
                    }
                    if (Boolean.FALSE.equals(ParentPomInsight.this.recursive)) {
                        return t;
                    }
                    try {
                        ResolvedPom ancestorPom = mpd.download(ancestor.getGav(), null, null, mrr.getPom().getRepositories()).resolve(Collections.emptyList(), mpd, ctx);
                        ancestor = ancestorPom.getRequested().getParent();
                        relativePath = null;
                    }
                    catch (MavenDownloadingException e) {
                        return e.warn(t);
                    }
                }
                return t;
            }
        };
    }

    @Generated
    public ParentPomInsight(String groupIdPattern, String artifactIdPattern, @Nullable String version, @Nullable Boolean recursive) {
        this.groupIdPattern = groupIdPattern;
        this.artifactIdPattern = artifactIdPattern;
        this.version = version;
        this.recursive = recursive;
    }

    @Generated
    public ParentPomsInUse getInUse() {
        return this.inUse;
    }

    @Generated
    public String getGroupIdPattern() {
        return this.groupIdPattern;
    }

    @Generated
    public String getArtifactIdPattern() {
        return this.artifactIdPattern;
    }

    @Generated
    public @Nullable String getVersion() {
        return this.version;
    }

    @Generated
    public @Nullable Boolean getRecursive() {
        return this.recursive;
    }

    @NonNull
    @Generated
    public String toString() {
        return "ParentPomInsight(inUse=" + (Object)((Object)this.getInUse()) + ", groupIdPattern=" + this.getGroupIdPattern() + ", artifactIdPattern=" + this.getArtifactIdPattern() + ", version=" + this.getVersion() + ", recursive=" + this.getRecursive() + ")";
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ParentPomInsight)) {
            return false;
        }
        ParentPomInsight other = (ParentPomInsight)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Boolean this$recursive = this.getRecursive();
        Boolean other$recursive = other.getRecursive();
        if (this$recursive == null ? other$recursive != null : !((Object)this$recursive).equals(other$recursive)) {
            return false;
        }
        String this$groupIdPattern = this.getGroupIdPattern();
        String other$groupIdPattern = other.getGroupIdPattern();
        if (this$groupIdPattern == null ? other$groupIdPattern != null : !this$groupIdPattern.equals(other$groupIdPattern)) {
            return false;
        }
        String this$artifactIdPattern = this.getArtifactIdPattern();
        String other$artifactIdPattern = other.getArtifactIdPattern();
        if (this$artifactIdPattern == null ? other$artifactIdPattern != null : !this$artifactIdPattern.equals(other$artifactIdPattern)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        return !(this$version == null ? other$version != null : !this$version.equals(other$version));
    }

    @Generated
    protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
        return other instanceof ParentPomInsight;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $recursive = this.getRecursive();
        result = result * 59 + ($recursive == null ? 43 : ((Object)$recursive).hashCode());
        String $groupIdPattern = this.getGroupIdPattern();
        result = result * 59 + ($groupIdPattern == null ? 43 : $groupIdPattern.hashCode());
        String $artifactIdPattern = this.getArtifactIdPattern();
        result = result * 59 + ($artifactIdPattern == null ? 43 : $artifactIdPattern.hashCode());
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        return result;
    }
}

