/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.gradle;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.Validated;
import org.openrewrite.gradle.IsBuildGradle;
import org.openrewrite.gradle.internal.ChangeStringLiteral;
import org.openrewrite.gradle.internal.Dependency;
import org.openrewrite.gradle.internal.DependencyStringNotationConverter;
import org.openrewrite.gradle.marker.GradleDependencyConfiguration;
import org.openrewrite.gradle.marker.GradleProject;
import org.openrewrite.gradle.trait.GradleDependency;
import org.openrewrite.groovy.GroovyIsoVisitor;
import org.openrewrite.groovy.tree.G;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.MethodCall;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.maven.MavenDownloadingException;
import org.openrewrite.maven.internal.MavenPomDownloader;
import org.openrewrite.maven.tree.GroupArtifactVersion;
import org.openrewrite.maven.tree.ResolvedDependency;
import org.openrewrite.maven.tree.ResolvedPom;
import org.openrewrite.semver.ExactVersion;
import org.openrewrite.semver.LatestIntegration;
import org.openrewrite.semver.Semver;
import org.openrewrite.semver.VersionComparator;

public final class RemoveRedundantDependencyVersions
extends Recipe {
    @Option(displayName="Group", description="Group glob expression pattern used to match dependencies that should be managed.Group is the first part of a dependency coordinate `com.google.guava:guava:VERSION`.", example="com.google.*", required=false)
    private final @Nullable String groupPattern;
    @Option(displayName="Artifact", description="Artifact glob expression pattern used to match dependencies that should be managed.Artifact is the second part of a dependency coordinate `com.google.guava:guava:VERSION`.", example="guava*", required=false)
    private final @Nullable String artifactPattern;
    @Option(displayName="Only if managed version is ...", description="Only remove the explicit version if the managed version has the specified comparative relationship to the explicit version. For example, `gte` will only remove the explicit version if the managed version is the same or newer. Default `eq`.", valid={"ANY", "EQ", "LT", "LTE", "GT", "GTE"}, required=false)
    private final @Nullable Comparator onlyIfManagedVersionIs;
    @Option(displayName="Except", description="Accepts a list of GAVs. Dependencies matching a GAV will be ignored by this recipe. GAV versions are ignored if provided.", example="com.jcraft:jsch", required=false)
    private final @Nullable List<String> except;
    private static final MethodMatcher CONSTRAINTS_MATCHER = new MethodMatcher("DependencyHandlerSpec constraints(..)");
    private static final MethodMatcher INDIVIDUAL_CONSTRAINTS_MATCHER = new MethodMatcher("DependencyHandlerSpec *(..)");
    private static final VersionComparator VERSION_COMPARATOR = Objects.requireNonNull((VersionComparator)Semver.validate((String)"latest.release", null).getValue());

    public String getDisplayName() {
        return "Remove redundant explicit dependency versions";
    }

    public String getDescription() {
        return "Remove explicitly-specified dependency versions that are managed by a Gradle `platform`/`enforcedPlatform`.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check(new IsBuildGradle(), (TreeVisitor)new GroovyIsoVisitor<ExecutionContext>(){
            GradleProject gp;
            final Map<String, List<ResolvedPom>> platforms = new HashMap<String, List<ResolvedPom>>();

            public G.CompilationUnit visitCompilationUnit(G.CompilationUnit cu, ExecutionContext ctx) {
                Optional maybeGp = cu.getMarkers().findFirst(GradleProject.class);
                if (!maybeGp.isPresent()) {
                    return cu;
                }
                this.gp = (GradleProject)maybeGp.get();
                new GroovyIsoVisitor<ExecutionContext>(){
                    final MethodMatcher platformMatcher = new MethodMatcher("org.gradle.api.artifacts.dsl.DependencyHandler platform(..)");
                    final MethodMatcher enforcedPlatformMatcher = new MethodMatcher("org.gradle.api.artifacts.dsl.DependencyHandler enforcedPlatform(..)");

                    public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                        J.MethodInvocation m = super.visitMethodInvocation(method, (Object)ctx);
                        if (!this.platformMatcher.matches((MethodCall)m) && !this.enforcedPlatformMatcher.matches((MethodCall)m)) {
                            return m;
                        }
                        if (m.getArguments().get(0) instanceof J.Literal) {
                            J.Literal l = (J.Literal)m.getArguments().get(0);
                            if (l.getType() != JavaType.Primitive.String) {
                                return m;
                            }
                            Dependency dependency = DependencyStringNotationConverter.parse((String)l.getValue());
                            MavenPomDownloader mpd = new MavenPomDownloader(ctx);
                            try {
                                ResolvedPom platformPom = mpd.download(new GroupArtifactVersion(dependency.getGroupId(), dependency.getArtifactId(), dependency.getVersion()), null, null, gp.getMavenRepositories()).resolve(Collections.emptyList(), mpd, ctx);
                                platforms.computeIfAbsent(((J.MethodInvocation)this.getCursor().getParent(1).firstEnclosing(J.MethodInvocation.class)).getSimpleName(), k -> new ArrayList()).add(platformPom);
                            }
                            catch (MavenDownloadingException e) {
                                return m;
                            }
                        }
                        if (m.getArguments().get(0) instanceof G.MapEntry) {
                            String groupId = null;
                            String artifactId = null;
                            String version = null;
                            for (Expression arg : m.getArguments()) {
                                G.MapEntry entry;
                                if (!(arg instanceof G.MapEntry) || !((entry = (G.MapEntry)arg).getKey() instanceof J.Literal) || !(entry.getValue() instanceof J.Literal)) continue;
                                J.Literal key = (J.Literal)entry.getKey();
                                J.Literal value = (J.Literal)entry.getValue();
                                if (key.getType() != JavaType.Primitive.String || value.getType() != JavaType.Primitive.String) continue;
                                switch ((String)key.getValue()) {
                                    case "group": {
                                        groupId = (String)value.getValue();
                                        break;
                                    }
                                    case "name": {
                                        artifactId = (String)value.getValue();
                                        break;
                                    }
                                    case "version": {
                                        version = (String)value.getValue();
                                    }
                                }
                            }
                            if (groupId == null || artifactId == null || version == null) {
                                return m;
                            }
                            MavenPomDownloader mpd = new MavenPomDownloader(ctx);
                            try {
                                ResolvedPom platformPom = mpd.download(new GroupArtifactVersion(groupId, artifactId, version), null, null, gp.getMavenRepositories()).resolve(Collections.emptyList(), mpd, ctx);
                                platforms.computeIfAbsent(((J.MethodInvocation)this.getCursor().getParent(1).firstEnclosing(J.MethodInvocation.class)).getSimpleName(), k -> new ArrayList()).add(platformPom);
                            }
                            catch (MavenDownloadingException e) {
                                return m;
                            }
                        }
                        return m;
                    }
                }.visit((Tree)cu, (Object)ctx);
                cu = (G.CompilationUnit)new GroovyIsoVisitor<ExecutionContext>(){

                    public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                        J.MethodInvocation m = super.visitMethodInvocation(method, (Object)ctx);
                        if (CONSTRAINTS_MATCHER.matches((MethodCall)m)) {
                            if (m.getArguments().isEmpty() || !(m.getArguments().get(0) instanceof J.Lambda)) {
                                return m;
                            }
                            J.Lambda l = (J.Lambda)m.getArguments().get(0);
                            if (!(l.getBody() instanceof J.Block)) {
                                return m;
                            }
                            J.Block b = (J.Block)l.getBody();
                            if (b.getStatements().isEmpty()) {
                                return null;
                            }
                            return m;
                        }
                        if (INDIVIDUAL_CONSTRAINTS_MATCHER.matches((MethodCall)m)) {
                            if (!TypeUtils.isAssignableTo((String)"org.gradle.api.artifacts.Dependency", (JavaType)Objects.requireNonNull(m.getMethodType()).getReturnType())) {
                                return m;
                            }
                            if (m.getArguments().isEmpty() || !(m.getArguments().get(0) instanceof J.Literal) || !(((J.Literal)m.getArguments().get(0)).getValue() instanceof String)) {
                                return m;
                            }
                            if (this.shouldRemoveRedundantConstraint((String)((J.Literal)m.getArguments().get(0)).getValue(), m.getSimpleName())) {
                                return null;
                            }
                        }
                        return m;
                    }

                    public J.Return visitReturn(J.Return _return, ExecutionContext ctx) {
                        J.Return r = super.visitReturn(_return, (Object)ctx);
                        if (r.getExpression() == null) {
                            return null;
                        }
                        return r;
                    }

                    boolean shouldRemoveRedundantConstraint(String dependencyNotation, String configurationName) {
                        return this.shouldRemoveRedundantConstraint(DependencyStringNotationConverter.parse(dependencyNotation), gp.getConfiguration(configurationName));
                    }

                    boolean shouldRemoveRedundantConstraint(@Nullable Dependency constraint, @Nullable GradleDependencyConfiguration c) {
                        if (c == null || constraint == null || constraint.getVersion() == null) {
                            return false;
                        }
                        if (constraint.getVersion().contains("[") || constraint.getVersion().contains("!!")) {
                            return false;
                        }
                        if (RemoveRedundantDependencyVersions.this.groupPattern != null && !StringUtils.matchesGlob((String)constraint.getGroupId(), (String)RemoveRedundantDependencyVersions.this.groupPattern) || RemoveRedundantDependencyVersions.this.artifactPattern != null && !StringUtils.matchesGlob((String)constraint.getArtifactId(), (String)RemoveRedundantDependencyVersions.this.artifactPattern)) {
                            return false;
                        }
                        return Stream.concat(Stream.of(c), gp.configurationsExtendingFrom(c, true).stream()).filter(GradleDependencyConfiguration::isCanBeResolved).distinct().map(conf -> conf.findResolvedDependency(Objects.requireNonNull(constraint.getGroupId()), constraint.getArtifactId())).filter(Objects::nonNull).anyMatch(resolvedDependency -> VERSION_COMPARATOR.compare(null, resolvedDependency.getVersion(), constraint.getVersion()) > 0);
                    }
                }.visitNonNull((Tree)cu, (Object)ctx);
                return super.visitCompilationUnit(cu, (Object)ctx);
            }

            public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                GradleDependencyConfiguration gdc;
                J.MethodInvocation m = super.visitMethodInvocation(method, (Object)ctx);
                Optional maybeGradleDependency = new GradleDependency.Matcher().groupId(RemoveRedundantDependencyVersions.this.groupPattern).artifactId(RemoveRedundantDependencyVersions.this.artifactPattern).get(this.getCursor());
                if (!maybeGradleDependency.isPresent()) {
                    return m;
                }
                GradleDependency gradleDependency = (GradleDependency)maybeGradleDependency.get();
                ResolvedDependency d = gradleDependency.getResolvedDependency();
                if (StringUtils.isBlank((String)d.getVersion())) {
                    return m;
                }
                if (this.platforms.containsKey(m.getSimpleName())) {
                    for (ResolvedPom platform : this.platforms.get(m.getSimpleName())) {
                        String managedVersion = platform.getManagedVersion(d.getGroupId(), d.getArtifactId(), null, d.getRequested().getClassifier());
                        if (!RemoveRedundantDependencyVersions.this.matchesComparator(managedVersion, d.getVersion())) continue;
                        return this.maybeRemoveVersion(m);
                    }
                }
                if ((gdc = this.gp.getConfiguration(m.getSimpleName())) != null) {
                    for (GradleDependencyConfiguration configuration : gdc.allExtendsFrom()) {
                        if (!this.platforms.containsKey(configuration.getName())) continue;
                        for (ResolvedPom platform : this.platforms.get(configuration.getName())) {
                            String managedVersion = platform.getManagedVersion(d.getGroupId(), d.getArtifactId(), null, d.getRequested().getClassifier());
                            if (!RemoveRedundantDependencyVersions.this.matchesComparator(managedVersion, d.getVersion())) continue;
                            return this.maybeRemoveVersion(m);
                        }
                    }
                }
                return m;
            }

            private J.MethodInvocation maybeRemoveVersion(J.MethodInvocation m) {
                if (m.getArguments().get(0) instanceof J.Literal) {
                    J.Literal l = (J.Literal)m.getArguments().get(0);
                    if (l.getType() != JavaType.Primitive.String) {
                        return m;
                    }
                    Dependency dep = DependencyStringNotationConverter.parse((String)l.getValue()).withVersion(null);
                    if (dep.getClassifier() != null || dep.getExt() != null) {
                        return m;
                    }
                    return m.withArguments(ListUtils.mapFirst((List)m.getArguments(), arg -> ChangeStringLiteral.withStringValue(l, dep.toStringNotation())));
                }
                if (m.getArguments().get(0) instanceof G.MapLiteral) {
                    return m.withArguments(ListUtils.mapFirst((List)m.getArguments(), arg -> {
                        G.MapLiteral mapLiteral = (G.MapLiteral)arg;
                        return mapLiteral.withElements(ListUtils.map((List)mapLiteral.getElements(), entry -> {
                            if (entry.getKey() instanceof J.Literal && "version".equals(((J.Literal)entry.getKey()).getValue())) {
                                return null;
                            }
                            return entry;
                        }));
                    }));
                }
                if (m.getArguments().get(0) instanceof G.MapEntry) {
                    return m.withArguments(ListUtils.map((List)m.getArguments(), arg -> {
                        G.MapEntry entry = (G.MapEntry)arg;
                        if (entry.getKey() instanceof J.Literal && "version".equals(((J.Literal)entry.getKey()).getValue())) {
                            return null;
                        }
                        return entry;
                    }));
                }
                return m;
            }
        });
    }

    private Comparator determineComparator() {
        if (this.onlyIfManagedVersionIs != null) {
            return this.onlyIfManagedVersionIs;
        }
        return Comparator.EQ;
    }

    private boolean matchesComparator(@Nullable String managedVersion, String requestedVersion) {
        Comparator comparator = this.determineComparator();
        if (managedVersion == null) {
            return false;
        }
        if (comparator == Comparator.ANY) {
            return true;
        }
        if (!this.isExact(managedVersion)) {
            return false;
        }
        int comparison = new LatestIntegration(null).compare(null, managedVersion, requestedVersion);
        if (comparison < 0) {
            return comparator == Comparator.LT || comparator == Comparator.LTE;
        }
        if (comparison > 0) {
            return comparator == Comparator.GT || comparator == Comparator.GTE;
        }
        return comparator == Comparator.EQ || comparator == Comparator.LTE || comparator == Comparator.GTE;
    }

    private boolean isExact(String managedVersion) {
        Validated maybeVersionComparator = Semver.validate((String)managedVersion, null);
        return maybeVersionComparator.isValid() && maybeVersionComparator.getValue() instanceof ExactVersion;
    }

    @Generated
    public RemoveRedundantDependencyVersions(@Nullable String groupPattern, @Nullable String artifactPattern, @Nullable Comparator onlyIfManagedVersionIs, @Nullable List<String> except) {
        this.groupPattern = groupPattern;
        this.artifactPattern = artifactPattern;
        this.onlyIfManagedVersionIs = onlyIfManagedVersionIs;
        this.except = except;
    }

    @Generated
    public @Nullable String getGroupPattern() {
        return this.groupPattern;
    }

    @Generated
    public @Nullable String getArtifactPattern() {
        return this.artifactPattern;
    }

    @Generated
    public @Nullable Comparator getOnlyIfManagedVersionIs() {
        return this.onlyIfManagedVersionIs;
    }

    @Generated
    public @Nullable List<String> getExcept() {
        return this.except;
    }

    @NonNull
    @Generated
    public String toString() {
        return "RemoveRedundantDependencyVersions(groupPattern=" + this.getGroupPattern() + ", artifactPattern=" + this.getArtifactPattern() + ", onlyIfManagedVersionIs=" + (Object)((Object)this.getOnlyIfManagedVersionIs()) + ", except=" + this.getExcept() + ")";
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RemoveRedundantDependencyVersions)) {
            return false;
        }
        RemoveRedundantDependencyVersions other = (RemoveRedundantDependencyVersions)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$groupPattern = this.getGroupPattern();
        String other$groupPattern = other.getGroupPattern();
        if (this$groupPattern == null ? other$groupPattern != null : !this$groupPattern.equals(other$groupPattern)) {
            return false;
        }
        String this$artifactPattern = this.getArtifactPattern();
        String other$artifactPattern = other.getArtifactPattern();
        if (this$artifactPattern == null ? other$artifactPattern != null : !this$artifactPattern.equals(other$artifactPattern)) {
            return false;
        }
        Comparator this$onlyIfManagedVersionIs = this.getOnlyIfManagedVersionIs();
        Comparator other$onlyIfManagedVersionIs = other.getOnlyIfManagedVersionIs();
        if (this$onlyIfManagedVersionIs == null ? other$onlyIfManagedVersionIs != null : !((Object)((Object)this$onlyIfManagedVersionIs)).equals((Object)other$onlyIfManagedVersionIs)) {
            return false;
        }
        List<String> this$except = this.getExcept();
        List<String> other$except = other.getExcept();
        return !(this$except == null ? other$except != null : !((Object)this$except).equals(other$except));
    }

    @Generated
    protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
        return other instanceof RemoveRedundantDependencyVersions;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $groupPattern = this.getGroupPattern();
        result = result * 59 + ($groupPattern == null ? 43 : $groupPattern.hashCode());
        String $artifactPattern = this.getArtifactPattern();
        result = result * 59 + ($artifactPattern == null ? 43 : $artifactPattern.hashCode());
        Comparator $onlyIfManagedVersionIs = this.getOnlyIfManagedVersionIs();
        result = result * 59 + ($onlyIfManagedVersionIs == null ? 43 : ((Object)((Object)$onlyIfManagedVersionIs)).hashCode());
        List<String> $except = this.getExcept();
        result = result * 59 + ($except == null ? 43 : ((Object)$except).hashCode());
        return result;
    }

    public static enum Comparator {
        ANY,
        EQ,
        LT,
        LTE,
        GT,
        GTE;

    }
}

