/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.wikitty.struts.component;

import com.opensymphony.xwork2.util.ValueStack;
import java.util.Collection;
import java.util.LinkedList;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.views.annotations.StrutsTag;
import org.nuiton.util.StringUtil;
import org.nuiton.wikitty.entities.BusinessEntity;
import org.nuiton.wikitty.entities.Wikitty;
import org.nuiton.wikitty.struts.Option;
import org.nuiton.wikitty.struts.TagUseException;
import org.nuiton.wikitty.struts.WikittyFieldHandler;
import org.nuiton.wikitty.struts.component.AbstractWikittyClosingUIBean;

@StrutsTag(name="boolean", tldTagClass="org.nuiton.wikitty.struts.tag.SelectTag", description="", allowDynamicAttributes=false)
public class SelectBean
extends AbstractWikittyClosingUIBean {
    private static final Log log = LogFactory.getLog(SelectBean.class);
    public static final String OPEN_TEMPLATE = "ws-select";
    protected Integer size;
    protected String descField;
    protected Collection<Wikitty> wikittyValues;
    protected Collection<? extends BusinessEntity> entityValues;

    public SelectBean(ValueStack stack, HttpServletRequest request, HttpServletResponse response) {
        super(stack, request, response);
    }

    @Override
    protected void evaluateExtraParams() {
        String[] descTable;
        String desc;
        Option temp;
        super.evaluateExtraParams();
        if (this.wikittyValues == null && this.entityValues == null) {
            log.info((Object)"wikittyValues and entityValues null");
            throw new TagUseException("WikittyValues or entityValues must be define");
        }
        if (this.size == null || this.size <= 0) {
            this.size = 1;
        }
        this.addParameter("selectSize", this.size);
        LinkedList<Option> resultList = new LinkedList<Option>();
        String[] descriptor = StringUtil.split((String)this.descField, (String)WikittyFieldHandler.FIELD_SEPARATOR);
        if (this.wikittyValues != null) {
            for (Wikitty wikitty : this.wikittyValues) {
                temp = new Option();
                temp.setValeur(wikitty.getId());
                desc = wikitty.getId();
                if (descriptor.length != 0) {
                    desc = "";
                    for (String descriptorIt : descriptor) {
                        descTable = StringUtil.split((String)descriptorIt, (String)".");
                        desc = desc + wikitty.getFieldAsWikitty(descTable[0], descTable[1]);
                    }
                }
                temp.setDescription(desc);
                resultList.add(temp);
            }
        }
        if (this.entityValues != null) {
            for (BusinessEntity businessEntity : this.entityValues) {
                temp = new Option();
                temp.setValeur(businessEntity.getWikittyId());
                desc = businessEntity.getWikittyId();
                if (descriptor.length != 0) {
                    desc = "";
                    for (String descriptorIt : descriptor) {
                        descTable = StringUtil.split((String)descriptorIt, (String)".");
                        desc = desc + businessEntity.getField(descTable[0], descTable[1]);
                    }
                }
                temp.setDescription(desc);
                resultList.add(temp);
            }
        }
        this.addParameter("value", resultList);
    }

    public String getDefaultOpenTemplate() {
        return OPEN_TEMPLATE;
    }

    protected String getDefaultTemplate() {
        return "ws-empty";
    }

    public Integer getSize() {
        return this.size;
    }

    public void setSize(Integer size) {
        this.size = size;
    }

    public String getDescField() {
        return this.descField;
    }

    public void setDescField(String descField) {
        this.descField = descField;
    }

    public Collection<Wikitty> getWikittyValues() {
        return this.wikittyValues;
    }

    public void setWikittyValues(Collection<Wikitty> wikittyValues) {
        this.wikittyValues = wikittyValues;
    }

    public Collection<? extends BusinessEntity> getEntityValues() {
        return this.entityValues;
    }

    public void setEntityValues(Collection<? extends BusinessEntity> entityValues) {
        this.entityValues = entityValues;
    }
}

