/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.wikitty.storage.solr;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.SolrServer;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.params.SolrParams;
import org.nuiton.util.TimeLog;
import org.nuiton.wikitty.WikittyException;
import org.nuiton.wikitty.entities.FieldType;
import org.nuiton.wikitty.entities.WikittyTypes;
import org.nuiton.wikitty.storage.solr.ElementModifier;
import org.nuiton.wikitty.storage.solr.WikittySolrConstant;

public class SolrUtil
implements WikittySolrConstant {
    private static final Log log = LogFactory.getLog(SolrUtil.class);
    private static final TimeLog timeLog = new TimeLog(SolrUtil.class);

    public static Set<String> getAttachedTreeNode(SolrDocument doc) {
        HashSet<String> result = new HashSet<String>();
        for (String field : doc.getFieldNames()) {
            if (!field.startsWith("#tree.attached.")) continue;
            String id = field.substring("#tree.attached.".length());
            result.add(id);
        }
        return result;
    }

    public static SolrDocument findById(SolrServer solrServer, String id) {
        QueryResponse response;
        id = SolrUtil.quoteForSolr(id);
        SolrQuery query = new SolrQuery("#id:" + id);
        try {
            response = solrServer.query((SolrParams)query);
        }
        catch (SolrServerException eee) {
            throw new WikittyException("Error during find", (Throwable)eee);
        }
        SolrDocumentList results = response.getResults();
        long numFound = results.getNumFound();
        if (numFound == 1L) {
            return (SolrDocument)results.get(0);
        }
        return null;
    }

    public static Map<String, SolrDocument> findAllById(SolrServer solrServer, Collection<String> ids) {
        String solrField = "#id";
        Map<String, SolrDocument> result = SolrUtil.findAllByField(solrServer, solrField, ids);
        return result;
    }

    public static Map<String, SolrDocument> findAllByParents(SolrServer solrServer, Collection<String> ids) {
        String solrField = "#tree.parents";
        Map<String, SolrDocument> result = SolrUtil.findAllByField(solrServer, solrField, ids);
        return result;
    }

    public static Map<String, SolrDocument> findAllByAttachment(SolrServer solrServer, Collection<String> ids) {
        String solrField = SolrUtil.getSolrFieldName("WikittyTreeNode.attachment", WikittyTypes.WIKITTY);
        Map<String, SolrDocument> result = SolrUtil.findAllByField(solrServer, solrField, ids);
        return result;
    }

    public static Map<String, SolrDocument> findAllByField(SolrServer solrServer, String solrField, Collection<String> ids) {
        HashMap<String, SolrDocument> result = new HashMap<String, SolrDocument>();
        if (ids != null && ids.size() > 0) {
            try {
                String request = solrField + ":(";
                String or = "";
                for (String id : ids) {
                    id = SolrUtil.quoteForSolr(id);
                    request = request + or + id;
                    or = " OR ";
                }
                request = request + ")";
                SolrQuery query = new SolrQuery(request);
                QueryResponse response = SolrUtil.executeQuery(solrServer, query);
                SolrDocumentList results = response.getResults();
                for (SolrDocument doc : results) {
                    String id = SolrUtil.getStringFieldValue(doc, "#id");
                    result.put(id, doc);
                }
            }
            catch (SolrServerException eee) {
                throw new WikittyException("Error during find", (Throwable)eee);
            }
        }
        return result;
    }

    public static QueryResponse executeQuery(SolrServer solrServer, SolrQuery query) throws SolrServerException {
        long start = TimeLog.getTime();
        if (query.getRows() == null) {
            query.setRows(Integer.valueOf(Integer.MAX_VALUE));
        }
        QueryResponse result = solrServer.query((SolrParams)query);
        long numGet = result.getResults().size();
        long numfound = result.getResults().getNumFound();
        timeLog.log(start, "executeQuery", String.format("nb result %s/%s query was '%s'", numGet, numfound, query));
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("nb result %s/%s query was '%s'", numGet, numfound, query));
        }
        return result;
    }

    public static Map<String, Object> convertToTypedMap(SolrDocument doc) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        for (String solrField : doc.getFieldNames()) {
            String fieldName = ElementModifier.convertToField(solrField);
            String fieldType = StringUtils.substringAfter((String)solrField, (String)fieldName);
            if (StringUtils.startsWith((CharSequence)fieldName, (CharSequence)"#")) continue;
            FieldType type = fieldType.startsWith("_b") ? new FieldType(WikittyTypes.BOOLEAN, 0, Integer.MAX_VALUE) : (fieldType.startsWith("_dt") ? new FieldType(WikittyTypes.DATE, 0, Integer.MAX_VALUE) : (fieldType.startsWith("_d") ? new FieldType(WikittyTypes.NUMERIC, 0, Integer.MAX_VALUE) : new FieldType(WikittyTypes.STRING, 0, Integer.MAX_VALUE)));
            Collection values = doc.getFieldValues(solrField);
            values = (Collection)type.getValidValue((Object)values);
            Object value = values.isEmpty() ? null : (values.size() == 1 ? values.iterator().next() : values);
            result.put(fieldName, value);
        }
        return result;
    }

    public static String getSolrFieldName(String fqfieldName, WikittyTypes type) {
        String result = fqfieldName;
        if (type != null) {
            switch (type) {
                case BINARY: {
                    result = fqfieldName + "_bi";
                    break;
                }
                case BOOLEAN: {
                    result = fqfieldName + "_b";
                    break;
                }
                case DATE: {
                    result = fqfieldName + "_dt";
                    break;
                }
                case STRING: {
                    result = fqfieldName + "_s";
                    break;
                }
                case NUMERIC: {
                    result = fqfieldName + "_d";
                    break;
                }
                case WIKITTY: {
                    result = fqfieldName + "_w";
                    break;
                }
                default: {
                    result = fqfieldName;
                }
            }
        }
        return result;
    }

    public static void copySolrDocument(SolrDocument source, SolrInputDocument dest, String[] fieldToInclude, String[] fieldToExclude) {
        Collection fieldNames = source.getFieldNames();
        HashSet<String> fieldToCopy = new HashSet<String>();
        if (fieldToInclude == null || fieldToInclude.length == 0) {
            fieldToCopy.addAll(fieldNames);
        } else {
            block0: for (String fieldName : fieldNames) {
                for (String fieldRegexp : fieldToInclude) {
                    if (!fieldName.matches(fieldRegexp)) continue;
                    fieldToCopy.add(fieldName);
                    continue block0;
                }
            }
        }
        if (fieldToExclude != null && fieldToExclude.length > 0) {
            block2: for (String fieldName : fieldNames) {
                for (String fieldRegexp : fieldToExclude) {
                    if (!fieldName.matches(fieldRegexp)) continue;
                    fieldToCopy.remove(fieldName);
                    continue block2;
                }
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Copiable field are %s but only field %s are copied", fieldNames, fieldToCopy));
        }
        for (String fieldName : fieldToCopy) {
            dest.removeField(fieldName);
            Collection fieldValues = source.getFieldValues(fieldName);
            for (Object fieldValue : fieldValues) {
                dest.addField(fieldName, fieldValue);
            }
        }
    }

    public static void copySolrDocument(SolrDocument source, SolrInputDocument dest, String ... fieldToInclude) {
        SolrUtil.copySolrDocument(source, dest, fieldToInclude, null);
    }

    public static void copySolrDocumentExcludeSomeField(SolrDocument source, SolrInputDocument dest, String ... fieldToExclude) {
        SolrUtil.copySolrDocument(source, dest, null, fieldToExclude);
    }

    public static Collection<String> getStringFieldValues(SolrDocument d, String fieldname) {
        Collection<String> result = SolrUtil.getStringFieldValues(d, fieldname, null);
        return result;
    }

    public static Collection<String> getStringFieldValues(SolrInputDocument d, String fieldname) {
        Collection<String> result = SolrUtil.getStringFieldValues(d, fieldname, null);
        return result;
    }

    public static Collection<String> getStringFieldValues(SolrDocument d, String fieldname, WikittyTypes type) {
        Collection tmp;
        String solrFieldName = SolrUtil.getSolrFieldName(fieldname, type);
        Collection result = tmp = d.getFieldValues(solrFieldName);
        return result;
    }

    public static Collection<String> getStringFieldValues(SolrInputDocument d, String fieldname, WikittyTypes type) {
        Collection tmp;
        String solrFieldName = SolrUtil.getSolrFieldName(fieldname, type);
        Collection result = tmp = d.getFieldValues(solrFieldName);
        return result;
    }

    public static String getStringFieldValue(SolrInputDocument d, String fieldname) {
        String result = SolrUtil.getStringFieldValue(d, fieldname, null);
        return result;
    }

    public static String getStringFieldValue(SolrInputDocument d, String fieldname, WikittyTypes type) {
        String solrFieldName = SolrUtil.getSolrFieldName(fieldname, type);
        Object value = d.getFieldValue(solrFieldName);
        String result = SolrUtil.convertToString(value, solrFieldName);
        return result;
    }

    public static String getStringFieldValue(SolrDocument d, String fieldname) {
        String result = SolrUtil.getStringFieldValue(d, fieldname, null);
        return result;
    }

    public static String getStringFieldValue(SolrDocument d, String fieldname, WikittyTypes type) {
        String solrFieldName = SolrUtil.getSolrFieldName(fieldname, type);
        Object value = d.getFieldValue(solrFieldName);
        String result = SolrUtil.convertToString(value, solrFieldName);
        return result;
    }

    public static Integer getIntFieldValue(SolrDocument d, String fieldname) {
        Integer result = SolrUtil.getIntFieldValue(d, fieldname, null);
        return result;
    }

    public static Integer getIntFieldValue(SolrDocument d, String fieldname, WikittyTypes type) {
        String solrFieldName = SolrUtil.getSolrFieldName(fieldname, type);
        Object value = d.getFieldValue(solrFieldName);
        Integer result = SolrUtil.convertToInteger(value, solrFieldName);
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String convertToString(Object value, String solrFieldName) {
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return (String)value;
        }
        if (value instanceof String[]) {
            String[] values = (String[])value;
            if (values.length == 0) {
                return null;
            }
            if (values.length != 1) throw new WikittyException(String.format("You can't get one value from field (%s) with many (%s) value", solrFieldName, values.length));
            return values[0];
        }
        if (!(value instanceof Collection)) throw new WikittyException(String.format("Field (%s) is not an String but %s", solrFieldName, value.getClass().getName()));
        Collection c = (Collection)value;
        if (c.isEmpty()) {
            return null;
        }
        if (c.size() != 1) throw new WikittyException(String.format("You can't get one value from field (%s) with many (%s) value", solrFieldName, c.size()));
        Object o = c.iterator().next();
        return SolrUtil.convertToString(o, solrFieldName);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Integer convertToInteger(Object value, String solrFieldName) {
        if (value == null) {
            return null;
        }
        if (value instanceof Integer) {
            return (Integer)value;
        }
        if (!(value instanceof Integer[])) throw new WikittyException(String.format("Field (%s) is not an Integer but %s", solrFieldName, value.getClass().getName()));
        Integer[] values = (Integer[])value;
        if (values.length == 0) {
            return null;
        }
        if (values.length != 1) throw new WikittyException(String.format("You can't get one value from field (%s) with many (%s) value", solrFieldName, values.length));
        return values[0];
    }

    public static Object getOneValue(Object value) {
        Object result;
        if (value == null) {
            result = null;
        } else if (value instanceof Object[]) {
            Object[] values = (Object[])value;
            result = values.length == 0 ? null : values[0];
        } else if (value instanceof Collection) {
            Collection c = (Collection)value;
            if (c.isEmpty()) {
                result = null;
            } else {
                Object o = c.iterator().next();
                result = SolrUtil.getOneValue(o);
            }
        } else {
            result = value;
        }
        return result;
    }

    public static String quoteForSolr(String s) {
        String result = s.replaceAll(":", "\\\\:");
        return result;
    }
}

