/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.wikitty.storage.solr;

import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.wikitty.WikittyException;
import org.nuiton.wikitty.entities.Element;
import org.nuiton.wikitty.entities.ElementExtension;
import org.nuiton.wikitty.entities.ElementField;
import org.nuiton.wikitty.entities.ElementId;
import org.nuiton.wikitty.entities.ElementNode;
import org.nuiton.wikitty.entities.FieldType;
import org.nuiton.wikitty.entities.WikittyExtension;
import org.nuiton.wikitty.entities.WikittyTypes;
import org.nuiton.wikitty.services.WikittyTransaction;
import org.nuiton.wikitty.storage.WikittyExtensionStorage;
import org.nuiton.wikitty.storage.solr.SolrUtil;

public class ElementModifier {
    private static Log log = LogFactory.getLog(ElementModifier.class);
    protected WikittyExtensionStorage extensionStorage;

    public ElementModifier(WikittyExtensionStorage extensionStorage) {
        this.extensionStorage = extensionStorage;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String convertToSolr(WikittyTransaction tx, Element element) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Element: " + element.getValue() + "(" + element.getClass() + ")"));
        }
        if (element instanceof ElementId) {
            return "#id";
        }
        if (element instanceof ElementExtension) {
            return "#extensions";
        }
        if (element instanceof ElementNode) {
            if (element.equals((Object)Element.NODE_ROOT)) {
                return "#tree.root";
            }
            if (element.equals((Object)Element.NODE_PATH)) {
                return "#tree.parents";
            }
            if (!element.equals((Object)Element.NODE_DEPTH)) throw new WikittyException("Unknow ElementNode: " + element.getValue());
            return "#tree.depth";
        }
        if (!(element instanceof ElementField)) throw new WikittyException(String.format("Unsupported Element type '%s'", ClassUtils.getShortCanonicalName((Object)element, (String)"null")));
        String fieldValue = element.getValue();
        if (StringUtils.startsWith((CharSequence)fieldValue, (CharSequence)"#")) {
            return fieldValue;
        }
        String[] searchField = fieldValue.split("\\.");
        if (searchField.length >= 2) {
            String result;
            String extName = searchField[0];
            String fieldName = searchField[1];
            if ("*".equals(extName) && "*".equals(fieldName)) {
                return "#fulltext";
            }
            if ("*".equals(extName)) {
                result = "#all." + fieldName;
                String modifier = "";
                if (searchField.length >= 3) {
                    String fieldNameType = searchField[2];
                    WikittyTypes type = WikittyTypes.valueOf((String)fieldNameType);
                    modifier = SolrUtil.getSolrFieldName("", type);
                }
                if (!StringUtils.isEmpty((CharSequence)modifier)) return result + modifier;
                if (!log.isDebugEnabled()) return "#ft.all." + fieldName;
                log.debug((Object)"Search on multi extentions (*) without field type, fallback search in fulltext");
                return "#ft.all." + fieldName;
            }
            if ("*".equals(fieldName)) {
                throw new WikittyException("To search on all field of one extension, you must use two condition, one on extension type, other in fulltext '*.*' with the wanted constraint");
            }
            result = extName + "." + fieldName;
            String version = this.extensionStorage.getLastVersion(tx, extName);
            if (version == null) {
                if (!log.isDebugEnabled()) return result;
                log.debug((Object)String.format("Can't find extension '%s'", extName));
                return result;
            } else {
                WikittyExtension ext = this.extensionStorage.restore(tx, extName, version);
                FieldType fieldType = ext.getFieldType(fieldName);
                if (log.isDebugEnabled()) {
                    log.debug((Object)(ext.toDefinition() + " for " + fieldName));
                }
                if (fieldType != null) {
                    WikittyTypes type = fieldType.getType();
                    return SolrUtil.getSolrFieldName(result, type);
                }
                log.info((Object)String.format("Can't find field '%s' in extension '%s' with definition: %s", fieldName, ext.getId(), ext.toDefinition()));
            }
            return result;
        } else {
            if (searchField.length < 1) throw new WikittyException("Empty field name is unsupported");
            if (!"*".equals(searchField[0])) throw new WikittyException("Empty field name is unsupported");
            return "#fulltext";
        }
    }

    public String convertToField(String solrName) {
        String fieldName = solrName.replaceAll("(_bi$)|(_b$)|(_dt$)|(_s$)|(_w$)|(_d$)|(_sortable$)", "");
        if ("#id".equals(fieldName)) {
            fieldName = Element.ID.getValue();
        } else if ("#extensions".equals(fieldName)) {
            fieldName = Element.EXTENSION.getValue();
        } else if ("#tree.root".equals(fieldName)) {
            fieldName = Element.NODE_ROOT.getValue();
        } else if ("#tree.parents".equals(fieldName)) {
            fieldName = Element.NODE_PATH.getValue();
        } else if ("#tree.depth".equals(fieldName)) {
            fieldName = Element.NODE_DEPTH.getValue();
        }
        return fieldName;
    }
}

