/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.wikitty.perftest;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.wikitty.WikittyProxy;
import org.nuiton.wikitty.addons.WikittyLabelUtil;
import org.nuiton.wikitty.perftest.PerfTestUtils;

public class PerfTestLabelSearch {
    private static Log log = LogFactory.getLog(PerfTestLabelSearch.class);

    public static void searchLabel(WikittyProxy proxy, List<String> ids, int loopsToAvg, int threadsNb) {
        long time = System.currentTimeMillis();
        int wikittiesCreated = ids.size();
        HashSet labels = new HashSet();
        for (int k = 0; k < loopsToAvg; ++k) {
            for (String id : ids) {
                labels.addAll(WikittyLabelUtil.findAllAppliedLabels((WikittyProxy)proxy, (String)id));
            }
            int size = labels.size();
            for (String label : labels) {
                WikittyLabelUtil.findAllByLabel((WikittyProxy)proxy, (String)label, (int)0, (int)size);
            }
        }
        time = System.currentTimeMillis() - time;
        PerfTestUtils.out("1 thread took (average on " + loopsToAvg + " loops) " + time / (long)loopsToAvg + " ms to find " + labels.size() + " labels on " + wikittiesCreated + " wikitties\n");
        ArrayList<PerfTestLabelSearchThread> threads = new ArrayList<PerfTestLabelSearchThread>();
        time = System.currentTimeMillis();
        int threadMod = labels.size() % threadsNb != 0 ? 1 : 0;
        for (int j = 0; j < loopsToAvg; ++j) {
            int i;
            for (i = 0; i < threadsNb; ++i) {
                threads.add(new PerfTestLabelSearchThread(wikittiesCreated / threadsNb, proxy, ids, i * (wikittiesCreated / threadsNb)));
            }
            if (threadMod == 1) {
                threads.add(new PerfTestLabelSearchThread(wikittiesCreated % threadsNb, proxy, ids, threadsNb * (wikittiesCreated / threadsNb)));
            }
            for (i = 0; i < threadsNb + threadMod; ++i) {
                ((PerfTestLabelSearchThread)threads.get(i)).start();
            }
            for (i = 0; i < threadsNb + threadMod; ++i) {
                try {
                    ((PerfTestLabelSearchThread)threads.get(i)).join();
                    continue;
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            threads.clear();
        }
        time = System.currentTimeMillis() - time;
        PerfTestUtils.out(threadsNb + (threadMod == 1 ? "(+1)" : "") + " threads took (average on " + loopsToAvg + " loops) " + time / (long)loopsToAvg + " ms to find " + labels.size() / threadsNb + " labels each " + (threadMod == 1 ? "(+" + labels.size() % threadsNb + " labels)" : "") + " on " + wikittiesCreated + " wikitties\n");
    }

    private static class PerfTestLabelSearchThread
    extends Thread {
        private int labelsToSearch;
        private WikittyProxy proxy;
        private List<String> ids;
        private int startAt;

        PerfTestLabelSearchThread(int labelsToSearch, WikittyProxy proxy, List<String> ids, int startAt) {
            this.labelsToSearch = labelsToSearch;
            this.proxy = proxy;
            this.ids = ids;
            this.startAt = startAt;
        }

        @Override
        public void run() {
            HashSet labels = new HashSet();
            for (int i = this.startAt; i < this.labelsToSearch + this.startAt; ++i) {
                labels.addAll(WikittyLabelUtil.findAllAppliedLabels((WikittyProxy)this.proxy, (String)this.ids.get(i)));
            }
            for (String label : labels) {
                WikittyLabelUtil.findAllByLabel((WikittyProxy)this.proxy, (String)label, (int)this.startAt, (int)(this.labelsToSearch + this.startAt));
            }
        }
    }
}

