package org.nuiton.topia.taas.entities;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.persistence.EntityVisitor;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityAbstract;


public abstract class TaasUserAbstract extends TopiaEntityAbstract implements TaasUser {

    protected String login;
    protected String password;
    protected String email;
    protected boolean enabled;
    protected Date lastConnectionDate;
    protected int numberOfConnection;
    public String link;
    public Collection<TaasPrincipal> principals;
    /**
     * update :
     * @throws TopiaException
     */

    public void update() throws TopiaException {
        ((TopiaContextImplementor)getTopiaContext()).getDAO(TaasUser.class).update(this);
}

    /**
     * delete :
     * @throws TopiaException
     */

    public void delete() throws TopiaException {
        ((TopiaContextImplementor)getTopiaContext()).getDAO(TaasUser.class).delete(this);
}

    /**
     * accept :
     * Envoi via les methodes du visitor l'ensemble des champs de l'entity
avec leur nom, type et valeur.
     * @param visitor le visiteur de l'entite.
     * @throws TopiaException
     */

    public void accept(EntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        visitor.visit(this, LOGIN, String.class, login);
        visitor.visit(this, PASSWORD, String.class, password);
        visitor.visit(this, EMAIL, String.class, email);
        visitor.visit(this, ENABLED, boolean.class, enabled);
        visitor.visit(this, LAST_CONNECTION_DATE, Date.class, lastConnectionDate);
        visitor.visit(this, NUMBER_OF_CONNECTION, int.class, numberOfConnection);
        visitor.visit(this, LINK, String.class, link);
        visitor.visit(this, PRINCIPALS, Collection.class, TaasPrincipal.class, principals);
        visitor.end(this);
}

    /**
     * accept :
     * @return List<TopiaEntity> 
     * @throws TopiaException
     */

    public List<TopiaEntity> accept() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            result.add(entity);
            result.addAll(entity.getAggregate());
        }

        return result;
}

    /**
     * getComposite :
     * @return List<TopiaEntity> 
     * @throws TopiaException
     */

    public List<TopiaEntity> getComposite() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            if (entity != null) {
                result.add(entity);
                result.addAll(entity.getComposite());
            }
        }

        return result;
}

    /**
     * setLogin :
     * @param value 
     */

    public void setLogin(String value) {
        String _oldValue = this.login;
        fireOnPreWrite(LOGIN, _oldValue, value);
        this.login = value;
        fireOnPostWrite(LOGIN, _oldValue, value);
}

    /**
     * getLogin :
     * @return String 
     */

    public String getLogin() {
        fireOnPreRead(LOGIN, login);
        String result = this.login;
        fireOnPostRead(LOGIN, login);
        return result;
}

    /**
     * setPassword :
     * @param value 
     */

    public void setPassword(String value) {
        String _oldValue = this.password;
        fireOnPreWrite(PASSWORD, _oldValue, value);
        this.password = value;
        fireOnPostWrite(PASSWORD, _oldValue, value);
}

    /**
     * getPassword :
     * @return String 
     */

    public String getPassword() {
        fireOnPreRead(PASSWORD, password);
        String result = this.password;
        fireOnPostRead(PASSWORD, password);
        return result;
}

    /**
     * setEmail :
     * @param value 
     */

    public void setEmail(String value) {
        String _oldValue = this.email;
        fireOnPreWrite(EMAIL, _oldValue, value);
        this.email = value;
        fireOnPostWrite(EMAIL, _oldValue, value);
}

    /**
     * getEmail :
     * @return String 
     */

    public String getEmail() {
        fireOnPreRead(EMAIL, email);
        String result = this.email;
        fireOnPostRead(EMAIL, email);
        return result;
}

    /**
     * setEnabled :
     * @param value 
     */

    public void setEnabled(boolean value) {
        boolean _oldValue = this.enabled;
        fireOnPreWrite(ENABLED, _oldValue, value);
        this.enabled = value;
        fireOnPostWrite(ENABLED, _oldValue, value);
}

    /**
     * getEnabled :
     * @return boolean 
     */

    public boolean getEnabled() {
        fireOnPreRead(ENABLED, enabled);
        boolean result = this.enabled;
        fireOnPostRead(ENABLED, enabled);
        return result;
}

    /**
     * setLastConnectionDate :
     * @param value 
     */

    public void setLastConnectionDate(Date value) {
        Date _oldValue = this.lastConnectionDate;
        fireOnPreWrite(LAST_CONNECTION_DATE, _oldValue, value);
        this.lastConnectionDate = value;
        fireOnPostWrite(LAST_CONNECTION_DATE, _oldValue, value);
}

    /**
     * getLastConnectionDate :
     * @return Date 
     */

    public Date getLastConnectionDate() {
        fireOnPreRead(LAST_CONNECTION_DATE, lastConnectionDate);
        Date result = this.lastConnectionDate;
        fireOnPostRead(LAST_CONNECTION_DATE, lastConnectionDate);
        return result;
}

    /**
     * setNumberOfConnection :
     * @param value 
     */

    public void setNumberOfConnection(int value) {
        int _oldValue = this.numberOfConnection;
        fireOnPreWrite(NUMBER_OF_CONNECTION, _oldValue, value);
        this.numberOfConnection = value;
        fireOnPostWrite(NUMBER_OF_CONNECTION, _oldValue, value);
}

    /**
     * getNumberOfConnection :
     * @return int 
     */

    public int getNumberOfConnection() {
        fireOnPreRead(NUMBER_OF_CONNECTION, numberOfConnection);
        int result = this.numberOfConnection;
        fireOnPostRead(NUMBER_OF_CONNECTION, numberOfConnection);
        return result;
}

    /**
     * setLink :
     * @param value 
     */

    public void setLink(String value) {
        String _oldValue = this.link;
        fireOnPreWrite(LINK, _oldValue, value);
        this.link = value;
        fireOnPostWrite(LINK, _oldValue, value);
}

    /**
     * getLink :
     * @return String 
     */

    public String getLink() {
        fireOnPreRead(LINK, link);
        String result = this.link;
        fireOnPostRead(LINK, link);
        return result;
}

    /**
     * addPrincipals :
     * @param principals 
     */

    public void addPrincipals(TaasPrincipal principals) {    
        fireOnPreWrite(PRINCIPALS, null, principals);
        if (this.principals == null) {
            this.principals = new ArrayList<TaasPrincipal>();
        }
        this.principals.add(principals);
        fireOnPostWrite(PRINCIPALS, this.principals.size(), null, principals);
}

    /**
     * addAllPrincipals :
     * @param values 
     */

    public void addAllPrincipals(Collection<TaasPrincipal> values) {
        if (values == null) {
            return;
        }
        for (TaasPrincipal item : values) {
            addPrincipals(item);
        }
}

    /**
     * getPrincipalsByTopiaId :
     * @param topiaId 
     * @return TaasPrincipal 
     */

    public TaasPrincipal getPrincipalsByTopiaId(String topiaId) {
        return org.nuiton.topia.persistence.util.TopiaEntityHelper.getEntityByTopiaId(principals, topiaId);
 }

    /**
     * setPrincipals :
     * @param values 
     */

    public void setPrincipals(Collection<TaasPrincipal> values) {
        Collection<TaasPrincipal> _oldValue = principals;
        fireOnPreWrite(PRINCIPALS, _oldValue, values);
        principals = values;
        fireOnPostWrite(PRINCIPALS, _oldValue, values);
}

    /**
     * removePrincipals :
     * @param value 
     */

    public void removePrincipals(TaasPrincipal value) {
        fireOnPreWrite(PRINCIPALS, value, null);
        if ((this.principals == null) || (!this.principals.remove(value))) {
            throw new IllegalArgumentException("List does not contain given element");
        }
        fireOnPostWrite(PRINCIPALS, this.principals.size()+1, value, null);
}

    /**
     * clearPrincipals :
     */

    public void clearPrincipals() {
        if (this.principals == null) {
            return;
        }
        Collection<TaasPrincipal> _oldValue = new ArrayList<TaasPrincipal>(this.principals);
        fireOnPreWrite(PRINCIPALS, _oldValue, this.principals);
        this.principals.clear();
        fireOnPostWrite(PRINCIPALS, _oldValue, this.principals);
}

    /**
     * getPrincipals :
     * @return Collection<TaasPrincipal> 
     */

    public Collection<TaasPrincipal> getPrincipals() {
        return principals;
}

    /**
     * sizePrincipals :
     * @return int 
     */

    public int sizePrincipals() {
        if (principals == null) {
            return 0;
        }
        return principals.size();
}

    /**
     * isPrincipalsEmpty :
     * @return boolean 
     */

    public boolean isPrincipalsEmpty() {
        int size = sizePrincipals();
        return size == 0;
}

    /**
     * toString :
     * @return String 
     */

    @Override
    public String toString() {
        String result = new ToStringBuilder(this).
            append(LOGIN, this.login).
            append(PASSWORD, this.password).
            append(EMAIL, this.email).
            append(ENABLED, this.enabled).
            append(LAST_CONNECTION_DATE, this.lastConnectionDate).
            append(NUMBER_OF_CONNECTION, this.numberOfConnection).
            append(LINK, this.link).
            append(PRINCIPALS, this.principals).
         toString();
        return result;
}


} //TaasUserAbstract
