package org.nuiton.topia.taas.entities;

import java.util.List;


import java.util.Arrays;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;

/**
 * Implantation DAO pour l'entité TaasUser.
 * Cette classe contient une implantation de TopiaDAO a laquel elle peut
 * deleguer des traitements
 * 
 */
public abstract class TaasUserDAOAbstract<E extends TaasUser> extends org.nuiton.topia.persistence.TopiaDAOImpl<E> implements org.nuiton.topia.persistence.TopiaDAO<E> {    

    public Class<E> getEntityClass() {
        return (Class<E>)TaasUser.class;
    }

    public void delete(E entity) throws TopiaException {
        
        super.delete(entity);
    }    
     
    /**
     * Recherche sur l'attribut login
     */

    /**
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut
     * login le paramètre
     * @param v la valeur que doit avoir login
     * @return un element ou null
     */
    public E findByLogin(java.lang.String v) throws TopiaException {
        E result = findByProperty("login", v);
        return result;
    }

    /**
     * Retourne les éléments ayant comme valeur pour l'attribut
     * login le paramètre
     * @param v la valeur que doit avoir login
     * @return une liste
     */
    public List<E> findAllByLogin(java.lang.String v) throws TopiaException {
        List<E> result = findAllByProperty("login", v);
        return result;
    }
    /**
     * Recherche sur l'attribut password
     */

    /**
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut
     * password le paramètre
     * @param v la valeur que doit avoir password
     * @return un element ou null
     */
    public E findByPassword(java.lang.String v) throws TopiaException {
        E result = findByProperty("password", v);
        return result;
    }

    /**
     * Retourne les éléments ayant comme valeur pour l'attribut
     * password le paramètre
     * @param v la valeur que doit avoir password
     * @return une liste
     */
    public List<E> findAllByPassword(java.lang.String v) throws TopiaException {
        List<E> result = findAllByProperty("password", v);
        return result;
    }
    /**
     * Recherche sur l'attribut email
     */

    /**
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut
     * email le paramètre
     * @param v la valeur que doit avoir email
     * @return un element ou null
     */
    public E findByEmail(java.lang.String v) throws TopiaException {
        E result = findByProperty("email", v);
        return result;
    }

    /**
     * Retourne les éléments ayant comme valeur pour l'attribut
     * email le paramètre
     * @param v la valeur que doit avoir email
     * @return une liste
     */
    public List<E> findAllByEmail(java.lang.String v) throws TopiaException {
        List<E> result = findAllByProperty("email", v);
        return result;
    }
    /**
     * Recherche sur l'attribut enabled
     */

    /**
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut
     * enabled le paramètre
     * @param v la valeur que doit avoir enabled
     * @return un element ou null
     */
    public E findByEnabled(boolean v) throws TopiaException {
        E result = findByProperty("enabled", v);
        return result;
    }

    /**
     * Retourne les éléments ayant comme valeur pour l'attribut
     * enabled le paramètre
     * @param v la valeur que doit avoir enabled
     * @return une liste
     */
    public List<E> findAllByEnabled(boolean v) throws TopiaException {
        List<E> result = findAllByProperty("enabled", v);
        return result;
    }
    /**
     * Recherche sur l'attribut lastConnectionDate
     */

    /**
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut
     * lastConnectionDate le paramètre
     * @param v la valeur que doit avoir lastConnectionDate
     * @return un element ou null
     */
    public E findByLastConnectionDate(java.util.Date v) throws TopiaException {
        E result = findByProperty("lastConnectionDate", v);
        return result;
    }

    /**
     * Retourne les éléments ayant comme valeur pour l'attribut
     * lastConnectionDate le paramètre
     * @param v la valeur que doit avoir lastConnectionDate
     * @return une liste
     */
    public List<E> findAllByLastConnectionDate(java.util.Date v) throws TopiaException {
        List<E> result = findAllByProperty("lastConnectionDate", v);
        return result;
    }
    /**
     * Recherche sur l'attribut numberOfConnection
     */

    /**
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut
     * numberOfConnection le paramètre
     * @param v la valeur que doit avoir numberOfConnection
     * @return un element ou null
     */
    public E findByNumberOfConnection(int v) throws TopiaException {
        E result = findByProperty("numberOfConnection", v);
        return result;
    }

    /**
     * Retourne les éléments ayant comme valeur pour l'attribut
     * numberOfConnection le paramètre
     * @param v la valeur que doit avoir numberOfConnection
     * @return une liste
     */
    public List<E> findAllByNumberOfConnection(int v) throws TopiaException {
        List<E> result = findAllByProperty("numberOfConnection", v);
        return result;
    }
    /**
     * Recherche sur l'attribut link
     */

    /**
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut
     * link le paramètre
     * @param v la valeur que doit avoir link
     * @return un element ou null
     */
    public E findByLink(java.lang.String v) throws TopiaException {
        E result = findByProperty("link", v);
        return result;
    }

    /**
     * Retourne les éléments ayant comme valeur pour l'attribut
     * link le paramètre
     * @param v la valeur que doit avoir link
     * @return une liste
     */
    public List<E> findAllByLink(java.lang.String v) throws TopiaException {
        List<E> result = findAllByProperty("link", v);
        return result;
    }
    /**
     * Recherche sur l'attribut principals
     */
    
    /**
     * Retourne le premier élément trouvé dont l'attribut
     * principals contient le paramètre
     * @param v la valeur que doit contenir principals
     * @return un element ou null
     */
    public E findContainsPrincipals(org.nuiton.topia.taas.entities.TaasPrincipal ... v) throws TopiaException {
        E result = findContainsProperties("principals", Arrays.asList(v));
        return result;
    }
    /**
     * Retourne les éléments trouvé dont l'attribut
     * principals contient le paramètre
     * @param v la valeur que doit contenir principals
     * @return une liste
     */
    public List<E> findAllContainsPrincipals(org.nuiton.topia.taas.entities.TaasPrincipal ... v) throws TopiaException {
        List<E> results = findAllContainsProperties("principals", Arrays.asList(v));
        return results;
    }

} // TaasUserDAOAbstract
