package org.nuiton.topia.security.entities.user;

import java.util.List;


import java.util.Arrays;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;

/**
 * Implantation DAO pour l'entité TopiaGroup.
 * Cette classe contient une implantation de TopiaDAO a laquel elle peut
 * deleguer des traitements
 * 
 */
public abstract class TopiaGroupDAOAbstract<E extends TopiaGroup> extends org.nuiton.topia.persistence.TopiaDAOImpl<E> implements org.nuiton.topia.persistence.TopiaDAO<E> {    

    public Class<E> getEntityClass() {
        return (Class<E>)TopiaGroup.class;
    }

    public void delete(E entity) throws TopiaException {

        {
            List<org.nuiton.topia.security.entities.user.TopiaUser> list = getContext().getHibernate().createSQLQuery(
                    "SELECT main.topiaid " +
                    "from topiaUser main, topiagroup_topiauser secondary " +
                    "where main.topiaid=secondary.topiaUser" +
                    " and secondary.topiaGroup='" + entity.getTopiaId() + "'")
                    .addEntity("main", org.nuiton.topia.TopiaSecurityDAOHelper.getImplementationClass(org.nuiton.topia.security.entities.user.TopiaUser.class)).list();
            for (org.nuiton.topia.security.entities.user.TopiaUser item : list) {
                item.removeTopiaGroup(entity);
            }
        }

                {
                List<org.nuiton.topia.security.entities.user.TopiaGroup> list = getContext()
                            .getDAO(org.nuiton.topia.security.entities.user.TopiaGroup.class)
                            .findAllByProperties("superGroup", entity);
                    for (org.nuiton.topia.security.entities.user.TopiaGroup item : list) {
                        item.setSuperGroup(null);

                    }
                }
                
        super.delete(entity);
    }    
     
    /**
     * Recherche sur l'attribut name
     */

    /**
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut
     * name le paramètre
     * @param v la valeur que doit avoir name
     * @return un element ou null
     */
    public E findByName(java.lang.String v) throws TopiaException {
        E result = findByProperty("name", v);
        return result;
    }

    /**
     * Retourne les éléments ayant comme valeur pour l'attribut
     * name le paramètre
     * @param v la valeur que doit avoir name
     * @return une liste
     */
    public List<E> findAllByName(java.lang.String v) throws TopiaException {
        List<E> result = findAllByProperty("name", v);
        return result;
    }
    /**
     * Recherche sur l'attribut description
     */

    /**
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut
     * description le paramètre
     * @param v la valeur que doit avoir description
     * @return un element ou null
     */
    public E findByDescription(java.lang.String v) throws TopiaException {
        E result = findByProperty("description", v);
        return result;
    }

    /**
     * Retourne les éléments ayant comme valeur pour l'attribut
     * description le paramètre
     * @param v la valeur que doit avoir description
     * @return une liste
     */
    public List<E> findAllByDescription(java.lang.String v) throws TopiaException {
        List<E> result = findAllByProperty("description", v);
        return result;
    }
    /**
     * Recherche sur l'attribut topiaUser
     */
    
    /**
     * Retourne le premier élément trouvé dont l'attribut
     * topiaUser contient le paramètre
     * @param v la valeur que doit contenir topiaUser
     * @return un element ou null
     */
    public E findContainsTopiaUser(org.nuiton.topia.security.entities.user.TopiaUser ... v) throws TopiaException {
        E result = findContainsProperties("topiaUser", Arrays.asList(v));
        return result;
    }
    /**
     * Retourne les éléments trouvé dont l'attribut
     * topiaUser contient le paramètre
     * @param v la valeur que doit contenir topiaUser
     * @return une liste
     */
    public List<E> findAllContainsTopiaUser(org.nuiton.topia.security.entities.user.TopiaUser ... v) throws TopiaException {
        List<E> results = findAllContainsProperties("topiaUser", Arrays.asList(v));
        return results;
    }
    /**
     * Recherche sur l'attribut superGroup
     */

    /**
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut
     * superGroup le paramètre
     * @param v la valeur que doit avoir superGroup
     * @return un element ou null
     */
    public E findBySuperGroup(org.nuiton.topia.security.entities.user.TopiaGroup v) throws TopiaException {
        E result = findByProperty("superGroup", v);
        return result;
    }

    /**
     * Retourne les éléments ayant comme valeur pour l'attribut
     * superGroup le paramètre
     * @param v la valeur que doit avoir superGroup
     * @return une liste
     */
    public List<E> findAllBySuperGroup(org.nuiton.topia.security.entities.user.TopiaGroup v) throws TopiaException {
        List<E> result = findAllByProperty("superGroup", v);
        return result;
    }
    /**
     * Recherche sur l'attribut subGroup
     */
    
    /**
     * Retourne le premier élément trouvé dont l'attribut
     * subGroup contient le paramètre
     * @param v la valeur que doit contenir subGroup
     * @return un element ou null
     */
    public E findContainsSubGroup(org.nuiton.topia.security.entities.user.TopiaGroup ... v) throws TopiaException {
        E result = findContainsProperties("subGroup", Arrays.asList(v));
        return result;
    }
    /**
     * Retourne les éléments trouvé dont l'attribut
     * subGroup contient le paramètre
     * @param v la valeur que doit contenir subGroup
     * @return une liste
     */
    public List<E> findAllContainsSubGroup(org.nuiton.topia.security.entities.user.TopiaGroup ... v) throws TopiaException {
        List<E> results = findAllContainsProperties("subGroup", Arrays.asList(v));
        return results;
    }

} // TopiaGroupDAOAbstract
