package org.nuiton.topia.taas.entities;

import org.nuiton.topia.persistence.SearchFields;
import org.nuiton.topia.persistence.TopiaEntity;

@SearchFields (
  txtFields={"login","password","email","link"},
  numFields={"numberOfConnection"},
  boolFields={"enabled"},
  dateFields={"lastConnectionDate"}
)        
public interface TaasUser extends TopiaEntity {

    public static final String LOGIN = "login";

    public static final String PASSWORD = "password";

    public static final String EMAIL = "email";

    public static final String ENABLED = "enabled";

    public static final String LAST_CONNECTION_DATE = "lastConnectionDate";

    public static final String NUMBER_OF_CONNECTION = "numberOfConnection";

    public static final String LINK = "link";

    public static final String PRINCIPALS = "principals";

    /**
     * @param login La valeur de l'attribut login à positionner.
     */
    public void setLogin(java.lang.String login);

    /**
     * @return La valeur de l'attribut login.
     */
    public java.lang.String getLogin();

    /**
     * @param password La valeur de l'attribut password à positionner.
     */
    public void setPassword(java.lang.String password);

    /**
     * @return La valeur de l'attribut password.
     */
    public java.lang.String getPassword();

    /**
     * @param email La valeur de l'attribut email à positionner.
     */
    public void setEmail(java.lang.String email);

    /**
     * @return La valeur de l'attribut email.
     */
    public java.lang.String getEmail();

    /**
     * @param enabled La valeur de l'attribut enabled à positionner.
     */
    public void setEnabled(boolean enabled);

    /**
     * @return La valeur de l'attribut enabled.
     */
    public boolean getEnabled();

    /**
     * @param lastConnectionDate La valeur de l'attribut lastConnectionDate à positionner.
     */
    public void setLastConnectionDate(java.util.Date lastConnectionDate);

    /**
     * @return La valeur de l'attribut lastConnectionDate.
     */
    public java.util.Date getLastConnectionDate();

    /**
     * @param numberOfConnection La valeur de l'attribut numberOfConnection à positionner.
     */
    public void setNumberOfConnection(int numberOfConnection);

    /**
     * @return La valeur de l'attribut numberOfConnection.
     */
    public int getNumberOfConnection();

    /**
     * @param link La valeur de l'attribut link à positionner.
     */
    public void setLink(java.lang.String link);

    /**
     * @return La valeur de l'attribut link.
     */
    public java.lang.String getLink();

    /**
     * @param principals L'instance de principals à ajouter.
     */
    public void addPrincipals(org.nuiton.topia.taas.entities.TaasPrincipal principals);

    /**
     * @param principals Les instances de principals à ajouter.
     */
    public void addAllPrincipals(java.util.Collection<org.nuiton.topia.taas.entities.TaasPrincipal> principals);

    /**
     * @param principals La Collection de principals à positionner.
     */
    public void setPrincipals(java.util.Collection<org.nuiton.topia.taas.entities.TaasPrincipal> principals);

    /**
     * @param principals L'instance de principals à retirer.
     */
    public void removePrincipals(org.nuiton.topia.taas.entities.TaasPrincipal principals);

    /**
     * Vide la Collection de principals.
     */
    public void clearPrincipals();

    /**
     * @return La Liste de principals.
     */
    public java.util.Collection<org.nuiton.topia.taas.entities.TaasPrincipal> getPrincipals();


    /**
     * Recupère l'attribut principals à partir de son topiaId.
     *
     * @param topiaId le topia id de l'entité recherchée
     *
     * @return l'attribut recherché, ou <code>null</code> s'il n'existe pas.
     */
    public org.nuiton.topia.taas.entities.TaasPrincipal getPrincipalsByTopiaId(String topiaId);
 
    /**
     * @return Le nombre d'éléments de la collection principals.
     */
    public int sizePrincipals();

    /**
     * @return <code>true</code> si la collection principals est vide.
     */
    public boolean isPrincipalsEmpty();

} //TaasUser
