/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.replication;

import com.google.common.base.Function;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.junit.Assert;
import org.nuiton.topia.it.legacy.TopiaItLegacyTopiaApplicationContext;
import org.nuiton.topia.persistence.TopiaApplicationContext;
import org.nuiton.topia.persistence.TopiaDao;
import org.nuiton.topia.persistence.TopiaDaoSupplier;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityEnum;
import org.nuiton.topia.persistence.TopiaException;
import org.nuiton.topia.persistence.TopiaPersistenceContext;
import org.nuiton.topia.persistence.util.EntityOperator;
import org.nuiton.topia.persistence.util.EntityOperatorStore;
import org.nuiton.topia.persistence.util.TopiaEntityHelper;
import org.nuiton.topia.replication.TopiaReplicationModelBuilder;
import org.nuiton.topia.replication.TopiaReplicationOperation;
import org.nuiton.topia.replication.TopiaReplicationService;
import org.nuiton.topia.replication.model.ReplicationModel;
import org.nuiton.topia.replication.model.ReplicationNode;
import org.nuiton.topia.replication.model.ReplicationOperationDef;

public abstract class AbstractTopiaReplicationServiceTest
extends Assert {
    protected static TopiaApplicationContext sourceContext;
    protected static TopiaPersistenceContext sourcePC;
    protected TopiaApplicationContext destinationContext;
    protected TopiaReplicationService service;
    protected ReplicationModel model;
    protected static boolean init;
    private static Long testsTimeStamp;
    private static File testsBasedir;
    private static final String TEST_BASEDIR = "target%1$ssurefire-tests%1$s%2$td_%2$tm_%2$tY%1$s%2$tH_%2$tM_%2$tS";
    protected static final Function<Properties, TopiaApplicationContext> CREATE_TOPIA_TEST_APPLICATION_CONTEXT;
    private static int dbCounter;

    public static void after() throws Exception {
        if (sourceContext != null && !sourceContext.isClosed()) {
            sourceContext.close();
        }
        init = false;
    }

    public void setUp() throws Exception {
        if (!init) {
            try {
                sourceContext = this.createDb("source");
            }
            catch (Exception e) {
                this.getLog().error((Object)"could not create db source.", (Throwable)e);
                throw e;
            }
            init = true;
        }
        sourcePC = sourceContext.newPersistenceContext();
        this.service = (TopiaReplicationService)sourceContext.getServices(TopiaReplicationService.class).get("replication");
    }

    public void tearDown() throws Exception {
        if (sourcePC != null) {
            sourcePC.rollback();
            sourcePC.close();
            sourcePC = null;
        }
        this.service = null;
    }

    protected TopiaReplicationModelBuilder getModelBuilder() {
        return this.service.getModelBuilder();
    }

    protected abstract TopiaApplicationContext createDb2(String var1) throws Exception;

    protected abstract TopiaApplicationContext createDb(String var1) throws Exception;

    protected TopiaApplicationContext createReplicateDb(Object contract) throws Exception {
        TopiaApplicationContext rootCtxt = this.createDb2(contract.toString() + dbCounter++);
        return rootCtxt;
    }

    protected abstract TopiaEntityEnum[] getContracts();

    protected abstract Log getLog();

    protected <E extends TopiaEntity> E update(E e) throws TopiaException {
        return (E)sourcePC.findByTopiaId(e.getTopiaId());
    }

    public void testDetectTypes() throws Exception {
    }

    public void testGetOperation() throws Exception {
    }

    public void testDetectAssociations() throws Exception {
    }

    public void testDetectDirectDependencies() throws Exception {
    }

    public void testDetectShell() throws Exception {
    }

    public void testDetectDependencies() throws Exception {
    }

    public void testDetectObjectsToDettach() throws Exception {
    }

    public void testDetectOperations() throws Exception {
    }

    public void testDoReplicate() throws Exception {
    }

    protected void detectTypes(TopiaEntity entity, Object ... expectedCouple) throws TopiaException {
        Set detectTypes = this.service.getModelBuilder().detectTypes(sourceContext, this.getContracts(), new String[]{entity.getTopiaId()});
        AbstractTopiaReplicationServiceTest.assertEquals((String)("expected types : " + Arrays.toString(expectedCouple) + " but was " + detectTypes), (long)expectedCouple.length, (long)detectTypes.size());
        for (Object o : expectedCouple) {
            AbstractTopiaReplicationServiceTest.assertTrue((boolean)detectTypes.contains(o));
        }
    }

    protected void getOperation(Class<? extends TopiaReplicationOperation> operationClass, boolean shouldExist) throws TopiaException {
        TopiaReplicationOperation operation = this.getModelBuilder().getOperationProvider().getOperation(operationClass);
        AbstractTopiaReplicationServiceTest.assertEquals((Object)shouldExist, (Object)(operation != null ? 1 : 0));
    }

    protected void detectAssociations(TopiaEntity entity, Object ... expectedCouple) throws TopiaException {
        this.createModel(entity);
        this.model.detectAssociations(new TopiaEntityEnum[0]);
        AbstractTopiaReplicationServiceTest.assertEquals((long)0L, (long)(expectedCouple.length % 2));
        int j = expectedCouple.length / 2;
        for (int i = 0; i < j; ++i) {
            TopiaEntityEnum src = (TopiaEntityEnum)expectedCouple[2 * i];
            String name = (String)expectedCouple[2 * i + 1];
            ReplicationNode nodeSrc = this.model.getNode(src);
            AbstractTopiaReplicationServiceTest.assertNotNull((String)("association " + name + " not found"), (Object)nodeSrc);
            AbstractTopiaReplicationServiceTest.assertTrue((boolean)nodeSrc.hasAssociation());
            AbstractTopiaReplicationServiceTest.assertTrue((boolean)nodeSrc.getAssociations().containsKey(name));
        }
    }

    protected void detectDirectDependencies(TopiaEntity entity, Object ... expectedCouple) throws TopiaException {
        this.createModel(entity);
        this.model.detectDirectDependencies();
        AbstractTopiaReplicationServiceTest.assertEquals((long)0L, (long)(expectedCouple.length % 2));
        int j = expectedCouple.length / 2;
        for (int i = 0; i < j; ++i) {
            TopiaEntityEnum src = (TopiaEntityEnum)expectedCouple[2 * i];
            String name = (String)expectedCouple[2 * i + 1];
            ReplicationNode nodeSrc = this.model.getNode(src);
            AbstractTopiaReplicationServiceTest.assertTrue((String)(nodeSrc + " should have dependency but was not!"), (boolean)nodeSrc.hasDependency());
            AbstractTopiaReplicationServiceTest.assertTrue((String)(nodeSrc + " should contain dependency " + name + "but was not! (" + nodeSrc.getDependencies() + ")"), (boolean)nodeSrc.getDependencies().containsKey(name));
        }
    }

    protected void detectShell(TopiaEntity entity, TopiaEntityEnum ... expected) throws TopiaException {
        this.createModel(entity);
        this.model.detectAssociations(new TopiaEntityEnum[0]);
        this.model.detectDirectDependencies();
        this.model.detectShell();
        TopiaEntityEnum c = TopiaEntityHelper.getEntityEnum(entity.getClass(), (TopiaEntityEnum[])this.getContracts());
        AbstractTopiaReplicationServiceTest.assertNotNull((Object)c);
        Set shell = this.model.getNode(c).getShell();
        AbstractTopiaReplicationServiceTest.assertEquals((String)("expected shell : " + Arrays.toString(expected) + ", but was " + shell), (long)expected.length, (long)shell.size());
        for (TopiaEntityEnum type : expected) {
            ReplicationNode node = this.model.getNode(type);
            AbstractTopiaReplicationServiceTest.assertTrue((boolean)shell.contains(node));
            AbstractTopiaReplicationServiceTest.assertEquals((Object)type, (Object)node.getContract());
        }
    }

    protected void detectDependencies(TopiaEntity entity, TopiaEntityEnum[] ... expected) throws TopiaException {
        this.createModel(entity);
        this.model.detectAssociations(new TopiaEntityEnum[0]);
        this.model.detectDirectDependencies();
        this.model.detectShell();
        this.model.detectDependencies();
        List dependencies = this.model.getOrder();
        boolean i = false;
        for (ReplicationNode level : dependencies) {
            this.getLog().info((Object)("level " + level + " = " + level));
        }
    }

    protected void detectObjectsToDettach(TopiaEntity entity, Object ... expected) throws TopiaException {
        AbstractTopiaReplicationServiceTest.assertEquals((long)0L, (long)(expected.length % 2));
        this.createModel(entity);
        this.model.detectAssociations(new TopiaEntityEnum[0]);
        this.model.detectDirectDependencies();
        this.model.detectShell();
        this.model.detectDependencies();
        this.model.detectObjectsToDettach();
        HashSet<ReplicationNode> nodes = new HashSet<ReplicationNode>();
        int j = expected.length / 2;
        for (int i = 0; i < j; ++i) {
            TopiaEntityEnum e = (TopiaEntityEnum)expected[2 * i];
            ReplicationNode node = this.model.getNode(e);
            String[] ids = (String[])expected[2 * i + 1];
            AbstractTopiaReplicationServiceTest.assertEquals((Object)(ids.length > 0 ? 1 : 0), (Object)node.hasAssociationsToDettach());
            for (String id : ids) {
                AbstractTopiaReplicationServiceTest.assertTrue((boolean)node.getAssociationsToDettach().contains(id));
            }
            nodes.add(node);
        }
        for (ReplicationNode node : this.model.getNodes()) {
            if (nodes.contains(node)) continue;
            AbstractTopiaReplicationServiceTest.assertFalse((boolean)node.hasAssociationsToDettach());
        }
    }

    protected void detectOperations(TopiaEntity entity, Object ... expected) throws TopiaException {
        AbstractTopiaReplicationServiceTest.assertEquals((long)0L, (long)(expected.length % 2));
        if (entity == null) {
            this.prepareModel(new String[0]);
        } else {
            this.prepareModel(entity.getTopiaId());
        }
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info((Object)"==========================================================================");
            if (entity == null) {
                this.getLog().info((Object)"resume of operations for all ");
            } else {
                this.getLog().info((Object)("resume of operations for entity " + entity.getTopiaId()));
            }
            for (ReplicationNode node : this.model.getOrder()) {
                ReplicationOperationDef[] operations;
                for (ReplicationOperationDef op : operations = node.getOperations()) {
                    this.getLog().info((Object)("[" + node + "] : operation " + op));
                }
            }
            this.getLog().info((Object)"==========================================================================");
        }
    }

    protected void doReplicate(TopiaEntityEnum contract, TopiaEntity ... entity) throws Exception {
        TopiaApplicationContext rootCtxt = this.createReplicateDb("doReplicate_" + contract);
        List ids = TopiaEntityHelper.getTopiaIdList(Arrays.asList(entity));
        this.getLog().info((Object)("entity " + ids));
        this.prepareModel(ids.toArray(new String[ids.size()]));
        this.destinationContext = rootCtxt;
        this.service.doReplicate(this.model, rootCtxt);
        if (entity.length == 0) {
            return;
        }
        TopiaPersistenceContext destinationPC = rootCtxt.newPersistenceContext();
        for (TopiaEntity e : entity) {
            TopiaEntity actual = destinationPC.findByTopiaId(e.getTopiaId());
            AbstractTopiaReplicationServiceTest.assertNotNull((Object)actual);
            AbstractTopiaReplicationServiceTest.assertEquals((Object)e, (Object)actual);
        }
        destinationPC.close();
        this.destinationContext = rootCtxt;
    }

    protected void doReplicateAll() throws Exception {
        TopiaApplicationContext rootCtxt = this.createReplicateDb("doReplicateAll");
        this.prepareModelAll();
        this.destinationContext = rootCtxt;
        this.service.doReplicate(this.model, this.destinationContext);
        TopiaPersistenceContext destinationPC = rootCtxt.newPersistenceContext();
        this.assertDbEquals(this.model.getContracts(), (TopiaDaoSupplier)sourcePC, (TopiaDaoSupplier)destinationPC);
        destinationPC.close();
        this.destinationContext = rootCtxt;
    }

    protected void doReplicateWithComputedOrder(TopiaEntity ... entity) throws Exception {
        TopiaApplicationContext rootCtxt = this.createReplicateDb("doReplicateWithComputedOrder");
        List ids = TopiaEntityHelper.getTopiaIdList(Arrays.asList(entity));
        this.prepareModelWithComputedOrder(ids.toArray(new String[ids.size()]));
        this.destinationContext = rootCtxt;
        this.service.doReplicate(this.model, this.destinationContext);
        this.getLog().info((Object)("replication is done for " + Arrays.toString(entity) + ", will verify data..."));
        TopiaPersistenceContext destinationPC = rootCtxt.newPersistenceContext();
        this.assertDbEquals(this.model.getContracts(), (TopiaDaoSupplier)sourcePC, (TopiaDaoSupplier)destinationPC);
        destinationPC.close();
        this.destinationContext = rootCtxt;
    }

    protected void assertDbEquals(TopiaEntityEnum[] contracts, TopiaDaoSupplier ctxt, TopiaDaoSupplier ctxt2) throws TopiaException {
        HashSet<String> ids = new HashSet<String>();
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info((Object)("will verify db for contracts " + Arrays.toString(contracts)));
        }
        for (TopiaEntityEnum c : contracts) {
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((Object)("verify for contract " + c));
            }
            TopiaDao daoSrc = ctxt.getDao(c.getContract());
            TopiaDao daoDst = ctxt2.getDao(c.getContract());
            long nbSrc = daoSrc.count();
            long nbDst = daoDst.count();
            AbstractTopiaReplicationServiceTest.assertEquals((String)("le nombres d'entites de type " + c + " devrait etre " + nbSrc + " mais est " + nbDst), (long)nbSrc, (long)nbDst);
            List idsSrc = daoSrc.findAllIds();
            List idsDst = daoDst.findAllIds();
            Collections.sort(idsSrc);
            Collections.sort(idsDst);
            AbstractTopiaReplicationServiceTest.assertEquals((Object)idsSrc, (Object)idsDst);
            for (String id : idsSrc) {
                if (this.getLog().isDebugEnabled()) {
                    this.getLog().debug((Object)("verify for entity " + id));
                }
                TopiaEntity eSrc = daoSrc.findByTopiaId(id);
                TopiaEntity eDst = daoDst.findByTopiaId(id);
                AbstractTopiaReplicationServiceTest.assertEquals((Object)eSrc, (Object)eDst);
                this.assertEntityEquals(eSrc, eDst, ids);
            }
        }
    }

    protected void assertEntityEquals(TopiaEntity expected, TopiaEntity actual, Set<String> treated) {
        Object dst;
        Object src;
        Class type;
        TopiaEntityEnum contract;
        if (treated == null) {
            treated = new HashSet<String>();
        }
        if (treated.contains(actual.getTopiaId())) {
            return;
        }
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((Object)expected);
        }
        AbstractTopiaReplicationServiceTest.assertEquals((Object)actual.getTopiaId(), (Object)expected.getTopiaId());
        treated.add(actual.getTopiaId());
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((Object)("expected : " + expected + " / actual " + actual));
        }
        if ((contract = TopiaEntityHelper.getEntityEnum(expected.getClass(), (TopiaEntityEnum[])this.getContracts())) == null) {
            this.getLog().debug((Object)("untested property type " + expected.getClass()));
            return;
        }
        Assert.assertNotNull((String)("contract not found for " + expected.getClass() + " in " + Arrays.toString(this.getContracts())), (Object)contract);
        EntityOperator operator = EntityOperatorStore.getOperator((TopiaEntityEnum)contract);
        List associationProperties = operator.getAssociationProperties();
        for (String name : associationProperties) {
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((Object)("association " + name));
            }
            if (operator.isChildEmpty(name, expected)) {
                AbstractTopiaReplicationServiceTest.assertTrue((String)("l'association " + name + " devrait etre vide mais possede " + operator.sizeChild(name, actual) + " entrees"), (boolean)operator.isChildEmpty(name, actual));
            } else {
                AbstractTopiaReplicationServiceTest.assertFalse((String)("l'association " + name + " devrait posseder " + operator.isChildEmpty(name, expected) + " mais est vide"), (boolean)operator.isChildEmpty(name, actual));
            }
            AbstractTopiaReplicationServiceTest.assertEquals((Object)operator.isChildEmpty(name, actual), (Object)operator.isChildEmpty(name, expected));
            type = operator.getAssociationPropertyType(name);
            src = (Collection)operator.get(name, expected);
            dst = (Collection)operator.get(name, actual);
            Iterator itrSrc = src.iterator();
            Iterator itrDst = dst.iterator();
            while (itrSrc.hasNext()) {
                if (TopiaEntity.class.isAssignableFrom(type)) {
                    this.assertEntityEquals((TopiaEntity)itrSrc.next(), (TopiaEntity)itrDst.next(), treated);
                    continue;
                }
                AbstractTopiaReplicationServiceTest.assertEquals(itrSrc.next(), itrDst.next());
            }
        }
        for (String name : operator.getProperties()) {
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((Object)("dependency " + name));
            }
            if (associationProperties.contains(name)) continue;
            type = operator.getPropertyType(name);
            src = operator.get(name, expected);
            dst = operator.get(name, actual);
            AbstractTopiaReplicationServiceTest.assertFalse((src == null && dst != null ? 1 : 0) != 0);
            AbstractTopiaReplicationServiceTest.assertFalse((src != null && dst == null ? 1 : 0) != 0);
            if (src == null) continue;
            if (TopiaEntity.class.isAssignableFrom(type)) {
                this.assertEntityEquals((TopiaEntity)src, (TopiaEntity)dst, treated);
                continue;
            }
            AbstractTopiaReplicationServiceTest.assertEquals((Object)src, (Object)dst);
        }
    }

    protected void createSupportedBeforeOperation(TopiaEntityEnum contract, TopiaEntity entity, Class<? extends TopiaReplicationOperation> operationClass, Object ... parameters) throws Exception {
        this.getLog().info((Object)("entity " + entity.getTopiaId()));
        this.prepareModel(entity.getTopiaId());
        this.getModelBuilder().addBeforeOperation(this.model, contract, operationClass, parameters);
        Assert.assertTrue((boolean)true);
    }

    protected void createSupportedAfterOperation(TopiaEntityEnum contract, TopiaEntity entity, Class<? extends TopiaReplicationOperation> operationClass, Object ... parameters) throws Exception {
        this.getLog().info((Object)("entity " + entity.getTopiaId()));
        this.prepareModel(entity.getTopiaId());
        this.getModelBuilder().addAfterOperation(this.model, contract, operationClass, parameters);
        Assert.assertTrue((boolean)true);
    }

    protected Long getTestsTimeStamp() {
        if (testsTimeStamp == null) {
            testsTimeStamp = System.currentTimeMillis();
            this.getLog().info((Object)("tests timestamp : " + testsTimeStamp));
        }
        return testsTimeStamp;
    }

    protected File getTestDir(Class<?> testClass) {
        if (testsBasedir == null) {
            String tmp = System.getProperty("basedir");
            if (tmp == null) {
                tmp = new File("").getAbsolutePath();
            }
            String name = String.format(TEST_BASEDIR, File.separator, new Date(this.getTestsTimeStamp()));
            testsBasedir = new File(new File(tmp), name);
            this.getLog().info((Object)("tests basedir   : " + testsBasedir));
        }
        return new File(testsBasedir, testClass.getSimpleName());
    }

    protected void createModel(TopiaEntity entity) throws TopiaException {
        this.model = this.getModelBuilder().createModel(sourceContext, this.getContracts(), true, new String[]{entity.getTopiaId()});
    }

    protected void prepareModel(String ... ids) throws TopiaException {
        this.model = this.service.prepare(this.getContracts(), true, ids);
    }

    protected void prepareModelAll() throws TopiaException {
        this.model = this.service.prepareForAll(this.getContracts());
    }

    protected void prepareModelWithComputedOrder(String ... ids) throws TopiaException {
        this.model = this.service.prepare(this.getContracts(), false, ids);
    }

    static {
        CREATE_TOPIA_TEST_APPLICATION_CONTEXT = new Function<Properties, TopiaApplicationContext>(){

            public TopiaApplicationContext apply(Properties input) {
                return new TopiaItLegacyTopiaApplicationContext(input);
            }
        };
    }
}

