/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.migration.kernel;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.migration.common.MapAdapter;
import org.nuiton.topia.migration.common.MapAdapterAdmin;
import org.nuiton.topia.migration.common.ProxyClass;
import org.nuiton.topia.migration.common.ProxyClassMapped;
import org.nuiton.topia.migration.common.SimpleProxyClass;
import org.nuiton.topia.migration.common.SimpleProxyClassMapped;
import org.nuiton.topia.migration.kernel.ConfigurationAdapter;
import org.nuiton.topia.migration.kernel.NullMigrationClass;
import org.nuiton.topia.migration.kernel.ObjectNotFound;
import org.nuiton.topia.migration.transformation.FinderMigration;
import org.nuiton.topia.migration.transformation.MapHelper;
import org.nuiton.topia.migration.transformation.Migration;
import org.nuiton.topia.migration.transformation.MigrationClass;
import org.nuiton.topia.migration.transformation.MigrationNull;
import org.nuiton.util.Version;

public class Transformer
implements MapHelper {
    private FinderMigration classFinder;
    private ConfigurationAdapter baseConf;
    private ConfigurationAdapter nextConf;
    private transient Log log;
    private SortedMap<Version, ConfigurationAdapter> confAdapters;
    private Map<ProxyClassMapped, ProxyClassMapped> linkedClass;
    private Map<ProxyClass, Collection<MapAdapterAdmin>> loadedClass;
    private Collection<ProxyClass> alreadyMigrated;

    public Transformer(SortedMap<Version, ConfigurationAdapter> smConfigurationAdapterForVersion) {
        this.confAdapters = smConfigurationAdapterForVersion;
        this.loadedClass = new HashMap<ProxyClass, Collection<MapAdapterAdmin>>();
        this.baseConf = (ConfigurationAdapter)smConfigurationAdapterForVersion.get(smConfigurationAdapterForVersion.firstKey());
        this.alreadyMigrated = new HashSet<ProxyClass>();
        this.linkedClass = new HashMap<ProxyClassMapped, ProxyClassMapped>();
        this.classFinder = new FinderMigration();
        this.log = LogFactory.getLog(this.getClass());
    }

    public void execute() {
        this.confAdapters.remove(this.baseConf.getVersion());
        while (!this.confAdapters.isEmpty()) {
            this.nextConf = (ConfigurationAdapter)this.confAdapters.get(this.confAdapters.firstKey());
            this.migrateCurrentToNext();
        }
    }

    private void migrateCurrentToNext() {
        this.log.info((Object)("Processing step: version " + this.baseConf.getVersion().getVersion() + " to version " + this.nextConf.getVersion().getVersion()));
        Collection<ProxyClass> classes = this.nextConf.getClasses();
        Map<ProxyClass, MigrationClass> migrations = this.findCurrentMigrations(classes);
        this.log.debug((Object)("Migrations list : " + migrations));
        this.performMigrations(migrations);
        this.baseConf = this.nextConf;
        this.alreadyMigrated.clear();
        this.nextConf = null;
        this.linkedClass.clear();
        this.loadedClass.clear();
        this.confAdapters.remove(this.confAdapters.firstKey());
    }

    private void performMigrations(Map<ProxyClass, MigrationClass> migrations) {
        for (ProxyClass pc : migrations.keySet()) {
            this.log.debug((Object)("Migration of '" + pc.getCanonicalName() + "' to " + this.nextConf.getVersion()));
            this.migrateAClassRec(pc, migrations, null);
        }
    }

    private void migrateAClassRec(ProxyClass pc, Map<ProxyClass, MigrationClass> migrations, ProxyClass grandparent) {
        if (this.alreadyMigrated.contains(pc)) {
            return;
        }
        Set<ProxyClass> deps = this.nextConf.getDependenciesHelper().getDependencies(pc);
        for (ProxyClass dep : deps) {
            if (dep.equals(grandparent)) continue;
            this.log.debug((Object)("Migration of '" + dep.getCanonicalName() + "' dependencies"));
            this.migrateAClassRec(dep, migrations, pc);
        }
        Collection<MapAdapterAdmin> data = null;
        MigrationClass mc = migrations.get(pc);
        data = this.baseConf.getData(mc.getParentClassName());
        try {
            Migration migration = (Migration)Transformer.class.getClassLoader().loadClass(mc.getNameMigrationClass()).newInstance();
            ProxyClass parent = mc.getParentClassName();
            this.log.debug((Object)(pc.getCanonicalName() + " (data provided by class '" + parent.getCanonicalName() + "')"));
            SimpleProxyClassMapped pcmBase = new SimpleProxyClassMapped(parent, (Serializable)((Object)this.baseConf.getNameIdAttribute(parent)));
            SimpleProxyClassMapped pcmNext = new SimpleProxyClassMapped(pc, (Serializable)((Object)this.nextConf.getNameIdAttribute(pc)), migration);
            this.linkedClass.put(pcmBase, pcmNext);
            for (MapAdapterAdmin m : data) {
                migration.migrate(m, this);
                m.setOuterClass(parent);
            }
        }
        catch (ClassNotFoundException e) {
            this.log.error((Object)("Cannot found migration class " + mc.getNameMigrationClass()));
        }
        catch (InstantiationException e) {
            this.log.error((Object)("Cannot initalize migration class " + mc.getNameMigrationClass()));
        }
        catch (IllegalAccessException e) {
            this.log.error((Object)("IllegalAccessException while loading migration class " + mc.getNameMigrationClass()));
        }
        this.alreadyMigrated.add(pc);
        this.switchMaps(data);
        this.log.debug((Object)("Saving '" + pc.getCanonicalName() + "' in version " + this.nextConf.getVersion()));
        this.save(data);
        this.clearLoadedClasses();
    }

    private void switchMaps(Collection<MapAdapterAdmin> data) {
        for (MapAdapterAdmin m : data) {
            m.switchVersion();
        }
    }

    private void clearLoadedClasses() {
        this.loadedClass.clear();
    }

    private void save(Collection<MapAdapterAdmin> data) {
        this.nextConf.saveMaps(data, this.linkedClass);
    }

    private Map<ProxyClass, MigrationClass> findCurrentMigrations(Collection<ProxyClass> classes) {
        HashMap<ProxyClass, MigrationClass> result = new HashMap<ProxyClass, MigrationClass>();
        for (ProxyClass klass : classes) {
            MigrationClass mig = this.classFinder.getMigrationClass(klass, this.baseConf.getVersion(), this.nextConf.getVersion());
            if (mig == null) {
                mig = new NullMigrationClass(MigrationNull.class.getCanonicalName(), klass, this.baseConf.getVersion(), this.nextConf.getVersion());
            }
            result.put(klass, mig);
        }
        return result;
    }

    @Override
    public MapAdapter getNewMap(ProxyClass clazz, Serializable idVal) throws ObjectNotFound {
        return this.getMap(this.nextConf, clazz, idVal);
    }

    @Override
    public MapAdapter getNewMap(String clazz, Serializable idVal) throws ObjectNotFound {
        return this.getMap(this.nextConf, new SimpleProxyClass(clazz), idVal);
    }

    @Override
    public MapAdapter getOldMap(ProxyClass clazz, Serializable idVal) throws ObjectNotFound {
        return this.getMap(this.baseConf, clazz, idVal);
    }

    @Override
    public MapAdapter getOldMap(String clazz, Serializable idVal) throws ObjectNotFound {
        return this.getMap(this.baseConf, new SimpleProxyClass(clazz), idVal);
    }

    @Override
    public Collection<MapAdapter> getNewMaps(String clazz) {
        return this.getMaps(this.nextConf, new SimpleProxyClass(clazz));
    }

    @Override
    public Collection<MapAdapter> getNewMaps(ProxyClass clazz) {
        return this.getMaps(this.nextConf, clazz);
    }

    @Override
    public Collection<MapAdapter> getOldMaps(String clazz) {
        return this.getMaps(this.baseConf, new SimpleProxyClass(clazz));
    }

    @Override
    public Collection<MapAdapter> getOldMaps(ProxyClass clazz) {
        return this.getMaps(this.baseConf, clazz);
    }

    private MapAdapter getMap(ConfigurationAdapter cfg, ProxyClass pc, Serializable idVal) throws ObjectNotFound {
        MapAdapterAdmin result = cfg.getData(pc, idVal);
        if (result == null) {
            throw new ObjectNotFound();
        }
        return result;
    }

    private Collection<MapAdapter> getMaps(ConfigurationAdapter cfg, ProxyClass clazz) {
        Collection<MapAdapterAdmin> tmp = cfg.getData(clazz);
        HashSet<MapAdapter> result = new HashSet<MapAdapter>();
        for (MapAdapterAdmin m : tmp) {
            result.add(m);
        }
        return result;
    }
}

