/*
 * #%L
 * ToPIA :: Persistence
 * 
 * $Id: DAOImplTransformer.java 2156 2010-11-28 20:17:13Z tchemit $
 * $HeadURL: http://svn.nuiton.org/svn/topia/tags/topia-2.5.1/topia-persistence/src/main/java/org/nuiton/topia/generator/DAOImplTransformer.java $
 * %%
 * Copyright (C) 2004 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

package org.nuiton.topia.generator;

import org.nuiton.eugene.java.ObjectModelTransformerToJava;
import org.nuiton.eugene.models.object.ObjectModelClass;
import org.nuiton.eugene.models.object.ObjectModelClassifier;
import org.nuiton.eugene.models.object.ObjectModelDependency;
import org.nuiton.eugene.models.object.ObjectModelInterface;
import org.nuiton.eugene.models.object.ObjectModelOperation;

import java.util.ArrayList;
import java.util.List;

/**
 * Created: 14 déc. 2009
 *
 * @author tchemit <chemit@codelutin.com>
 * @version $Id: DAOImplTransformer.java 2156 2010-11-28 20:17:13Z tchemit $
 * @since 2.3.0
 * @plexus.component role="org.nuiton.eugene.Template" role-hint="org.nuiton.topia.generator.DAOImplTransformer"
 */
public class DAOImplTransformer extends ObjectModelTransformerToJava {

    /**
     * Collection used to identify entities full qualified name that have
     * a dependency for DAO extra operations. So no need to generate the
     * DAOImpl in this case, it will be created by the developper. 
     */
    List<String> noGenerationNeeded = new ArrayList<String>();

    @Override
    public void transformFromInterface(ObjectModelInterface interfacez) {
        if (!TopiaGeneratorUtil.hasDaoStereotype(interfacez)) {
            return;
        }

        /**
         * EVO #636 : Manage extra operations for DAO from "dao" dependency
         * between an interface with stereotype <<dao>> (dependency client) and
         * a class with stereotype <<entity>> (dependency supplier).
         */

        ObjectModelDependency dependency =
                interfacez.getDependency(TopiaGeneratorUtil.DEPENDENCIES_DAO);

        ObjectModelClassifier classifier = dependency.getSupplier();

        if (TopiaGeneratorUtil.hasEntityStereotype(classifier)) {
            noGenerationNeeded.add(classifier.getQualifiedName());
        }
    }

    @Override
    public void transformFromClass(ObjectModelClass clazz) {
        if (!TopiaGeneratorUtil.hasEntityStereotype(clazz) || hasDAOOperations(clazz)) {
            return;
        }
        String clazzName = clazz.getName();
        String clazzFQN = clazz.getQualifiedName();
        ObjectModelClass result = createClass(clazzName + "DAOImpl<E extends " + clazzName + ">", clazz.getPackageName());
        setDocumentation(result, "/**\n" +
                " Implantation du DAO pour l'entité " + clazzName + ".\n" +
                " * L'utilisateur peut remplacer cette classe par la sienne en la mettant \n" +
                " * simplement dans ces sources. Cette classe générée sera alors simplement\n" +
                " * écrasée\n" +
                " */");
        setSuperClass(result, clazzFQN + "DAOAbstract<E>");
    }

    /**
     * Detect if the class has DAO operations identified with <<dao>> stereotype.
     *
     * @param clazz The ObjectModelClass with operations (Corresponding to the Entity)
     * @return true if the class has some dao operations, false if not
     */
    public boolean hasDAOOperations(ObjectModelClass clazz) {
        // This code will be deprecated
        for (ObjectModelOperation op : clazz.getOperations()) {
            if (TopiaGeneratorUtil.hasDaoStereotype(op)) {
                return true;
            }
        }
        // New method : interface dependency
        return noGenerationNeeded.contains(clazz.getQualifiedName());
    }
}
