/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.persistence;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.persistence.TopiaEntity;

public abstract class TopiaEntityAbstract
implements TopiaEntity,
Serializable {
    private static Log log = LogFactory.getLog(TopiaEntityAbstract.class);
    protected String topiaId;
    protected long topiaVersion;
    protected Date topiaCreateDate = new Date();
    protected transient TopiaContext topiaContext = null;
    protected transient VetoableChangeSupport readVetoables = new VetoableChangeSupport(this);
    protected transient PropertyChangeSupport readListeners = new PropertyChangeSupport(this);
    protected transient VetoableChangeSupport writeVetoables = new VetoableChangeSupport(this);
    protected transient PropertyChangeSupport writeListeners = new PropertyChangeSupport(this);

    @Override
    public String getTopiaId() {
        return this.topiaId;
    }

    @Override
    public void setTopiaId(String v) {
        this.topiaId = v;
    }

    @Override
    public long getTopiaVersion() {
        return this.topiaVersion;
    }

    @Override
    public void setTopiaVersion(long v) {
        this.topiaVersion = v;
    }

    @Override
    public Date getTopiaCreateDate() {
        return this.topiaCreateDate;
    }

    @Override
    public void setTopiaCreateDate(Date topiaCreateDate) {
        this.topiaCreateDate = topiaCreateDate;
    }

    @Override
    public TopiaContext getTopiaContext() {
        return this.topiaContext;
    }

    public void setTopiaContext(TopiaContext context) throws TopiaException {
        if (this.topiaContext != null) {
            throw new TopiaException("Remplacement du contexte interdit");
        }
        this.topiaContext = context;
    }

    @Override
    public void postCreate() throws TopiaException {
    }

    @Override
    public void update() throws TopiaException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void delete() throws TopiaException {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<TopiaEntity> getComposite() throws TopiaException {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<TopiaEntity> getAggregate() throws TopiaException {
        throw new UnsupportedOperationException();
    }

    public int hashCode() {
        Date date = this.getTopiaCreateDate();
        int result = date == null ? 0 : date.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof TopiaEntity)) {
            return false;
        }
        TopiaEntity other = (TopiaEntity)obj;
        if (this.getTopiaId() == null || other.getTopiaId() == null) {
            return false;
        }
        boolean result = this.getTopiaId().equals(other.getTopiaId());
        return result;
    }

    protected void fireOnPreRead(String propertyName, Object value) {
        TopiaContextImplementor contextImplementor = (TopiaContextImplementor)this.getTopiaContext();
        if (contextImplementor != null) {
            contextImplementor.getFiresSupport().fireOnPreRead(this.readVetoables, this, propertyName, value);
        }
    }

    protected void fireOnPostRead(String propertyName, Object value) {
        TopiaContextImplementor contextImplementor = (TopiaContextImplementor)this.getTopiaContext();
        if (contextImplementor != null) {
            contextImplementor.getFiresSupport().fireOnPostRead(this.readListeners, this, propertyName, value);
        }
    }

    protected void fireOnPostRead(String propertyName, int index, Object value) {
        TopiaContextImplementor contextImplementor = (TopiaContextImplementor)this.getTopiaContext();
        if (contextImplementor != null) {
            contextImplementor.getFiresSupport().fireOnPostRead(this.readListeners, this, propertyName, index, value);
        }
    }

    protected void fireOnPreWrite(String propertyName, Object oldValue, Object newValue) {
        TopiaContextImplementor contextImplementor = (TopiaContextImplementor)this.getTopiaContext();
        if (contextImplementor != null) {
            contextImplementor.getFiresSupport().fireOnPreWrite(this.writeVetoables, this, propertyName, oldValue, newValue);
        }
    }

    protected void fireOnPostWrite(String propertyName, Object oldValue, Object newValue) {
        TopiaContextImplementor contextImplementor = (TopiaContextImplementor)this.getTopiaContext();
        if (contextImplementor != null) {
            contextImplementor.getFiresSupport().fireOnPostWrite(this.writeListeners, this, propertyName, oldValue, newValue);
        }
    }

    protected void fireOnPostWrite(String propertyName, int index, Object oldValue, Object newValue) {
        TopiaContextImplementor contextImplementor = (TopiaContextImplementor)this.getTopiaContext();
        if (contextImplementor != null) {
            contextImplementor.getFiresSupport().fireOnPostWrite(this.writeListeners, this, propertyName, index, oldValue, newValue);
        }
    }

    @Override
    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.writeListeners.addPropertyChangeListener(propertyName, listener);
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.writeListeners.addPropertyChangeListener(listener);
    }

    @Override
    public void addVetoableChangeListener(String propertyName, VetoableChangeListener vetoable) {
        this.writeVetoables.addVetoableChangeListener(propertyName, vetoable);
    }

    @Override
    public void addVetoableChangeListener(VetoableChangeListener vetoable) {
        this.writeVetoables.addVetoableChangeListener(vetoable);
    }

    @Override
    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.writeListeners.removePropertyChangeListener(propertyName, listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.writeListeners.removePropertyChangeListener(listener);
    }

    @Override
    public void removeVetoableChangeListener(String propertyName, VetoableChangeListener vetoable) {
        this.writeVetoables.removeVetoableChangeListener(propertyName, vetoable);
    }

    @Override
    public void removeVetoableChangeListener(VetoableChangeListener vetoable) {
        this.writeVetoables.removeVetoableChangeListener(vetoable);
    }

    @Override
    public void addPropertyListener(String propertyName, PropertyChangeListener listener) {
        this.readListeners.addPropertyChangeListener(propertyName, listener);
    }

    @Override
    public void addPropertyListener(PropertyChangeListener listener) {
        this.readListeners.addPropertyChangeListener(listener);
    }

    @Override
    public void addVetoableListener(String propertyName, VetoableChangeListener vetoable) {
        this.readVetoables.addVetoableChangeListener(propertyName, vetoable);
    }

    @Override
    public void addVetoableListener(VetoableChangeListener vetoable) {
        this.readVetoables.addVetoableChangeListener(vetoable);
    }

    @Override
    public void removePropertyListener(String propertyName, PropertyChangeListener listener) {
        this.readListeners.removePropertyChangeListener(propertyName, listener);
    }

    @Override
    public void removePropertyListener(PropertyChangeListener listener) {
        this.readListeners.removePropertyChangeListener(listener);
    }

    @Override
    public void removeVetoableListener(String propertyName, VetoableChangeListener vetoable) {
        this.readVetoables.removeVetoableChangeListener(propertyName, vetoable);
    }

    @Override
    public void removeVetoableListener(VetoableChangeListener vetoable) {
        this.readVetoables.removeVetoableChangeListener(vetoable);
    }
}

