/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.generator;

import java.util.Iterator;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.eugene.java.ObjectModelTransformerToJava;
import org.nuiton.eugene.models.object.ObjectModelAttribute;
import org.nuiton.eugene.models.object.ObjectModelClassifier;
import org.nuiton.eugene.models.object.ObjectModelInterface;
import org.nuiton.eugene.models.object.ObjectModelModifier;
import org.nuiton.eugene.models.object.ObjectModelOperation;
import org.nuiton.eugene.models.object.ObjectModelParameter;

public class InterfaceTransformer
extends ObjectModelTransformerToJava {
    private static final Log log = LogFactory.getLog(InterfaceTransformer.class);

    public void transformFromInterface(ObjectModelInterface interfacez) {
        Iterator it;
        if (!interfacez.getStereotypes().isEmpty()) {
            return;
        }
        ObjectModelInterface resultInterface = this.createInterface(interfacez.getName(), interfacez.getPackageName());
        if (log.isDebugEnabled()) {
            log.debug((Object)("will create model for " + resultInterface.getQualifiedName()));
        }
        if ((it = interfacez.getInterfaces().iterator()).hasNext()) {
            ObjectModelInterface extend = (ObjectModelInterface)it.next();
            this.addInterface((ObjectModelClassifier)resultInterface, extend.getQualifiedName());
        }
        for (ObjectModelAttribute attr : interfacez.getAttributes()) {
            if (attr.isStatic() || !StringUtils.isNotEmpty((String)attr.getDefaultValue())) continue;
            this.addConstant((ObjectModelClassifier)resultInterface, attr.getName(), attr.getType(), attr.getDefaultValue(), ObjectModelModifier.PUBLIC);
        }
        for (ObjectModelOperation op : interfacez.getOperations()) {
            ObjectModelOperation resultOp = this.addOperation((ObjectModelClassifier)resultInterface, op.getName(), op.getReturnType(), new ObjectModelModifier[0]);
            for (ObjectModelParameter param : op.getParameters()) {
                this.addParameter(resultOp, param.getType(), param.getName());
            }
            for (String exception : op.getExceptions()) {
                this.addException(resultOp, exception);
            }
        }
    }
}

