package org.nuiton.topiatest;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import org.apache.commons.lang.builder.ToStringBuilder;


public class NaturalizedEntityDTO implements Serializable {

    public Integer naturalIdNotNull;
    public String naturalIdNull;
    protected final PropertyChangeSupport p = new PropertyChangeSupport(this);
    /**
     * addPropertyChangeListener :
     * @param listener 
     */

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        p.addPropertyChangeListener(listener);
    }

    /**
     * addPropertyChangeListener :
     * @param propertyName 
     * @param listener 
     */

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        p.addPropertyChangeListener(propertyName, listener);
    }

    /**
     * removePropertyChangeListener :
     * @param listener 
     */

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        p.removePropertyChangeListener(listener);
    }

    /**
     * removePropertyChangeListener :
     * @param propertyName 
     * @param listener 
     */

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        p.removePropertyChangeListener(propertyName, listener);
    }

    /**
     * setNaturalIdNotNull :
     * @param value 
     */

    public void setNaturalIdNotNull(Integer value) {
        java.lang.Integer oldValue = this.naturalIdNotNull;
        this.naturalIdNotNull = value;
        p.firePropertyChange("naturalIdNotNull", oldValue, value);
    }

    /**
     * getNaturalIdNotNull :
     * @return Integer 
     */

    public Integer getNaturalIdNotNull() {
        return naturalIdNotNull;
    }

    /**
     * setNaturalIdNull :
     * @param value 
     */

    public void setNaturalIdNull(String value) {
        java.lang.String oldValue = this.naturalIdNull;
        this.naturalIdNull = value;
        p.firePropertyChange("naturalIdNull", oldValue, value);
    }

    /**
     * getNaturalIdNull :
     * @return String 
     */

    public String getNaturalIdNull() {
        return naturalIdNull;
    }

    /**
     * toString :
     * @return String 
     */

    public String toString() {
        String result = new ToStringBuilder(this).
            append("naturalIdNotNull", this.naturalIdNotNull).
            append("naturalIdNull", this.naturalIdNull).
         toString();
        return result;
}


} //NaturalizedEntityDTO
