/* *##% 
 * ToPIA :: Persistence
 * Copyright (C) 2004 - 2009 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * ##%*/




/* *
* EntityGenerator.java
*
* Created: 12 déc. 2005
*
* @author Arnaud Thimel <thimel@codelutin.com>
* @version $Revision: 1732 $
*
* Mise a jour: $Date: 2009-12-20 17:29:38 +0100 (dim., 20 déc. 2009) $
* par : $Author: tchemit $
*/

package org.nuiton.topia.generator;

import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import org.apache.commons.lang.StringUtils;
import org.nuiton.eugene.GeneratorUtil;
import org.nuiton.eugene.models.object.ObjectModelGenerator;
import org.nuiton.eugene.models.object.ObjectModelAssociationClass;
import org.nuiton.eugene.models.object.ObjectModelAttribute;
import org.nuiton.eugene.models.object.ObjectModelClass;
import org.nuiton.eugene.models.object.ObjectModelClassifier;
import org.nuiton.eugene.models.object.ObjectModelOperation;
import org.nuiton.eugene.models.object.ObjectModelParameter;
import org.nuiton.util.StringUtil;

/**
 * Genere des DAOs abstrait par defaut, l'utilisateur peut ensuite en herite
 * pour implanter d'autre methode find, ou bien laisser l'implantation par
 * defaut de l'autre generateur qui genere une classe DAO qui herite de celle-ci
 * mais completement vide.

 * @author poussin
 *
 * @deprecated since 2.3.0, prefer use the corresponding {@link org.nuiton.eugene.Transformer} :
 * {@link DAOAbstractTransformer}.
 * @plexus.component role="org.nuiton.eugene.Template" role-hint="org.nuiton.topia.generator.DAOAbstractGenerator"
 */
@Deprecated
public class DAOAbstractGenerator extends ObjectModelGenerator {

    @Override
    public String getFilenameForClass(ObjectModelClass clazz) {
        return clazz.getQualifiedName().replace('.', File.separatorChar) + "DAOAbstract.java";
    }

    @Override
    public void generateFromClass(Writer output, ObjectModelClass clazz) throws IOException {
        if (!clazz.hasStereotype(TopiaGeneratorUtil.STEREOTYPE_ENTITY)) {
            return;
        }
        String copyright = TopiaGeneratorUtil.getCopyright(model);
        if (TopiaGeneratorUtil.notEmpty(copyright)) {
output.write(""+copyright+"\n");
output.write("");
        }
output.write("package "+clazz.getPackageName()+";\n");
output.write("\n");
output.write("import java.util.List;\n");
output.write("\n");
output.write("");
        Collection<ObjectModelOperation> DAOoperations = getDAOOperations(clazz);
        if (isCollectionNeeded(DAOoperations)) {
output.write("\n");
output.write("import java.util.Collection;\n");
output.write("");
        }
        if (isSetNeeded(DAOoperations)) {
output.write("\n");
output.write("import java.util.Set;\n");
output.write("");            
        }
output.write("\n");
output.write("import java.util.Arrays;\n");
output.write("import org.nuiton.topia.TopiaException;\n");
output.write("import org.nuiton.topia.framework.TopiaContextImplementor;\n");
output.write("");
        boolean enableSecurity = (
        		clazz.hasTagValue(TopiaGeneratorUtil.TAG_SECURITY_CREATE) ||
        		clazz.hasTagValue(TopiaGeneratorUtil.TAG_SECURITY_LOAD) ||
        		clazz.hasTagValue(TopiaGeneratorUtil.TAG_SECURITY_UPDATE) ||
        		clazz.hasTagValue(TopiaGeneratorUtil.TAG_SECURITY_DELETE)
        		);
        
        if (enableSecurity) {
output.write("\n");
output.write("import java.util.ArrayList;\n");
output.write("import java.security.Permission;\n");
output.write("import org.nuiton.topia.taas.entities.TaasAuthorizationImpl;\n");
output.write("import org.nuiton.topia.taas.jaas.TaasPermission;\n");
output.write("import org.nuiton.topia.persistence.TopiaDAO;\n");
output.write("import static org.nuiton.topia.taas.TaasUtil.CREATE;\n");
output.write("import static org.nuiton.topia.taas.TaasUtil.DELETE;\n");
output.write("import static org.nuiton.topia.taas.TaasUtil.LOAD;\n");
output.write("import static org.nuiton.topia.taas.TaasUtil.UPDATE;\n");
output.write("");
        }
        String clazzName = clazz.getName();
output.write("\n");
output.write("/**\n");
output.write(" * Implantation DAO pour l'entité "+GeneratorUtil.toUpperCaseFirstLetter(clazz.getName())+".\n");
output.write(" * Cette classe contient une implantation de TopiaDAO a laquel elle peut\n");
output.write(" * deleguer des traitements\n");
output.write(" * \n");
output.write(" */\n");
output.write("public abstract class "+clazzName+"DAOAbstract<E extends "+clazzName+"> extends ");
        String extendClass = "";
        for (Iterator<ObjectModelClass> i=clazz.getSuperclasses().iterator(); i.hasNext();) {
            ObjectModelClassifier parent = i.next();
            extendClass += parent.getQualifiedName();
            if (parent.hasStereotype(TopiaGeneratorUtil.STEREOTYPE_ENTITY)) {
                extendClass += "DAOImpl<E>";
            }
            if (i.hasNext()) {
                extendClass += ", ";
            }
        }
        if (extendClass.length() == 0) {
            extendClass += "org.nuiton.topia.persistence.TopiaDAOImpl<E>";
        }
        
        output.write(""+extendClass+" implements org.nuiton.topia.persistence.TopiaDAO<E> {    \n");
output.write("\n");
output.write("    public Class<E> getEntityClass() {\n");
output.write("        return (Class<E>)"+clazzName+".class;\n");
output.write("    }\n");
output.write("");

        generateDAOOperations(output, DAOoperations);
output.write("\n");
output.write("    public void delete(E entity) throws TopiaException {\n");
output.write("");
        String modelName = StringUtils.capitalize(model.getName());
        String providerFQN = getProperty("defaultPackage") + "." + modelName + "DAOHelper.getImplementationClass";
        for (ObjectModelAttribute attr : clazz.getAttributes()) {
        	String attrType = attr.getType();
        	String reverseAttrName = attr.getReverseAttributeName();
            ObjectModelAttribute reverse = attr.getReverseAttribute();
            if (!attr.hasAssociationClass() && reverse != null && reverse.isNavigable() 
                    && GeneratorUtil.isNMultiplicity(attr) && GeneratorUtil.isNMultiplicity(reverse)) {
                // On doit absolument supprimer pour les relations many-to-many
                // le this de la collection de l'autre cote
                
            	String attrDBName = TopiaGeneratorUtil.getDBName(attr);
            	String attrClassifierDBName = TopiaGeneratorUtil.getDBName(attr.getClassifier());
            	String attrJoinTableName = TopiaGeneratorUtil.getManyToManyTableName(attr);
            	String attrReverseDBName = TopiaGeneratorUtil.getReverseDBName(attr);
output.write("\n");
output.write("        {\n");
output.write("            List<"+attrType+"> list = getContext().getHibernate().createSQLQuery(\n");
output.write("                    \"SELECT main.topiaid \" +\n");
output.write("                    \"from "+attrClassifierDBName+" main, "+attrJoinTableName+" secondary \" +\n");
output.write("                    \"where main.topiaid=secondary."+attrDBName+"\" +\n");
output.write("                    \" and secondary."+attrReverseDBName+"='\" + entity.getTopiaId() + \"'\")\n");
output.write("                    .addEntity(\"main\", "+providerFQN+"("+attrType+".class)).list();\n");
output.write("            for ("+attrType+" item : list) {\n");
output.write("                item.remove"+TopiaGeneratorUtil.capitalize(reverseAttrName)+"(entity);\n");
output.write("            }\n");
output.write("        }\n");
output.write("");
            } else  if (!attr.hasAssociationClass() && reverse != null
                    && reverse.isNavigable() && !GeneratorUtil.isNMultiplicity(reverse)) {
                // On doit mettre a null les attributs qui ont cet objet sur les 
                // autres entites en one-to-*
                // TODO peut-etre qu'hibernate est capable de faire ca tout seul ?
            	// THIMEL: J'ai remplacé reverse.getName() par reverseAttrName sans certitude
                output.write("\n");
output.write("                {\n");
output.write("                List<"+attrType+"> list = getContext()\n");
output.write("                            .getDAO("+attrType+".class)\n");
output.write("                            .findAllByProperties(\""+reverseAttrName+"\", entity);\n");
output.write("                    for ("+attrType+" item : list) {\n");
output.write("                        item.set"+GeneratorUtil.capitalize(reverseAttrName)+"(null);\n");
output.write("");
            	if(attr.isAggregate()){
output.write("\n");
output.write("            			item.delete();\n");
output.write("");
            	}
output.write("\n");
output.write("                    }\n");
output.write("                }\n");
output.write("        ");

            }
        }
output.write("        \n");
output.write("        super.delete(entity);\n");
output.write("    }    \n");
output.write("     \n");
output.write("");
        for (ObjectModelAttribute attr : clazz.getAttributes()) {
            if (!attr.isNavigable()) {
                continue;
            }
            String attrName = attr.getName();

output.write("    /**\n");
output.write("     * Recherche sur l'attribut "+attrName+"\n");
output.write("     */\n");
output.write("");
            if (!GeneratorUtil.isNMultiplicity(attr)) {
                generateNoNMultiplicity(output, attr, false);
            } else {
                generateNMultiplicity(output, attr);
            }
        }

        if (clazz instanceof ObjectModelAssociationClass) {
            ObjectModelAssociationClass assocClass = (ObjectModelAssociationClass)clazz;
            for (ObjectModelAttribute attr : assocClass.getParticipantsAttributes()) {
                if (attr != null) {
                    if (!GeneratorUtil.isNMultiplicity(attr)) {
                        generateNoNMultiplicity(output, attr, true);
                    } else {
                        generateNMultiplicity(output, attr);
                    }
                }
            }
        }
        
        if(enableSecurity) {
output.write("\n");
output.write("    /**\n");
output.write("     * Retourne les permissions a verifier pour l'acces a l'entite pour le service Taas\n");
output.write("     * @param topiaId topiaId d'une entite\n");
output.write("     * @param actions actions souhaitées\n");
output.write("     * @return la liste des permissions\n");
output.write("     */\n");
output.write("    public List<Permission> getRequestPermission(String topiaId, int actions) throws TopiaException {\n");
output.write("        List<Permission> resultPermissions = new ArrayList<Permission>();\n");
output.write("        if ((actions & CREATE) == CREATE) {\n");
output.write("");
            generateSecurity(output, clazz, TopiaGeneratorUtil.TAG_SECURITY_CREATE);
output.write("\n");
output.write("        }\n");
output.write("        if ((actions & LOAD) == LOAD) {\n");
output.write("");
            generateSecurity(output, clazz, TopiaGeneratorUtil.TAG_SECURITY_LOAD);
output.write("\n");
output.write("        }\n");
output.write("        if ((actions & UPDATE) == UPDATE) {\n");
output.write("");
            generateSecurity(output, clazz, TopiaGeneratorUtil.TAG_SECURITY_UPDATE);
output.write("\n");
output.write("        }\n");
output.write("        if ((actions & DELETE) == DELETE) {\n");
output.write("");
            generateSecurity(output, clazz, TopiaGeneratorUtil.TAG_SECURITY_DELETE);
output.write("\n");
output.write("        }\n");
output.write("        return resultPermissions;\n");
output.write("    }\n");
output.write("\n");
output.write("");
            // THIMEL : Le code suivant doit pouvoir être déplacé dans DAODelegator ?
output.write("\n");
output.write("    /**\n");
output.write("     * Retourne les permissions a verifier pour l'acces a l'entite pour le service Taas\n");
output.write("     * @param topiaId topiaId d'une entite\n");
output.write("     * @param actions actions souhaitées\n");
output.write("     * @param query requete pour avoir le prochain topiaId\n");
output.write("     * @param daoClass delegation du getRequestPermission\n");
output.write("     * @return la liste des permissions\n");
output.write("     */\n");
output.write("    protected List<Permission> getRequestPermission(String topiaId, int actions, String query, Class daoClass) throws TopiaException {\n");
output.write("        TopiaContextImplementor context = getContext();\n");
output.write("        List<String> result = context.find(query, \"id\", topiaId);\n");
output.write("\n");
output.write("        List<Permission> resultPermissions = new ArrayList<Permission>();\n");
output.write("        for (String topiaIdPermission : result) {\n");
output.write("            TopiaDAO dao = context.getDAO(daoClass);\n");
output.write("            List<Permission> permissions = dao.getRequestPermission(topiaIdPermission, actions);\n");
output.write("            if(permissions != null) {\n");
output.write("                resultPermissions.addAll(permissions);\n");
output.write("            } else {\n");
output.write("                TaasPermission permission = new TaasPermission(topiaIdPermission, actions);\n");
output.write("                resultPermissions.add(permission);\n");
output.write("            }\n");
output.write("        }\n");
output.write("        return resultPermissions;\n");
output.write("    }\n");
output.write("");
        }
output.write("\n");
output.write("} // "+clazz.getName()+"DAOAbstract\n");
output.write("");
    }

    /**
     * Generation of DAO operations signatures from class.
     * These operations are abstract and identified by <<dao>> stereotype in the model.
     * The developper must defined these methods in the DAOImpl associated to this DAOAbstract.
     * @param output
     * @param operations operations to generate
     */
    private void generateDAOOperations(Writer output, Collection<ObjectModelOperation> operations) throws IOException {
        for (ObjectModelOperation op : operations) {
                String opName = op.getName();
                
output.write("    /**\n");
output.write("");
                if (TopiaGeneratorUtil.hasDocumentation(op)) {
                    String opDocumentation = op.getDocumentation();
output.write("     * "+opName+" : "+opDocumentation+"\n");
output.write("");
                }
                Collection<ObjectModelParameter> params = op.getParameters();
                for (ObjectModelParameter param : params) {
                    String paramName = param.getName();
                    String paramDocumentation = param.getDocumentation();
output.write("     * @param "+paramName+" "+paramDocumentation+"\n");
output.write(" ");
                }
                String opVisibility = op.getVisibility();
                String opType = op.getReturnType();
                //ObjectModelClass clazz = (ObjectModelClass)op.getDeclaringElement();
                //opType = opType.replace(clazz.getQualifiedName(),clazz.getName());
                //opType = opType.replace(clazz.getName(), "E"); // Generic usage for inheritance
output.write("     */\n");
output.write("    "+opVisibility+" abstract "+opType+" "+opName+"(");
                String comma = "";
                for (ObjectModelParameter param : params) {
                    String paramName = param.getName();
                    String paramType = param.getType();                    
output.write(""+comma+""+paramType+" "+paramName+"");
                    comma = ", ";
                }
output.write(")");
                Set<String> exceptions = op.getExceptions();
                exceptions.add("TopiaException");
                comma = " throws ";
                for (String exception : exceptions) {
output.write(""+comma+""+exception+"");
                    comma = ", ";
                }
output.write(";\n");
output.write("\n");
output.write("");
        }
    }

    private boolean isCollectionNeeded(Collection<ObjectModelOperation> operations) {
        return isImportNeeded(operations, "Collection");
    }

    private boolean isSetNeeded(Collection<ObjectModelOperation> operations) {
        return isImportNeeded(operations, "Set");
    }

    private boolean isImportNeeded(Collection<ObjectModelOperation> operations, String importName) {
        for (ObjectModelOperation op : operations) {
            if (op.getReturnType().contains(importName)){
                return true;
            }
            for (ObjectModelParameter param : op.getParameters()) {
                if (param.getType().contains(importName)){
                    return true;
                }
            }
        }
        return false;
    }

    public static Collection<ObjectModelOperation> getDAOOperations(ObjectModelClass clazz) {
        Collection<ObjectModelOperation> results = new ArrayList<ObjectModelOperation>();
        for (ObjectModelOperation op : clazz.getOperations()) {
            if (op.hasStereotype(TopiaGeneratorUtil.STEREOTYPE_DAO)) {
                results.add(op);
            }
        }
        return results;
    }

    private void generateSecurity(Writer output, ObjectModelClass clazz, String securityTagName) throws IOException {
    	if (clazz.hasTagValue(securityTagName)) {
    		String security = clazz.getTagValue(securityTagName);
            Pattern propertiesPattern = Pattern
                .compile("((?:[_a-zA-Z0-9]+\\.)+(?:_?[A-Z][_a-zA-Z0-9]*\\.)+)attribute\\.(?:([_a-z0-9][_a-zA-Z0-9]*))#(?:(create|load|update|delete))");
            String[] valuesSecurity = security.split(":");
            
            for (String valueSecurity : valuesSecurity) {
                Matcher matcher = propertiesPattern.matcher(valueSecurity);
                matcher.find();
                // className is fully qualified name of class
                String className = matcher.group(1);
                className = StringUtil.substring(className, 0, -1); // remove ended
                // .
                // target is class, attribute or operation
                String attributeName = matcher.group(2);
                String actions = matcher.group(3).toUpperCase();
                
                String query = "";
                String daoClass = "";
                if(className.equals(clazz.getQualifiedName())) {
                    query = "select " + attributeName + ".topiaId from " + clazz.getQualifiedName() + " where topiaId = :id";
                    daoClass = clazz.getAttribute(attributeName).getClassifier().getQualifiedName();
                } else {
                    query = "select at.topiaId from " + className + " at inner join at." + attributeName + " cl where cl.topiaId = :id";
                    daoClass = className;
                }
output.write("            resultPermissions.addAll(getRequestPermission(topiaId,\n");
output.write("                                                            "+actions+",\n");
output.write("                                                            \""+query+"\",\n");
output.write("                                                            "+daoClass+".class));\n");
output.write("");
            }
        } else {
output.write("            return null;\n");
output.write("");
        }
    }

    protected void generateNoNMultiplicity(Writer output, ObjectModelAttribute attr, boolean isAssoc) throws IOException {
    	String attrName = attr.getName();
    	String attrType = attr.getType();
        String propertyName = attrName;
        if (!isAssoc && attr.hasAssociationClass()) {
            propertyName = TopiaGeneratorUtil.toLowerCaseFirstLetter(attr.getAssociationClass().getName()) + "." + propertyName;
        }
output.write("\n");
output.write("    /**\n");
output.write("     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut\n");
output.write("     * "+attrName+" le paramètre\n");
output.write("     * @param v la valeur que doit avoir "+attrName+"\n");
output.write("     * @return un element ou null\n");
output.write("     */\n");
output.write("    public E findBy"+TopiaGeneratorUtil.capitalize(attrName)+"("+attrType+" v) throws TopiaException {\n");
output.write("        E result = findByProperty(\""+propertyName+"\", v);\n");
output.write("        return result;\n");
output.write("    }\n");
output.write("\n");
output.write("    /**\n");
output.write("     * Retourne les éléments ayant comme valeur pour l'attribut\n");
output.write("     * "+attrName+" le paramètre\n");
output.write("     * @param v la valeur que doit avoir "+attrName+"\n");
output.write("     * @return une liste\n");
output.write("     */\n");
output.write("    public List<E> findAllBy"+TopiaGeneratorUtil.capitalize(attrName)+"("+attrType+" v) throws TopiaException {\n");
output.write("        List<E> result = findAllByProperty(\""+propertyName+"\", v);\n");
output.write("        return result;\n");
output.write("    }\n");
output.write("");
        if (attr.hasAssociationClass()) {
        	String assocClassName = attr.getAssociationClass().getName();
        	String assocClassFQN = attr.getAssociationClass().getQualifiedName();
output.write("\n");
output.write("    /**\n");
output.write("     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut\n");
output.write("     * "+TopiaGeneratorUtil.toLowerCaseFirstLetter(assocClassName)+" le paramètre\n");
output.write("     * @param value la valeur que doit avoir "+TopiaGeneratorUtil.toLowerCaseFirstLetter(assocClassName)+"\n");
output.write("     * @return un element ou null\n");
output.write("     */\n");
output.write("    public E findBy"+TopiaGeneratorUtil.capitalize(assocClassName)+"("+assocClassFQN+" value) throws TopiaException {\n");
output.write("        E result = findByProperty(\""+TopiaGeneratorUtil.toLowerCaseFirstLetter(assocClassName)+"\", value);\n");
output.write("        return result;\n");
output.write("    }\n");
output.write("\n");
output.write("    /**\n");
output.write("     * Retourne les éléments ayant comme valeur pour l'attribut\n");
output.write("     * "+TopiaGeneratorUtil.toLowerCaseFirstLetter(assocClassName)+" le paramètre\n");
output.write("     * @param value la valeur que doit avoir "+TopiaGeneratorUtil.toLowerCaseFirstLetter(assocClassName)+"\n");
output.write("     * @return une liste\n");
output.write("     */\n");
output.write("    public List<E> findAllBy"+TopiaGeneratorUtil.capitalize(assocClassName)+"("+assocClassFQN+" value) throws TopiaException {\n");
output.write("        List<E> result = findAllByProperty(\""+TopiaGeneratorUtil.toLowerCaseFirstLetter(assocClassName)+"\", value);\n");
output.write("        return result;\n");
output.write("    }\n");
output.write("");
        }
    }        

    protected void generateNMultiplicity(Writer output, ObjectModelAttribute attr) throws IOException {
    	String attrName = attr.getName();
    	String attrType = attr.getType();
output.write("    \n");
output.write("    /**\n");
output.write("     * Retourne le premier élément trouvé dont l'attribut\n");
output.write("     * "+attrName+" contient le paramètre\n");
output.write("     * @param v la valeur que doit contenir "+attrName+"\n");
output.write("     * @return un element ou null\n");
output.write("     */\n");
output.write("    public E findContains"+TopiaGeneratorUtil.capitalize(attrName)+"("+attrType+" ... v) throws TopiaException {\n");
output.write("        E result = findContainsProperties(\""+TopiaGeneratorUtil.toLowerCaseFirstLetter(attrName)+"\", Arrays.asList(v));\n");
output.write("        return result;\n");
output.write("    }\n");
output.write("    /**\n");
output.write("     * Retourne les éléments trouvé dont l'attribut\n");
output.write("     * "+attrName+" contient le paramètre\n");
output.write("     * @param v la valeur que doit contenir "+attrName+"\n");
output.write("     * @return une liste\n");
output.write("     */\n");
output.write("    public List<E> findAllContains"+TopiaGeneratorUtil.capitalize(attrName)+"("+attrType+" ... v) throws TopiaException {\n");
output.write("        List<E> results = findAllContainsProperties(\""+TopiaGeneratorUtil.toLowerCaseFirstLetter(attrName)+"\", Arrays.asList(v));\n");
output.write("        return results;\n");
output.write("    }\n");
output.write("");        
    }
 
} //DAOAbstractGenerator
