/* *##% 
 * ToPIA :: Persistence
 * Copyright (C) 2004 - 2009 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * ##%*/




/* *
* EntityHibernateMappingGenerator.java
*
* Created: 12 déc. 2005
*
* @author Arnaud Thimel <thimel@codelutin.com>
* @version $Revision: 1766 $
*
* Mise a jour: $Date: 2010-01-18 20:18:40 +0100 (lun., 18 janv. 2010) $
* par : $Author: fdesbois $
* Mise a jour: $Date: 2010-01-18 20:18:40 +0100 (lun., 18 janv. 2010) $
* par : $Author: fdesbois $
*/

package org.nuiton.topia.generator;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.eugene.models.object.ObjectModelGenerator;
import org.nuiton.eugene.GeneratorUtil;
import org.nuiton.eugene.models.object.ObjectModelAssociationClass;
import org.nuiton.eugene.models.object.ObjectModelAttribute;
import org.nuiton.eugene.models.object.ObjectModelClass;
import static org.nuiton.topia.generator.TopiaGeneratorUtil.PERSISTENCE_TYPE_HIBERNATE;
import static org.nuiton.topia.generator.TopiaGeneratorUtil.STEREOTYPE_ENTITY;
import static org.nuiton.topia.generator.TopiaGeneratorUtil.TAG_ACCESS;
import static org.nuiton.topia.generator.TopiaGeneratorUtil.hasUnidirectionalRelationOnAbstractType;

import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.BooleanUtils;

/**
 * FIXME mettre les attributs node="..." sur tous les attributs
 * @author poussin
 * @plexus.component role="org.nuiton.eugene.Template" role-hint="org.nuiton.topia.generator.EntityHibernateMappingGenerator"
 */
public class EntityHibernateMappingGenerator extends ObjectModelGenerator {

    /**
     * Logger for this class
     */
    private static final Log log = LogFactory
            .getLog(EntityHibernateMappingGenerator.class);

    private Map<String, String[]> columnNamesMap = new HashMap<String, String[]>();

    @Override
    public String getFilenameForClass(ObjectModelClass clazz) {
        String DOName = TopiaGeneratorUtil.getDOType(clazz, model);
        return DOName.replace('.', File.separatorChar) + ".hbm.xml";
    }

    @Override
    public void generateFromClass(Writer output, ObjectModelClass clazz) throws IOException {
        String persistenceType = TopiaGeneratorUtil.getPersistenceType(clazz);
        if (!clazz.hasStereotype(STEREOTYPE_ENTITY) && PERSISTENCE_TYPE_HIBERNATE.equals(persistenceType)) {
            return;
        }
output.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
output.write("<!DOCTYPE hibernate-mapping PUBLIC \"-//Hibernate/Hibernate Mapping DTD 3.0//EN\" \"http://hibernate.sourceforge.net/hibernate-mapping-3.0.dtd\">\n");
output.write("<hibernate-mapping default-access=\"field\" auto-import=\"true\" package=\""+clazz.getPackageName()+"\">\n");
output.write("");
        boolean haveSuper = clazz.getSuperclasses().size() > 0;
        // la liste des attributs faisant parti de la clef metier
        List<ObjectModelAttribute> naturalAttributes = new ArrayList<ObjectModelAttribute>();
        // la liste des autres attributs
        List<ObjectModelAttribute> noneNaturalAttributes = new ArrayList<ObjectModelAttribute>();

        String clazzDOType = TopiaGeneratorUtil.getDOType(clazz, model);
        String tableName = TopiaGeneratorUtil.getDBName(clazz);
        String isAbstract = BooleanUtils.toStringTrueFalse(clazz.isAbstract());
        String clazzFQN = clazz.getQualifiedName();
        
        String optionalAttributes = "";
        String schema = TopiaGeneratorUtil.getSchemaName(clazz, model);
        if (schema != null) {
        	optionalAttributes += "schema=\"" + schema + "\" "; 
        }
        
        //On précise au proxy de quelle interface hérite l'objet
        String proxyTagValue = TopiaGeneratorUtil.findTagValue(TopiaGeneratorUtil.TAG_PROXY_INTERFACE, clazz, model);
        if (proxyTagValue == null || !proxyTagValue.equals("none")) {
            optionalAttributes += "proxy=\"" + clazzFQN + "\" ";
        }

        if (haveSuper) {
            ObjectModelClass superClass = clazz.getSuperclasses().iterator().next();
            String superClassname = superClass.getQualifiedName();
            if (log.isDebugEnabled()) {
            	log.debug("superClass for " + clazz.getQualifiedName() + " is " + superClassname);
            }
            String superClassDOType = TopiaGeneratorUtil.getDOType(superClassname, model);

output.write("    <union-subclass name=\""+clazzDOType+"\" extends=\""+superClassDOType+"\" table=\""+tableName+"\" node=\""+clazzDOType+"\" abstract=\""+isAbstract+"\" "+optionalAttributes+">\n");
output.write("        <!--key column=\"topiaId\"/-->\n");
output.write("");
            // FIXME mieux gerer le cas haveSuper
            noneNaturalAttributes.addAll(clazz.getAttributes());
        } else {
output.write("    <class name=\""+clazzDOType+"\" table=\""+tableName+"\" node=\""+clazzDOType+"\" abstract=\""+isAbstract+"\" "+optionalAttributes+">\n");
output.write("        <id name=\"topiaId\" type=\"string\" length=\"255\" node=\"@topiaId\"/>\n");
output.write("");
            // on detecte les attributs des clef metiers            
            for (ObjectModelAttribute attr : clazz.getAttributes()) {
                if (TopiaGeneratorUtil.isNaturalId(attr)) {
                    // attribut metier
                    naturalAttributes.add(attr);
                } else {
                    // attribut normal
                    noneNaturalAttributes.add(attr);
                }
            }
            if (!naturalAttributes.isEmpty()) {
                // generation de la clef metier
                boolean mutable = TopiaGeneratorUtil.isNaturalIdMutable(clazz);
                String mutableStr = mutable ? " mutable=\"true\"" : "";
                if (log.isDebugEnabled()) {
                    log.debug("natural-id detected for class " + clazz.getName() + " (" + mutableStr + ") attributes : " + naturalAttributes);
                }
output.write("        <natural-id"+mutableStr+">\n");
output.write("");
                generateAttributes(output, clazz, naturalAttributes, "    ");
output.write("        </natural-id>\n");
output.write("");
            }
output.write("        <version name=\"topiaVersion\" type=\"long\" node=\"@topiaVersion\"/>\n");
output.write("        <property name=\"topiaCreateDate\" type=\"timestamp\" node=\"@topiaCreateDate\"/>\n");
output.write("");
        }

        generateAttributes(output, clazz, noneNaturalAttributes, "");

        if (haveSuper) {
output.write("    </union-subclass>\n");
output.write("");
        } else {
output.write("    </class>\n");
output.write("");
        }
output.write("</hibernate-mapping>\n");
output.write("");
    }

    protected void generateAttributes(Writer output, ObjectModelClass clazz, List<ObjectModelAttribute> attributes, String prefix) throws IOException {
        for (ObjectModelAttribute attr : attributes) {
            ObjectModelAttribute reverse = attr.getReverseAttribute();

            // pour les asso quoi qu'il arrive il faut les lier des 2 cotes
            // pour pouvoir supprimer en cascade l'asso lors de la suppression
            // d'un des cotes
            if (attr.isNavigable()
                    || hasUnidirectionalRelationOnAbstractType(reverse, model)
                    || attr.hasAssociationClass()) {
                if (!GeneratorUtil.isNMultiplicity(attr)) {
                    if (attr.getClassifier() != null && attr.getClassifier().hasStereotype(STEREOTYPE_ENTITY)) {
                        if (GeneratorUtil.isNMultiplicity(attr.getReverseMaxMultiplicity()) && !attr.hasAssociationClass()) {
                            generateHibernateManyToOne(output, attr, prefix);
                        } else {
                            generateHibernateOneToOne(output, attr, prefix);
                        }
                    } else {
                        generateHibernateProperty(output, attr, prefix);
                    }
                } else {
                    if (attr.getClassifier() != null && attr.getClassifier().hasStereotype(STEREOTYPE_ENTITY)) {
                        if (GeneratorUtil.isNMultiplicity(attr.getReverseMaxMultiplicity()) && !attr.hasAssociationClass()) {
                            generateHibernateManyToMany(output, attr, prefix);
                        } else {
                            generateHibernateOneToMany(output, attr, prefix);
                        }
                    } else {
                        generateHibernateMany(output, attr, prefix);
                    }
                }
            }
        }

        //Attributs pour les classes d'association
        if (clazz instanceof ObjectModelAssociationClass) {
            ObjectModelAssociationClass assoc = (ObjectModelAssociationClass)clazz;
            for (ObjectModelAttribute attr : assoc.getParticipantsAttributes()) {
                if (attr != null) {

// Note(poussin) pour moi quoi qu'il arrive sur la classe d'association il faut
// un many-to-one, sinon on a des problemes.
//                    if ((!attr.getReverseAttribute().isNavigable()) || !Util.isNMultiplicity(attr.getReverseAttribute())) {
// / *{        <one-to-one name="<%=getName(attr, true)%>" class="<%=getType(attr, true)%>"<%=(TopiaGeneratorUtil.notEmpty(attr.getTagValue(TopiaGeneratorUtil.TAG_LENGTH))?(" length=\"" + attr.getTagValue(TopiaGeneratorUtil.TAG_LENGTH) + "\""):"")%><%=(attr.isComposite()?" cascade=\"delete\"":"")%>/>
// } */
//                    } else {
                    String notNull = " " + generateFromTagValue(attr, TopiaGeneratorUtil.TAG_NOT_NULL, "not-null");
                    String attrName = getName(attr, true);
                    String attrType = getType(attr, true);
                    String attrColumn = TopiaGeneratorUtil.getDBName(attr);
output.write(""+prefix+"        <many-to-one name=\""+attrName+"\" class=\""+attrType+"\" column=\""+attrColumn+"\" node=\""+attrName+"/@topiaId\" embed-xml=\"false\" "+notNull+"/>\n");
output.write("");
//                    }
                    //Ne sert plus grâce à l'utilisation de la navigabilité
//                    if (!attr.getReverseAttribute().isNavigable()) {
//                        String type = GeneratorUtil.getDOType(((ObjectModelClassifier)attr.getDeclaringElement()).getQualifiedName(), model);
//                        String name = Util.toLowerCaseFirstLetter(attr.getDeclaringElement().getName());
//                        if (log.isTraceEnabled()) {log.trace("reverse: " + type + " " + name);}
//                        if (!Util.isNMultiplicity(attr)) {
//{<!--        <one-to-one name="<%=name%>" class="<%=type%>"/>
//}
//                        } else {
//{        <many-to-one name="<%=name%>" class="<%=type%>" column="<%=name.toLowerCase()%>"/> -->
//}
//                        }
//                    }
                }
            }
        }
    }

    protected String getName(ObjectModelAttribute attr) {
        return getName(attr, false);
    }

    protected String getName(ObjectModelAttribute attr, boolean isAssoc) {
        String result = GeneratorUtil.toLowerCaseFirstLetter(attr.getName());
        if (attr.hasAssociationClass() && !isAssoc) {
            result = TopiaGeneratorUtil.getAssocAttrName(attr);
        }
        return result;
    }

    protected String getType(ObjectModelAttribute attr) {
        return getType(attr, false);
    }

    protected String getType(ObjectModelAttribute attr, boolean isAssoc) {
        String type = attr.getType();
        if (TopiaGeneratorUtil.notEmpty(model.getTagValue(type))) {
            String typeString = model.getTagValue(type);
            int bracketIndex = typeString.indexOf('(');
            if (bracketIndex != -1) {
                type = typeString.substring(0, bracketIndex);
                int bracketEndIndex = typeString.indexOf(')', bracketIndex + 1);
                String colmunList;
                if (bracketEndIndex != -1) {
                    colmunList = typeString.substring(bracketIndex + 1, bracketEndIndex);
                } else {
                    colmunList = typeString.substring(bracketIndex);
                }
                columnNamesMap.put(type, colmunList.split(","));
            } else {
                type = typeString;
            }
        }
        if (attr.hasAssociationClass() && !isAssoc) {
            type = attr.getAssociationClass().getQualifiedName();
        }
        return TopiaGeneratorUtil.getDOType(type, model);
    }

    protected void generateHibernateProperty(Writer output, ObjectModelAttribute attr, String prefix) throws IOException {
        String attrType = getType(attr);

        String accessField = "field";
        if (attr.hasTagValue(TAG_ACCESS)) {
        	accessField = attr.getTagValue(TAG_ACCESS);
        }
        String attrName = attr.getName();
        String declaringElementDBName = TopiaGeneratorUtil.getDBName(attr.getDeclaringElement());
        String tableName = declaringElementDBName + "_" + attrName;

        if (attrType.trim().endsWith("[]")) {
            attrType = attrType.trim().substring(0, attrType.trim().length()-2);

            String optionalAttributes = "";
            String schema = TopiaGeneratorUtil.getSchemaName(attr, model);
            if (schema != null) {
            	optionalAttributes += "schema=\"" + schema + "\" "; 
            }

            if (attr.isIndexed()) {
            	String indexName = tableName + "_idx";
            	optionalAttributes += "index=\"" + indexName + "\" ";
            }

output.write(""+prefix+"        <primitive-array name=\""+attrName+"\" table=\""+tableName+"\" access=\""+accessField+"\" "+optionalAttributes+">\n");
output.write(""+prefix+"          <key column=\""+declaringElementDBName+"\"/>\n");
output.write(""+prefix+"          <list-index column=\""+attrName+"_idx\"/>\n");
output.write(""+prefix+"          <element type=\""+attrType+"\"/>\n");
output.write(""+prefix+"        </primitive-array>\n");
output.write("");
        } else {
            String optionalAttributes = "";
            if (attr.isIndexed()) {
            	String indexName = tableName + "_idx";
            	optionalAttributes += "index=\"" + indexName + "\"";
            }
            if (attr.hasStereotype(TopiaGeneratorUtil.STEREOTYPE_UNIQUE)) {
                // the trim method is called on optionalAttributes after this set to suppress unusual space if no index is set on this attribute
                optionalAttributes += " unique=\"true\"";
            }
            optionalAttributes += generateFromTagValue(attr, TopiaGeneratorUtil.TAG_NOT_NULL, "not-null");
output.write(""+prefix+"        <property name=\""+attrName+"\" type=\""+attrType+"\" access=\""+accessField+"\" ");
            optionalAttributes = optionalAttributes.trim();
            String[] columnNames = this.columnNamesMap.get(attrType);
            if (columnNames == null || columnNames.length == 0) {
                optionalAttributes += generateFromTagValue(attr, TopiaGeneratorUtil.TAG_LENGTH, "length");
                String attrColumn = TopiaGeneratorUtil.getDBName(attr);
                optionalAttributes = optionalAttributes.trim();
                if (!optionalAttributes.isEmpty())
                    optionalAttributes = " " + optionalAttributes;
output.write("column=\""+attrColumn+"\" node=\""+attrName+"\""+optionalAttributes+"/>\n");
output.write("");
            } else {
output.write(""+optionalAttributes+">\n");
output.write("");
                for (String columnName : columnNames) {
                    columnName = attrName + "_" + columnName.trim();
output.write(""+prefix+"            <column name=\""+columnName+"\"/>\n");
output.write("");
                }
output.write(""+prefix+"        </property>\n");
output.write("");
            }
        }
    }

    protected void generateHibernateOneToOne(Writer output, ObjectModelAttribute attr, String prefix) throws IOException {
//      boolean accessField = hasUnidirectionalRelationOnAbstractType(attr.getReverseAttribute(), model);
/// *{        <one-to-one name="<%=getName(attr)%>" class="<%=getType(attr)%>"<%=(TopiaGeneratorUtil.notEmpty(attr.getTagValue(GeneratorUtil.TAG_LENGTH))?(" length=\"" + attr.getTagValue(GeneratorUtil.TAG_LENGTH) + "\""):"")%><%=((attr.isComposite() || attr.hasAssociationClass())?" cascade=\"delete\"":"")%><%=((accessField)?" access=\"field\"":"")%> node="<%=getName(attr)%>/@topiaId" embed-xml="false"/>
//} */
        
        // for hibernate many-to-one with unique="true" => one-to-one
        // but if it is one-to-zero-or-one unique contraints is violated
        // with null values
        boolean unique = TopiaGeneratorUtil.isOneMultiplicity(attr);
        generateHibernateManyToOne(output, attr, unique, prefix);

    }

    protected void generateHibernateOneToMany(Writer output, ObjectModelAttribute attr, String prefix) throws IOException {
        boolean needsIndex = attr.isIndexed();
        boolean isInverse = attr.getReverseAttribute().isNavigable();
        isInverse |= hasUnidirectionalRelationOnAbstractType(attr, model);

        String attrName = getName(attr);
        String attrType = getType(attr);
        String reverseAttrDBName = TopiaGeneratorUtil.getReverseDBName(attr);
        String orderBy = generateFromTagValue(attr, TopiaGeneratorUtil.TAG_ORDER_BY, "order-by");

        String cascade = "";
        if (attr.isComposite() || attr.hasAssociationClass()) {
            cascade += "cascade=\"all,delete-orphan\" ";
        }

        String lazy = generateFromTagValue(attr, TopiaGeneratorUtil.TAG_LAZY, "lazy", "true");

        String fetch = generateFromTagValue(attr, TopiaGeneratorUtil.TAG_FETCH, "fetch");

        String collType = TopiaGeneratorUtil.getNMultiplicityHibernateType(attr);
        String inverse = "";
        if (isInverse) {
        	inverse = "inverse=\"true\" ";
        }
        if (needsIndex) {
output.write(""+prefix+"        <"+collType+" name=\""+attrName+"\" "+inverse+""+lazy+""+cascade+"node=\""+attrName+"\" embed-xml=\"false\">\n");
output.write(""+prefix+"            <key column=\""+reverseAttrDBName+"\"/>\n");
output.write(""+prefix+"            <list-index column=\""+reverseAttrDBName+"_idx\"/>\n");
output.write(""+prefix+"            <one-to-many class=\""+attrType+"\" node=\"topiaId\" embed-xml=\"false\"/>\n");
output.write(""+prefix+"        </"+collType+">\n");
output.write("");
        }else {
//fixme pour le moment, on ne calcule pas si on doit autoriser le embed-xml à true
// on le positionne manuellement
//TC-20090115 embed-xml wasat true but nobody could tellme why
output.write(""+prefix+"        <"+collType+" name=\""+attrName+"\" "+inverse+""+orderBy+""+fetch+""+lazy+""+cascade+"node=\""+attrName+"\" embed-xml=\"false\">\n");
output.write(""+prefix+"            <key column=\""+reverseAttrDBName+"\"/>\n");
output.write(""+prefix+"            <one-to-many class=\""+attrType+"\" node=\"topiaId\" embed-xml=\"false\"/>\n");
output.write(""+prefix+"        </"+collType+">\n");
output.write("");
        }
    }

    private String generateFromTagValue(ObjectModelAttribute attr,
			String tagName, String attributeName) {
		return generateFromTagValue(attr, tagName, attributeName, null);
	}

    /**
     * Generate hibernate xml attribute with a final space.
     */
    private String generateFromTagValue(ObjectModelAttribute attr,
			String tagName, String attributeName, String defaultValue) {
		String result = "";
		if (attr.hasTagValue(tagName) || defaultValue != null) {
			result+= attributeName + "=\"";
			if (attr.hasTagValue(tagName)) {
				result += attr.getTagValue(tagName);
			} else {
				result += defaultValue;
			}
			result += "\" ";
		}
		return result;
	}

	protected void generateHibernateMany(Writer output, ObjectModelAttribute attr, String prefix) throws IOException {
        boolean needsIndex = attr.isIndexed();
        String attrName = getName(attr);
        String attrType = getType(attr);
        String collType = TopiaGeneratorUtil.getNMultiplicityHibernateType(attr);
        String lazy = generateFromTagValue(attr, TopiaGeneratorUtil.TAG_LAZY, "lazy");
        String attrColumn = TopiaGeneratorUtil.getDBName(attr);

output.write(""+prefix+"        <"+collType+" name=\""+attrName+"\" "+lazy+"node=\""+attrName+"\" embed-xml=\"true\">\n");
output.write(""+prefix+"            <key column=\"OWNER\"/>\n");
output.write("");
        if (needsIndex) {
output.write(""+prefix+"        <list-index/>\n");
output.write("");
        }
output.write(""+prefix+"            <element type=\""+attrType+"\" column=\""+attrColumn+"\" node=\"id\"/>\n");
output.write(""+prefix+"        </"+collType+">\n");
output.write("");
    }

    protected void generateHibernateManyToOne(Writer output, ObjectModelAttribute attr, String prefix) throws IOException {
        generateHibernateManyToOne(output, attr, false, prefix);
    }

    protected void generateHibernateManyToOne(Writer output, ObjectModelAttribute attr, boolean isUnique, String prefix) throws IOException {
    	String attrName = getName(attr);
    	String attrType = getType(attr);
    	String attrColumn = TopiaGeneratorUtil.getDBName(attr);
output.write(""+prefix+"        <many-to-one name=\""+attrName+"\" class=\""+attrType+"\" column=\""+attrColumn+"\" ");
        if (attr.isComposite() || attr.hasAssociationClass()) {
output.write("cascade=\"delete\" ");
        }
        // Pour le test suivant, on verifie d'abord que l'attribut a un reverse.
        // S'il n'en a pas, cela signifie qu'il ne s'agit pas d'un entite
        // (au sens stereotype entity), donc a donc pas besoin de faire un access=field.
        if (attr.getReverseAttribute() != null && hasUnidirectionalRelationOnAbstractType(attr.getReverseAttribute(), model)) {
output.write("access=\"field\" ");
        }
        // vérifier si le tag lazy est defini par defaut dans le fichier de proprietes
        String lazy = generateFromTagValue(attr, TopiaGeneratorUtil.TAG_LAZY, "lazy");
output.write(""+lazy+"");
        String notNull = " " + generateFromTagValue(attr, TopiaGeneratorUtil.TAG_NOT_NULL, "not-null");
output.write(""+notNull+"");
        if (isUnique) {
output.write("unique=\"true\" ");
        }
output.write("node=\""+attrName+"/@topiaId\" embed-xml=\"false\"");

output.write("/>\n");
output.write("");
    }

    protected void generateHibernateManyToMany(Writer output, ObjectModelAttribute attr, String prefix) throws IOException {
        // On ne met le inverse="true" uniquement pour un seul coté de la relation.
        // Dans le cas contraire, les modifications dans la relation ne seront
        // pas sauvegardées. Ceci n'est vrai que si les deux coté sont navigable
        boolean isInverse = attr.isNavigable() && attr.getReverseAttribute().isNavigable();
        //isInverse |= !Util.isFirstAttribute(attr);
        //isInverse = false; // 20070117 poussin: pour du many, jamais de inverse
        isInverse &= GeneratorUtil.isFirstAttribute(attr);

        boolean needsIndex = attr.isIndexed();
        String cascade = "";
        if (attr.isComposite() || attr.hasAssociationClass()) {
            cascade = " cascade=\"delete,delete-orphan\"";
        }

        String attrType = getType(attr);
        String attrName = getName(attr);
        String attrColumn = TopiaGeneratorUtil.getDBName(attr);
        String lazy = generateFromTagValue(attr, TopiaGeneratorUtil.TAG_LAZY, "lazy", "true");
        String orderBy = generateFromTagValue(attr, TopiaGeneratorUtil.TAG_ORDER_BY, "order-by");
        String collType = TopiaGeneratorUtil.getNMultiplicityHibernateType(attr);
        String tableName = TopiaGeneratorUtil.getManyToManyTableName(attr);
        String inverse = "";
        if (isInverse) {
        	inverse = "inverse=\"true\" ";
        }
        String reverseAttrDBName = TopiaGeneratorUtil.getReverseDBName(attr);

output.write(""+prefix+"        <"+collType+" name=\""+attrName+"\" table=\""+tableName+"\" "+inverse+""+lazy+""+cascade+" node=\""+attrName+"\" embed-xml=\"true\">\n");
output.write(""+prefix+"            <key column=\""+reverseAttrDBName+"\"/>\n");
output.write("");
        if (needsIndex) {
output.write(""+prefix+"        <list-index column=\""+reverseAttrDBName+"_idx\"/>\n");
output.write("");
        }
output.write(""+prefix+"            <many-to-many class=\""+attrType+"\" column=\""+attrColumn+"\" "+orderBy+"node=\"topiaId\"/>\n");
output.write(""+prefix+"        </"+collType+">\n");
output.write("");
    }

} //EntityHibernateMappingGenerator
