/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.junit;

import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.util.FileUtil;

public class ConfigurationHelper {
    public static final String TIMESTAMP = String.valueOf(System.nanoTime());
    private static final Log log = LogFactory.getLog(ConfigurationHelper.class);

    public static File getTestWorkdir() {
        String base = System.getProperty("java.io.tmpdir");
        if (base == null || base.isEmpty()) {
            base = new File("").getAbsolutePath();
            if (log.isWarnEnabled()) {
                log.warn((Object)"'\"java.io.tmpdir\" not defined");
            }
        }
        File result = new File(base);
        if (log.isDebugEnabled()) {
            log.debug((Object)("basedir for test " + result));
        }
        return result;
    }

    public static File getTestBasedir(Class<?> testClass) throws IOException {
        File dir = ConfigurationHelper.getTestWorkdir();
        File result = new File(dir, testClass.getName());
        if (result.exists()) {
            FileUtils.deleteDirectory((File)result);
        }
        FileUtil.createDirectoryIfNecessary((File)result);
        return result;
    }

    public static File getTestSpecificDirectory(Class<?> testClassName, String methodName) {
        File tempDirFile = ConfigurationHelper.getTestWorkdir();
        String dataBasePath = testClassName.getName() + File.separator + methodName + '_' + TIMESTAMP;
        File databaseFile = new File(tempDirFile, dataBasePath);
        return databaseFile;
    }
}

