/*
 * Decompiled with CFR 0.152.
 */
package com.l2fprod.common.swing.plaf.basic;

import com.l2fprod.common.swing.JButtonBar;
import com.l2fprod.common.swing.PercentLayout;
import com.l2fprod.common.swing.plaf.ButtonBarUI;
import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;

public class BasicButtonBarUI
extends ButtonBarUI {
    protected JButtonBar bar;
    protected PropertyChangeListener propertyListener;

    public static ComponentUI createUI(JComponent c) {
        return new BasicButtonBarUI();
    }

    public void installUI(JComponent c) {
        super.installUI(c);
        this.bar = (JButtonBar)c;
        this.installDefaults();
        this.installListeners();
        this.updateLayout();
    }

    public void uninstallUI(JComponent c) {
        this.uninstallDefaults();
        this.uninstallListeners();
        super.uninstallUI(c);
    }

    protected void installDefaults() {
    }

    protected void uninstallDefaults() {
    }

    protected void installListeners() {
        this.propertyListener = this.createPropertyChangeListener();
        this.bar.addPropertyChangeListener(this.propertyListener);
    }

    protected void uninstallListeners() {
        this.bar.removePropertyChangeListener(this.propertyListener);
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return new ChangeListener();
    }

    protected void updateLayout() {
        if (this.bar.getOrientation() == 0) {
            this.bar.setLayout(new PercentLayout(0, 2));
        } else {
            this.bar.setLayout(new PercentLayout(1, 2));
        }
    }

    public Dimension getPreferredSize(JComponent c) {
        JButtonBar bar = (JButtonBar)c;
        Dimension preferred = bar.getLayout().preferredLayoutSize(c);
        if (bar.getOrientation() == 0) {
            return new Dimension(preferred.width, 53);
        }
        return new Dimension(74, preferred.height);
    }

    private class ChangeListener
    implements PropertyChangeListener {
        private ChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals("orientation")) {
                BasicButtonBarUI.this.updateLayout();
                BasicButtonBarUI.this.bar.revalidate();
                BasicButtonBarUI.this.bar.repaint();
            }
        }
    }
}

