/*
 * Decompiled with CFR 0.152.
 */
package com.l2fprod.common.propertysheet;

import com.l2fprod.common.propertysheet.Property;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javax.swing.table.AbstractTableModel;

public class PropertySheetTableModel
extends AbstractTableModel
implements PropertyChangeListener {
    private PropertyChangeSupport listeners = new PropertyChangeSupport(this);
    private List model = new ArrayList();
    private List publishedModel = new ArrayList();
    private Property[] properties;
    private int mode = 0;
    private boolean sortingCategories = false;
    private boolean sortingProperties = false;
    private Comparator categorySortingComparator;
    private Comparator propertySortingComparator;
    private static final Comparator STRING_COMPARATOR = new NaturalOrderStringComparator();

    public void setProperties(Property[] properties) {
        int i;
        int c;
        Property[] oldProperties = this.properties;
        if (oldProperties != null) {
            c = oldProperties.length;
            for (i = 0; i < c; ++i) {
                oldProperties[i].removePropertyChangeListener(this);
            }
        }
        this.properties = properties;
        if (properties != null) {
            c = properties.length;
            for (i = 0; i < c; ++i) {
                properties[i].addPropertyChangeListener(this);
            }
        }
        this.buildModel();
    }

    public Property[] getProperties() {
        return this.properties;
    }

    public void setMode(int mode) {
        if (this.mode == mode) {
            return;
        }
        this.mode = mode;
        this.buildModel();
    }

    public int getMode() {
        return this.mode;
    }

    public Class getColumnClass(int columnIndex) {
        return super.getColumnClass(columnIndex);
    }

    public int getColumnCount() {
        return 2;
    }

    public int getRowCount() {
        return this.publishedModel.size();
    }

    public Object getPropertySheetElement(int rowIndex) {
        return this.publishedModel.get(rowIndex);
    }

    public boolean isSortingCategories() {
        return this.sortingCategories;
    }

    public void setSortingCategories(boolean value) {
        this.sortingCategories = value;
        this.buildModel();
    }

    public boolean isSortingProperties() {
        return this.sortingProperties;
    }

    public void setSortingProperties(boolean value) {
        this.sortingProperties = value;
        this.buildModel();
    }

    public void setCategorySortingComparator(Comparator comp) {
        this.categorySortingComparator = comp;
        this.buildModel();
    }

    public void setPropertySortingComparator(Comparator comp) {
        this.propertySortingComparator = comp;
        this.buildModel();
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        Object o = this.getPropertySheetElement(rowIndex);
        if (o instanceof Property) {
            switch (columnIndex) {
                case 0: {
                    return o;
                }
                case 1: {
                    try {
                        return ((Property)o).getValue();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        return null;
                    }
                }
            }
        } else if (o instanceof Category) {
            return o;
        }
        return null;
    }

    public void setValueAt(Object value, int rowIndex, int columnIndex) {
        Object o = this.getPropertySheetElement(rowIndex);
        if (o instanceof Property && columnIndex == 1) {
            try {
                ((Property)o).setValue(value);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.listeners.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.listeners.removePropertyChangeListener(listener);
    }

    public void propertyChange(PropertyChangeEvent evt) {
        this.listeners.firePropertyChange(evt);
    }

    private void categoryVisibilityChanged() {
        this.publishedModel.clear();
        Category currentCategory = null;
        Iterator iter = this.model.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (o instanceof Category) {
                currentCategory = (Category)o;
                this.publishedModel.add(o);
                continue;
            }
            if (currentCategory == null || !currentCategory.isVisible()) continue;
            this.publishedModel.add(o);
        }
        this.fireTableDataChanged();
    }

    private void buildModel() {
        this.model.clear();
        this.publishedModel.clear();
        if (this.properties != null && this.properties.length > 0) {
            if (0 == this.mode) {
                Property[] tempProperties = new Property[this.properties.length];
                for (int a = 0; a < this.properties.length; ++a) {
                    tempProperties[a] = this.properties[a];
                }
                if (this.sortingProperties) {
                    if (this.propertySortingComparator == null) {
                        this.propertySortingComparator = new PropertyComparator();
                    }
                    Arrays.sort(tempProperties, this.propertySortingComparator);
                }
                int c = tempProperties.length;
                for (int i = 0; i < c; ++i) {
                    this.model.add(tempProperties[i]);
                }
            } else if (1 == this.mode) {
                ArrayList<String> differentCategories = new ArrayList<String>();
                int c = this.properties.length;
                for (int i = 0; i < c; ++i) {
                    if (differentCategories.contains(this.properties[i].getCategory())) continue;
                    differentCategories.add(this.properties[i].getCategory());
                }
                String[] categories = differentCategories.toArray(new String[0]);
                if (this.sortingCategories) {
                    if (this.categorySortingComparator == null) {
                        this.categorySortingComparator = STRING_COMPARATOR;
                    }
                    Arrays.sort(categories, this.categorySortingComparator);
                }
                int c2 = categories.length;
                for (int i = 0; i < c2; ++i) {
                    this.model.add(new Category(categories[i]));
                    Property[] tempProperties = this.getPropertiesForCategory(this.properties, categories[i]);
                    if (this.sortingProperties) {
                        if (this.propertySortingComparator == null) {
                            this.propertySortingComparator = new PropertyComparator();
                        }
                        Arrays.sort(tempProperties, this.propertySortingComparator);
                    }
                    for (int a = 0; a < tempProperties.length; ++a) {
                        this.model.add(tempProperties[a]);
                    }
                }
            }
            this.publishedModel.addAll(this.model);
        }
        this.fireTableDataChanged();
    }

    private Property[] getPropertiesForCategory(Property[] props, String category) {
        ArrayList<Property> propList = new ArrayList<Property>();
        for (int a = 0; a < props.length; ++a) {
            if (category != props[a].getCategory() && (category == null || !category.equals(props[a].getCategory()))) continue;
            propList.add(props[a]);
        }
        Property[] propArray = new Property[propList.size()];
        propList.toArray(propArray);
        return propArray;
    }

    public static class NaturalOrderStringComparator
    implements Comparator {
        public int compare(Object o1, Object o2) {
            String s1 = (String)o1;
            String s2 = (String)o2;
            if (s1 == null) {
                return s2 == null ? 0 : -1;
            }
            if (s2 == null) {
                return 1;
            }
            return s1.compareTo(s2);
        }
    }

    public static class PropertyComparator
    implements Comparator {
        public int compare(Object o1, Object o2) {
            if (o1 instanceof Property && o2 instanceof Property) {
                Property prop1 = (Property)o1;
                Property prop2 = (Property)o2;
                if (prop1 == null) {
                    return prop2 == null ? 0 : -1;
                }
                return STRING_COMPARATOR.compare(prop1.getDisplayName() == null ? null : prop1.getDisplayName().toLowerCase(), prop2.getDisplayName() == null ? null : prop2.getDisplayName().toLowerCase());
            }
            return 0;
        }
    }

    public class Category {
        private String name;
        private boolean visible = true;

        public Category(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public void toggle() {
            this.visible = !this.visible;
            PropertySheetTableModel.this.categoryVisibilityChanged();
        }

        public boolean isVisible() {
            return this.visible;
        }
    }
}

