/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.scmwebeditor.svn;

import java.util.List;
import javax.naming.AuthenticationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.scmwebeditor.api.OperationNotSupportedException;
import org.nuiton.scmwebeditor.api.RepositoryNotFoundException;
import org.nuiton.scmwebeditor.api.ScmConnection;
import org.nuiton.scmwebeditor.api.ScmFileManager;
import org.nuiton.scmwebeditor.api.ScmProvider;
import org.nuiton.scmwebeditor.api.SweInternalException;
import org.nuiton.scmwebeditor.api.dto.CreateBranchDto;
import org.nuiton.scmwebeditor.svn.SvnConnection;
import org.nuiton.scmwebeditor.svn.SvnFileManager;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.io.dav.DAVRepositoryFactory;
import org.tmatesoft.svn.core.internal.io.svn.SVNRepositoryFactoryImpl;

public class SvnProvider
implements ScmProvider {
    private static final Log log = LogFactory.getLog(SvnProvider.class);

    public SvnProvider() {
        SVNRepositoryFactoryImpl.setup();
        DAVRepositoryFactory.setup();
    }

    public boolean supportsBranches() {
        return false;
    }

    public List<String> listBranches(String address, String username, String password) throws OperationNotSupportedException {
        throw new OperationNotSupportedException("The 'list branches' operation is not available for SVN repositories");
    }

    public String createBranch(CreateBranchDto dto) throws OperationNotSupportedException, AuthenticationException, RepositoryNotFoundException {
        throw new OperationNotSupportedException("The 'create a branch' operation is not available for SVN repositories");
    }

    public String changeBranch(String branchName, String pathToLocalRepos, String username, String password) throws OperationNotSupportedException {
        throw new OperationNotSupportedException("The 'change branch' operation is not available for SVN repositories");
    }

    public boolean supportsPush() {
        return false;
    }

    public boolean filesDirectlyAccessible() {
        return true;
    }

    public ScmConnection getConnection(String address, String pathToLocalRepos) {
        SvnConnection svnConn;
        block2: {
            svnConn = null;
            try {
                svnConn = new SvnConnection(address, pathToLocalRepos);
            }
            catch (SVNException e) {
                if (!log.isErrorEnabled()) break block2;
                log.error((Object)("Can not connect to SVN repository at " + address), (Throwable)e);
            }
        }
        return svnConn;
    }

    public ScmFileManager getFileManager(ScmConnection connection) {
        SvnFileManager fileManager = null;
        if (connection instanceof SvnConnection) {
            try {
                fileManager = new SvnFileManager((SvnConnection)connection);
            }
            catch (SVNException e) {
                if (log.isErrorEnabled()) {
                    log.error((Object)"Can not connect to SVN repository", (Throwable)e);
                }
            }
        } else {
            throw new SweInternalException("Can not get SVN file manager for a non-SVN connection");
        }
        return fileManager;
    }

    public boolean addressSeemsCompatible(String address) {
        return address.startsWith("svn://") || address.contains("svn.") || address.contains("subversion.");
    }

    public String getDefaultBranchName() throws OperationNotSupportedException {
        throw new OperationNotSupportedException("The 'get default branch name' operation is not available for SVN repositories");
    }
}

