/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.validator.xwork2;

import com.opensymphony.xwork2.ActionContext;
import com.opensymphony.xwork2.DefaultLocaleProvider;
import com.opensymphony.xwork2.LocaleProvider;
import com.opensymphony.xwork2.ValidationAwareSupport;
import com.opensymphony.xwork2.interceptor.ValidationAware;
import com.opensymphony.xwork2.util.ValueStack;
import com.opensymphony.xwork2.validator.ActionValidatorManager;
import com.opensymphony.xwork2.validator.DelegatingValidatorContext;
import com.opensymphony.xwork2.validator.ValidationException;
import com.opensymphony.xwork2.validator.ValidatorContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.validator.xwork2.XWork2ValidatorUtil;

public class XWork2ScopeValidator<O> {
    private static final Log log = LogFactory.getLog(XWork2ScopeValidator.class);
    protected static final Map<String, List<String>> EMPTY_RESULT = Collections.unmodifiableMap(new HashMap());
    protected final Class<O> type;
    protected String context;
    protected Set<String> fieldNames;
    protected ValidationAwareSupport validationSupport;
    protected DelegatingValidatorContext validationContext;
    protected ActionValidatorManager validator;
    protected ValueStack vs;

    protected XWork2ScopeValidator(Class<O> type, String context, Set<String> fieldNames, ValueStack vs) {
        this.type = type;
        this.context = context;
        this.fieldNames = fieldNames;
        this.validationSupport = new ValidationAwareSupport();
        this.validationContext = new DelegatingValidatorContext((ValidationAware)this.validationSupport, null, (LocaleProvider)new DefaultLocaleProvider());
        if (vs == null) {
            vs = XWork2ValidatorUtil.createValuestack();
            if (log.isDebugEnabled()) {
                log.debug((Object)("create a standalone value stack " + vs));
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("use given value stack " + vs));
        }
        this.vs = vs;
        this.validator = XWork2ValidatorUtil.newValidationManager(vs);
    }

    public Class<O> getType() {
        return this.type;
    }

    public String getContext() {
        return this.context;
    }

    public Set<String> getFieldNames() {
        return this.fieldNames;
    }

    public ActionValidatorManager getValidator() {
        return this.validator;
    }

    public boolean containsField(String fieldName) {
        return this.fieldNames.contains(fieldName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, List<String>> validate(O bean) {
        if (bean == null) {
            throw new NullPointerException("bean parameter can not be null in method validate");
        }
        Map<String, List<String>> result = EMPTY_RESULT;
        if (this.fieldNames.isEmpty()) {
            return result;
        }
        try {
            if (ActionContext.getContext() == null) {
                ActionContext.setContext((ActionContext)new ActionContext(this.vs.getContext()));
            }
            this.validator.validate(bean, this.context, (ValidatorContext)this.validationContext);
            if (log.isTraceEnabled()) {
                log.trace((Object)("Action errors: " + this.validationContext.getActionErrors()));
                log.trace((Object)("Action messages: " + this.validationContext.getActionMessages()));
                log.trace((Object)("Field errors: " + this.validationContext.getFieldErrors()));
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)(this + " : " + this.validationContext.getFieldErrors()));
            }
            if (this.validationContext.hasFieldErrors()) {
                Map messages = this.validationContext.getFieldErrors();
                result = new HashMap<String, List<String>>(messages.size());
                for (Object fieldName : messages.keySet()) {
                    Collection c = (Collection)messages.get(fieldName);
                    ArrayList<String> mm = new ArrayList<String>(c.size());
                    for (Object message : c) {
                        String messageStr = message == null ? "" : message + "";
                        mm.add(messageStr.trim());
                    }
                    result.put(fieldName + "", mm);
                }
            }
        }
        catch (ValidationException eee) {
            if (log.isWarnEnabled()) {
                log.warn((Object)("Error during validation on " + this.type + " for reason : " + eee.getMessage()), (Throwable)eee);
            }
        }
        finally {
            this.validationSupport.clearErrorsAndMessages();
        }
        return result;
    }

    public String toString() {
        return super.toString() + "<beanClass:" + this.type + ", contextName:" + this.context + ">";
    }
}

