/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.validator.xwork2.field;

import com.opensymphony.xwork2.validator.ValidationException;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.nuiton.validator.xwork2.field.NuitonFieldValidatorSupport;

public class FrenchFinessFieldValidator
extends NuitonFieldValidatorSupport {
    protected static final String SIRET_REGEXP = "([0-9]{2}|2A|2B)0([0-9]{6})";
    protected static final Pattern p = Pattern.compile("([0-9]{2}|2A|2B)0([0-9]{6})");

    @Override
    protected void validateWhenNotSkip(Object object) throws ValidationException {
        String finess;
        String fieldName = this.getFieldName();
        Object value = this.getFieldValue(fieldName, object);
        if (value == null) {
            return;
        }
        if (value.getClass().isArray()) {
            finess = "";
            for (int i = 0; i < Array.getLength(value); ++i) {
                finess = finess + String.valueOf(Array.get(value, i));
            }
        } else if (value instanceof Collection) {
            finess = "";
            for (Object o : (Collection)value) {
                finess = finess + String.valueOf(o);
            }
        } else {
            finess = String.valueOf(value);
        }
        if (StringUtils.isEmpty((CharSequence)finess)) {
            return;
        }
        Matcher m = p.matcher(finess = finess.replaceAll(" ", ""));
        if (!m.matches()) {
            this.addFieldError(fieldName, object);
        }
    }

    public String getValidatorType() {
        return "frenchFiness";
    }
}

