/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.runtime.swing.table.filter;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.swing.DefaultRowSorter;
import javax.swing.JTable;
import javax.swing.RowFilter;
import javax.swing.RowSorter;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import org.nuiton.jaxx.runtime.swing.table.filter.AbstractTableFilter;
import org.nuiton.jaxx.runtime.swing.table.filter.TableFilter;

public class JTableFilter
extends AbstractTableFilter<JTable> {
    private static final long serialVersionUID = 1L;
    private final TableRowFilter filter = new TableRowFilter();

    public JTableFilter(JTable table) {
        super(table);
    }

    @Override
    protected boolean execute(int col, Collection<Object> items) {
        RowSorter<? extends TableModel> rs = ((JTable)this.getTable()).getRowSorter();
        if (!(rs instanceof DefaultRowSorter)) {
            return false;
        }
        DefaultRowSorter drs = (DefaultRowSorter)rs;
        RowFilter<Object, Object> prevFilter = drs.getRowFilter();
        if (!(prevFilter instanceof TableRowFilter)) {
            this.filter.setParentFilter(prevFilter);
        }
        drs.setRowFilter(this.filter);
        return true;
    }

    @Override
    public void modelChanged(TableModel model) {
        ((JTable)this.getTable()).setRowSorter(new TableRowSorter<TableModel>(model));
    }

    @Override
    public Set<Object> distinctValuesForColumn(int i) {
        return null;
    }

    @Override
    public String toString(Object o) {
        return null;
    }

    @Override
    public void clear() {
        super.clear();
        List<Object> items = Collections.emptyList();
        for (int column = 0; column < ((JTable)this.getTable()).getModel().getColumnCount(); ++column) {
            this.execute(column, items);
        }
    }

    class TableRowFilter
    extends RowFilter<Object, Object>
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private RowFilter<Object, Object> parentFilter;

        TableRowFilter() {
        }

        public RowFilter<Object, Object> getParentFilter() {
            return this.parentFilter;
        }

        public void setParentFilter(RowFilter<Object, Object> parentFilter) {
            this.parentFilter = parentFilter == null || parentFilter == this ? null : parentFilter;
        }

        @Override
        public boolean include(final RowFilter.Entry<?, ?> entry) {
            if (this.parentFilter != null && !this.parentFilter.include(entry)) {
                return false;
            }
            return JTableFilter.this.includeRow(new TableFilter.Row(){

                @Override
                public Object getValue(int column) {
                    return entry.getValue(column);
                }

                @Override
                public int getValueCount() {
                    return entry.getValueCount();
                }
            });
        }
    }
}

