/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.widgets.error;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import org.nuiton.jaxx.runtime.JAXXUtil;
import org.nuiton.jaxx.runtime.swing.SwingUtil;
import org.nuiton.jaxx.widgets.error.ErrorDialogUI;

public class ErrorDialogUIHandler {
    protected final ErrorDialogUI ui;

    public ErrorDialogUIHandler(ErrorDialogUI ui) {
        this.ui = ui;
    }

    public static void init(Frame frame) {
        ErrorDialogUIHandler.disposeUI();
        ErrorDialogUI.instance = new ErrorDialogUI(frame);
        ErrorDialogUI.instance.setModalityType(Dialog.ModalityType.TOOLKIT_MODAL);
    }

    public static void showError(Exception e) {
        ErrorDialogUI instance = ErrorDialogUI.instance;
        if (instance == null) {
            instance = new ErrorDialogUI();
        }
        instance.getErrorMessage().setText(e.getMessage());
        StringWriter w = new StringWriter();
        try (PrintWriter writer = new PrintWriter(w);){
            e.printStackTrace(writer);
            instance.getErrorStack().setText(w.toString());
        }
        instance.getErrorStack().setCaretPosition(0);
        instance.pack();
        SwingUtil.center((Component)instance.getContextValue(JFrame.class, "parent"), (Component)instance);
        instance.setVisible(true);
    }

    public static void disposeUI() {
        ErrorDialogUI instance = ErrorDialogUI.instance;
        if (instance != null) {
            JAXXUtil.destroy((Component)instance);
        }
        ErrorDialogUI.instance = null;
    }

    void $afterCompleteSetup() {
        JRootPane rootPane = this.ui.getRootPane();
        JButton close = this.ui.close;
        rootPane.setDefaultButton(close);
        InputMap inputMap = rootPane.getInputMap(2);
        inputMap.put(KeyStroke.getKeyStroke("ESCAPE"), "close");
        rootPane.getActionMap().put("close", close.getAction());
    }
}

