package org.nuiton.jaxx.widgets.config;

/*-
 * #%L
 * JAXX :: Widgets Config
 * %%
 * Copyright (C) 2008 - 2016 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Container;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.ListSelectionModel;
import javax.swing.ScrollPaneConstants;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTable;
import org.nuiton.jaxx.runtime.JAXXBinding;
import org.nuiton.jaxx.runtime.JAXXContext;
import org.nuiton.jaxx.runtime.JAXXObject;
import org.nuiton.jaxx.runtime.JAXXObjectDescriptor;
import org.nuiton.jaxx.runtime.JAXXUtil;
import org.nuiton.jaxx.runtime.SwingUtil;
import org.nuiton.jaxx.runtime.binding.DefaultJAXXBinding;
import org.nuiton.jaxx.runtime.context.DefaultJAXXContext;
import org.nuiton.jaxx.widgets.config.model.CategoryModel;
import org.nuiton.jaxx.widgets.config.model.ConfigTableModel;
import org.nuiton.jaxx.widgets.config.model.ConfigUIModel;
import static org.nuiton.i18n.I18n.t;

public class ConfigCategoryUI extends JPanel implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_CATEGORY_MODEL = "categoryModel";
    public static final String PROPERTY_SELECTION_MODEL = "selectionModel";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_RESET_ENABLED = "reset.enabled";
    public static final String BINDING_SAVE_ENABLED = "save.enabled";
    public static final String BINDING_TABLE_PANE_COLUMN_HEADER_VIEW = "tablePane.columnHeaderView";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVWT1PbRhRfHAwBQkKhTdrJNHVIGsw0yECbzrTJtDUOGcwIzNgmSeFAF2uxl6y1irSKTTzJoYfe+gV66LWXTr5DJr10ppdc8x06k4/QtytZsrCMTeEg5NV7v/29P/t7++e/KOnY6Da3q5rpUsFN7RA3m5rtmoLWibaeffy4sH9IKuI+cSo2tQS3kfc3lECJXTRhBOuOQNquDkgZDykjkTI+UibH6xY3idkBdFdH4444YsSpESIESvd0rjhOphRY3m1aru3vFcs6bq9/fll6N0Tu/5ZAqGkB/RkI+4tTAIRRD+soQQ2BpvVD/AxnGDarQM6mZhUCmpRrOYYdZxPXyVP0Eo3qaMTCNoAJtPC/0qPgFFTTEuj8zfUtbBK2KFDmOP8GNapEOFqFmwe0CmHIfzksSJXbR9t5y1IwIwKN1rBpMGIL9PUpMdY8xxAqWecGYQIt9wFSZj7cdn5D/gpBJiv+BhunAut0CsHGBd5nxEe6cwpa5cAvBLvoEAbtT7npA16TFW5qTgMKrunUEaWIQeg53Y5Jx/uEqZrBYqe3V0hpPtadCeV13EEtSsurgcOYilYiCXQlYlyq2JypjaNbJJWHQFdlag7hAD8R3PKcmtr6Y5UFaXo98Gj33JL8/WkU7VJbASAD7b1uyMdcYDLRYSLQRxGSZdIUWZtgaTrfteFysGGIlrSJI+ViJoKz4goosTTRAsthBz9TfJaj616DbHHLhfN0OVoRubhBTLezN7l1lCOMPcTMJcf5S9u8IHVpfCfwmVIcCypi5SbXv/VtbHSrl/CA0Gmh0IWaM7QLYbuwLNCN3horZbIIVp5A3ugtkHIbZfjzq5f2H43379qqOA3kUv28OgYASJRlcwuEhEpulzxJdAVlmQ1s3d1FY97xUdNh7mTmJd8S2AOLDySSJpG0NezUAC05+u71m8s/vT2HEg/QOOPYeIClfR6OQA3yXePMaFrf/6DIXWich+eUpAn13seVJ1WbuybI9mQrxxm3tUdr+fLqiyYkau7kRAW8XhXe//37r5+/bidrCGjeHMQzTFhyB41Qk1GTqCHiz4fYoTFhOcQ1eCj+ceMAxcqM5Tfvino+iEvJVIUzt26uEWwQ+yElDYF2WiZppDyJSYv0rC+QHWd3dv52qiTbfluWBVQUdBybuErsrBLAPLikZ6l5wO06bjssLc5DliWRdZUz+aajbt3oRzoJqkAM6mtX8gAzOGFo7AAkZcGhz+E9sbSoFiquEzUaFiAyAqVaYVQm17jaWvMalBiz8y/A0uYN6NShL+MYd8pYP7bnYlP8cUvRl6lTKut9S8udrzyTh6iCmafaK9je4oxWjmDKt0IhhznlCGzC+Hq4Wiznc1l9r5QrFnR9JVvcy+qPsj+WAOuTGrfpc0hMDNpiLNpaoZjfKWyWI3ibq7BJbO3CmTNA1bom6FQrugKML2JX8CKRdZRLAl1v+YNIy26XC3vF1VJ+ZxUi1PdyBX17Y1OGOQPFCoZvljHeIEZY9BkJmYPJIkgR7Lgt5HVnWNhSw8fAdY3Qag3aIrF8Jy5Gb0r2i28Y1AUHzS/QBa+/FvwZ5XfejN91nqXmf5wQnLMytcrK5kqMjSag29AoMSUVQ2YFOidy60nPa9SBN3pAiZGOP2newDxtJBN+JHKGBoFMR0l636JxXO42OR5Gtl8YqVu3UrEmMEtprzDVtB/gXE7ucxtO3RampuhsmBFu4aduRFtgyET0Jm7bC8qiDCmAUzaA8iaZd7H70M+Tpwhetpy4DTpuKwNEF1tDeYMJang1WqBjt5toMT87wVZWNY5v9L50WsoznQdogft3Rp/6tZgz0nHJOs5+9mTzXgF0Xd4GqOoIw0ccrqDo4j0Deia1T00DBuV3XfhD8jneF1Euv5GPv+IR0mdGyAwQ1TCteHfqHhhLA7F4ewLCV2dG+ObMCPcA4T88ECFcCREAAA==";
    private static final Log log = LogFactory.getLog(ConfigCategoryUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JLabel categoryLabel;
    protected JPanel categoryLabelPanel;
    protected CategoryModel categoryModel;
    protected JMenuItem copyCellValue;
    protected JTextArea description;
    protected JScrollPane descriptionPane;
    protected ConfigCategoryUIHandler handler;
    protected ConfigUIModel model;
    protected JButton reset;
    protected JMenuItem resetOptionValue;
    protected JButton save;
    protected ListSelectionModel selectionModel;
    protected JXTable table;
    protected ConfigTableModel tableModel;
    protected JScrollPane tablePane;
    protected JPopupMenu tablePopup;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private ConfigCategoryUI $JPanel0;
    private JPanel $JPanel1;
    private JPanel $JPanel2;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    void $afterCompleteSetup() {
      getHandler().init();
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public ConfigCategoryUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public ConfigCategoryUI(JAXXContext parentContext, LayoutManager param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ConfigCategoryUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public ConfigCategoryUI(JAXXContext parentContext, LayoutManager param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ConfigCategoryUI() {
        $initialize();
    }

    public ConfigCategoryUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ConfigCategoryUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public ConfigCategoryUI(JAXXContext parentContext, boolean param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if ($bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if ($bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if ($bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__copyCellValue(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.copyCellValue();
    }

    public void doActionPerformed__on__reset(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        model.reset();
    }

    public void doActionPerformed__on__resetOptionValue(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.resetOptionValue();
    }

    public void doActionPerformed__on__save(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        model.saveModified();
    }

    public void doMousePressed__on__table(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.openTablePopupMenu(event, tablePopup);
    }

    public void doTableChanged__on__tableModel(TableModelEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.updateDescriptionText();
    }

    public void doValueChanged__on__selectionModel(ListSelectionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        if (!event.getValueIsAdjusting()) {handler.updateDescriptionText(); }
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JLabel getCategoryLabel() {
        return categoryLabel;
    }

    public JPanel getCategoryLabelPanel() {
        return categoryLabelPanel;
    }

    public CategoryModel getCategoryModel() {
        return categoryModel;
    }

    public JMenuItem getCopyCellValue() {
        return copyCellValue;
    }

    public JTextArea getDescription() {
        return description;
    }

    public JScrollPane getDescriptionPane() {
        return descriptionPane;
    }

    public ConfigCategoryUIHandler getHandler() {
        return handler;
    }

    public ConfigUIModel getModel() {
        return model;
    }

    public JButton getReset() {
        return reset;
    }

    public JMenuItem getResetOptionValue() {
        return resetOptionValue;
    }

    public JButton getSave() {
        return save;
    }

    public ListSelectionModel getSelectionModel() {
        return selectionModel;
    }

    public JXTable getTable() {
        return table;
    }

    public ConfigTableModel getTableModel() {
        return tableModel;
    }

    public JScrollPane getTablePane() {
        return tablePane;
    }

    public JPopupMenu getTablePopup() {
        return tablePopup;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setCategoryModel(CategoryModel categoryModel) {
        CategoryModel oldValue = this.categoryModel;
        this.categoryModel = categoryModel;
        firePropertyChange(PROPERTY_CATEGORY_MODEL, oldValue, categoryModel);
    }

    public void setSelectionModel(ListSelectionModel selectionModel) {
        ListSelectionModel oldValue = this.selectionModel;
        this.selectionModel = selectionModel;
        firePropertyChange(PROPERTY_SELECTION_MODEL, oldValue, selectionModel);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JPanel get$JPanel1() {
        return $JPanel1;
    }

    protected JPanel get$JPanel2() {
        return $JPanel2;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToCategoryLabelPanel() {
        categoryLabelPanel.add(categoryLabel);
    }

    protected void addChildrenToDescriptionPane() {
        descriptionPane.getViewport().add(description);
    }

    protected void addChildrenToTablePane() {
        tablePane.getViewport().add(table);
    }

    protected void addChildrenToTablePopup() {
        tablePopup.add(copyCellValue);
        tablePopup.add(resetOptionValue);
    }

    protected void createCategoryLabel() {
        $objectMap.put("categoryLabel", categoryLabel = new JLabel());
        
        categoryLabel.setName("categoryLabel");
    }

    protected void createCategoryLabelPanel() {
        $objectMap.put("categoryLabelPanel", categoryLabelPanel = new JPanel());
        
        categoryLabelPanel.setName("categoryLabelPanel");
    }

    protected void createCategoryModel() {
        $objectMap.put("categoryModel", categoryModel = getContextValue(CategoryModel.class));
    }

    protected void createCopyCellValue() {
        $objectMap.put("copyCellValue", copyCellValue = new JMenuItem());
        
        copyCellValue.setName("copyCellValue");
        copyCellValue.setText(t("config.action.copyCellValue"));
        copyCellValue.setToolTipText(t("config.action.copyCellValue.tip"));
        copyCellValue.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__copyCellValue"));
    }

    protected void createDescription() {
        $objectMap.put("description", description = new JTextArea());
        
        description.setName("description");
        description.setColumns(15);
        description.setLineWrap(true);
        description.setWrapStyleWord(true);
        description.setEditable(false);
        if (description.getFont() != null) {
            description.setFont(description.getFont().deriveFont((float) 10));
        }
        description.setFocusable(false);
        description.setRows(3);
    }

    protected void createDescriptionPane() {
        $objectMap.put("descriptionPane", descriptionPane = new JScrollPane());
        
        descriptionPane.setName("descriptionPane");
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = new ConfigCategoryUIHandler(this));
    }

    protected void createModel() {
        $objectMap.put("model", model = getContextValue(ConfigUIModel.class));
    }

    protected void createReset() {
        $objectMap.put("reset", reset = new JButton());
        
        reset.setName("reset");
        reset.setText(t("config.action.reset"));
        reset.setToolTipText(t("config.action.reset.tip"));
        reset.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__reset"));
    }

    protected void createResetOptionValue() {
        $objectMap.put("resetOptionValue", resetOptionValue = new JMenuItem());
        
        resetOptionValue.setName("resetOptionValue");
        resetOptionValue.setText(t("config.action.resetOptionValue"));
        resetOptionValue.setToolTipText(t("config.action.resetOptionValue.tip"));
        resetOptionValue.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__resetOptionValue"));
    }

    protected void createSave() {
        $objectMap.put("save", save = new JButton());
        
        save.setName("save");
        save.setText(t("config.action.save"));
        save.setToolTipText(t("config.action.save.tip"));
        save.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__save"));
    }

    protected void createSelectionModel() {
        $objectMap.put("selectionModel", selectionModel = new DefaultListSelectionModel());
        
        selectionModel.addListSelectionListener(JAXXUtil.getEventListener(ListSelectionListener.class, "valueChanged", this, "doValueChanged__on__selectionModel"));
    }

    protected void createTable() {
        $objectMap.put("table", table = new JXTable(tableModel));
        
        table.setName("table");
        table.setRowSelectionAllowed(false);
        table.setAutoCreateRowSorter(true);
        table.setRowHeight(25);
        table.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mousePressed", this, "doMousePressed__on__table"));
    }

    protected void createTableModel() {
        $objectMap.put("tableModel", tableModel = new ConfigTableModel(categoryModel));
        
        tableModel.addTableModelListener(JAXXUtil.getEventListener(TableModelListener.class, "tableChanged", this, "doTableChanged__on__tableModel"));
    }

    protected void createTablePane() {
        $objectMap.put("tablePane", tablePane = new JScrollPane());
        
        tablePane.setName("tablePane");
    }

    protected void createTablePopup() {
        $objectMap.put("tablePopup", tablePopup = new JPopupMenu());
        
        tablePopup.setName("tablePopup");
        tablePopup.setLabel("config.table.actions");
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected void $initialize() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $JPanel0 = this;
        $initialize_01_createComponents();
        $initialize_02_registerDataBindings();
        $initialize_03_finalizeCreateComponents();
        $initialize_04_applyDataBindings();
        $initialize_05_setProperties();
        $initialize_06_finalizeInitialize();
    }

    protected void $initialize_01_createComponents() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$JPanel0", $JPanel0);
        createHandler();
        createModel();
        createCategoryModel();
        createTableModel();
        createSelectionModel();
        createCategoryLabelPanel();
        createCategoryLabel();
        createTablePane();
        createTable();
        // inline creation of $JPanel1
        $objectMap.put("$JPanel1", $JPanel1 = new JPanel());
        
        $JPanel1.setName("$JPanel1");
        $JPanel1.setLayout(new BorderLayout());
        createDescriptionPane();
        createDescription();
        // inline creation of $JPanel2
        $objectMap.put("$JPanel2", $JPanel2 = new JPanel());
        
        $JPanel2.setName("$JPanel2");
        $JPanel2.setLayout(new GridLayout(1,0));
        createReset();
        createSave();
        createTablePopup();
        createCopyCellValue();
        createResetOptionValue();
        // inline creation of $JPanel0
        setName("$JPanel0");
        setLayout(new BorderLayout());
    }

    protected void $initialize_02_registerDataBindings() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // register 3 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_TABLE_PANE_COLUMN_HEADER_VIEW, true) {
        
            @Override
            public void applyDataBinding() {
                if (table != null) {
                    table.addPropertyChangeListener("tableHeader", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (table != null) {
                    tablePane.setColumnHeaderView(table.getTableHeader());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (table != null) {
                    table.removePropertyChangeListener("tableHeader", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_RESET_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                addPropertyChangeListener("categoryModel", this);
                if (getCategoryModel() != null) {
                    getCategoryModel().addPropertyChangeListener("modified", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getCategoryModel() != null) {
                    reset.setEnabled(getCategoryModel().isModified());
                }
            }
        
            @Override
            public void removeDataBinding() {
                removePropertyChangeListener("categoryModel", this);
                if (getCategoryModel() != null) {
                    getCategoryModel().removePropertyChangeListener("modified", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SAVE_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                addPropertyChangeListener("categoryModel", this);
                if (getCategoryModel() != null) {
                    getCategoryModel().addPropertyChangeListener("modified", this);
                }
                if (getCategoryModel() != null) {
                    getCategoryModel().addPropertyChangeListener("valid", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getCategoryModel() != null) {
                    save.setEnabled(getCategoryModel().isModified() && getCategoryModel().isValid());
                }
            }
        
            @Override
            public void removeDataBinding() {
                removePropertyChangeListener("categoryModel", this);
                if (getCategoryModel() != null) {
                    getCategoryModel().removePropertyChangeListener("modified", this);
                }
                if (getCategoryModel() != null) {
                    getCategoryModel().removePropertyChangeListener("valid", this);
                }
            }
        });
    }

    protected void $initialize_03_finalizeCreateComponents() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // inline complete setup of $JPanel0
        add(categoryLabelPanel, BorderLayout.NORTH);
        add(tablePane, BorderLayout.CENTER);
        add($JPanel1, BorderLayout.SOUTH);
        addChildrenToCategoryLabelPanel();
        addChildrenToTablePane();
        // inline complete setup of $JPanel1
        $JPanel1.add(descriptionPane, BorderLayout.CENTER);
        $JPanel1.add($JPanel2, BorderLayout.SOUTH);
        addChildrenToDescriptionPane();
        // inline complete setup of $JPanel2
        $JPanel2.add(reset);
        $JPanel2.add(save);
        addChildrenToTablePopup();
    }

    protected void $initialize_04_applyDataBindings() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        
        // apply 3 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
    }

    protected void $initialize_05_setProperties() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        
        // apply 14 property setters
        categoryLabelPanel.setBackground(Color.WHITE);
        tablePane.setVerticalScrollBarPolicy(ScrollPaneConstants.VERTICAL_SCROLLBAR_ALWAYS);
        tablePane.setHorizontalScrollBarPolicy(ScrollPaneConstants.HORIZONTAL_SCROLLBAR_NEVER);
        table.setSelectionModel(selectionModel);
        table.setAutoResizeMode(JXTable.AUTO_RESIZE_ALL_COLUMNS);
        descriptionPane.setColumnHeaderView(new JLabel(t("config.description"), SwingUtil.getUIManagerActionIcon("information"), 10));
        SwingUtil.setText(description, t("config.no.option.selected"));
        
        reset.setIcon(SwingUtil.getUIManagerActionIcon("config-reset"));
        save.setIcon(SwingUtil.getUIManagerActionIcon("config-save"));
        copyCellValue.setIcon(SwingUtil.getUIManagerActionIcon("config-copy"));
        resetOptionValue.setIcon(SwingUtil.getUIManagerActionIcon("config-reset-option"));
    }

    protected void $initialize_06_finalizeInitialize() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
    }

}