/*
 * *##% 
 * JAXX Action
 * Copyright (C) 2008 - 2009 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * ##%*
 */
/**
 * ##% Copyright (C) 2008 Code Lutin, Tony Chemit
 * This program is free software; you
 * can redistribute it and/or modify it under the terms of the GNU General
 * Public License as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version. This program is
 * distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE. See the GNU General Public License for more details. You
 * should have received a copy of the GNU General Public License along with this
 * program; if not, write to the Free Software Foundation, Inc., 59 Temple Place
 * - Suite 330, Boston, MA 02111-1307, USA. 
 * ##%
 */
package org.nuiton.jaxx.util;

import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

/**
 * A windowListenr for ui managed by {@link org.nuiton.jaxx.util.UIFactory}.
 * <p/>
 * To be used when all ui from factory are closed, via {@link #allWindowsClosed(java.awt.event.WindowEvent)} method.
 *
 * @author chemit
 */
public abstract class FactoryWindowListener extends WindowAdapter {

    /**
     * method to be invoked when all ui registred in factory are really disposed.
     *
     * @param e event
     */
    public abstract void allWindowsClosed(WindowEvent e);

    /** underlying factory of ui */
    private UIFactory factory;

    /** flag to make sure {@link #allWindowsClosed(java.awt.event.WindowEvent)} is called only once. */
    private boolean wasClosed;

    @Override
    public void windowClosed(WindowEvent e) {
        if (UIFactory.log.isDebugEnabled()) {
            UIFactory.log.debug(this + " : " + e);
        }
        if (e.getWindow().isVisible()) {
            // only deal with real closed and none visible windows...
            return;
        }
        for (DialogUIDef<?,?,?> def : factory.getDefs()) {
            DialogUI<?> ui = def.uiInstance;
            if (ui != null && ui.isVisible()) {
                // at least one ui visible, do not close all
                return;
            }
        }

        if (wasClosed) {
            // make sure to process only once
            return;
        }
        if (UIFactory.log.isInfoEnabled()) {
            UIFactory.log.info("closing factory listener " + this);
        }

        synchronized (this) {
            try {
                allWindowsClosed(e);
            } finally {
                wasClosed = true;
                factory.removeFactoryWindowListener(this);
            }
        }
    }

    protected UIFactory getFactory() {
        return factory;
    }

    protected void setFactory(UIFactory factory) {
        this.factory = factory;
    }
}
