/*
 * #%L
 * JAXX :: Runtime
 * 
 * $Id: JAXXObjectDescriptor.java 2225 2011-02-19 20:15:00Z tchemit $
 * $HeadURL: https://nuiton.org/svn/jaxx/tags/jaxx-2.8/jaxx-runtime/src/main/java/jaxx/runtime/JAXXObjectDescriptor.java $
 * %%
 * Copyright (C) 2008 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package jaxx.runtime;

import jaxx.runtime.css.Stylesheet;

import java.io.Serializable;

public class JAXXObjectDescriptor implements Serializable {
    private ComponentDescriptor[] descriptors;

    private Stylesheet stylesheet;

    private static final long serialVersionUID = 1L;


    public JAXXObjectDescriptor(ComponentDescriptor[] descriptors,
                                Stylesheet stylesheet) {
        this.descriptors = descriptors;
        this.stylesheet = stylesheet;
    }


    public ComponentDescriptor[] getComponentDescriptors() {
        return descriptors;
    }


    public Stylesheet getStylesheet() {
        return stylesheet;
    }

    @Override
    public String toString() {
        StringBuilder buffer = new StringBuilder();
        for (ComponentDescriptor descriptor : descriptors) {
            buffer.append("\n").append(descriptor);
        }
        buffer.append("\n").append(stylesheet);
        return buffer.toString();
    }
}