/*
 * Decompiled with CFR 0.152.
 */
package jaxx.runtime.swing.model;

import com.google.common.collect.Lists;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.DefaultListSelectionModel;
import javax.swing.event.EventListenerList;
import javax.swing.event.ListDataListener;
import jaxx.runtime.swing.model.GenericListEvent;
import jaxx.runtime.swing.model.GenericListListener;

public class GenericListModel<B>
extends DefaultListSelectionModel
implements ComboBoxModel {
    protected EventListenerList listenerList = new EventListenerList();
    protected final PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    public static final String PROPERTY_SELECTED_VALUE = "selectedValues";
    protected DefaultListModel delegate = new DefaultListModel();
    protected List<B> selectedValues = Lists.newArrayList();

    public GenericListModel() {
    }

    public GenericListModel(Collection<B> values) {
        this();
        this.setElements(values);
    }

    public void setElements(Collection<B> values) {
        Collection<B> oldValues = this.getElements();
        Collection<B> oldSelectedValues = this.getSelectedValues();
        this.clearSelection();
        this.fireSelectionRemoved(oldSelectedValues);
        this.clearElements();
        this.fireValuesRemoved(oldValues);
        for (B value : values) {
            this.delegate.addElement(value);
        }
        this.fireSelectionAdded(values);
    }

    public void clearElements() {
        Collection<B> elements = this.getElements();
        this.delegate.clear();
        this.fireValuesRemoved(elements);
    }

    public Collection<B> getElements() {
        int size = this.delegate.getSize();
        ArrayList result = Lists.newArrayList();
        for (int i = 0; i < size; ++i) {
            result.add(this.delegate.get(i));
        }
        return result;
    }

    public void addElement(int index, B valueToAdd) {
        this.delegate.add(index, valueToAdd);
        this.fireValuesAdded(Lists.newArrayList((Object[])new Object[]{valueToAdd}));
    }

    public void addElement(B valueToAdd) {
        this.delegate.addElement(valueToAdd);
        this.fireValuesAdded(Lists.newArrayList((Object[])new Object[]{valueToAdd}));
    }

    public void addElements(Collection<B> valuesToAdd) {
        for (B value : valuesToAdd) {
            this.delegate.addElement(value);
        }
        this.fireValuesAdded(valuesToAdd);
    }

    public B getSelectedValue() {
        return this.selectedValues.get(0);
    }

    public Collection<B> getSelectedValues() {
        return Lists.newArrayList(this.selectedValues);
    }

    public void removeElements(Collection<B> values) {
        for (B value : values) {
            this.delegate.removeElement(value);
        }
        this.unSelectItems(values);
        this.fireValuesRemoved(values);
    }

    protected void unSelectItems(Collection<B> values) {
        ArrayList oldValue = Lists.newArrayList(this.selectedValues);
        for (B value : values) {
            int index = this.selectedValues.indexOf(value);
            this.removeSelectionIntervalWithoutFire(index, index);
        }
        this.fireSelectionRemoved(values);
        this.firePropertyChange(PROPERTY_SELECTED_VALUE, oldValue, this.selectedValues);
    }

    protected void unSelectItem(B value) {
        ArrayList oldValue = Lists.newArrayList(this.selectedValues);
        int index = this.selectedValues.indexOf(value);
        this.removeSelectionIntervalWithoutFire(index, index);
        this.fireSelectionRemoved(Lists.newArrayList((Object[])new Object[]{value}));
        this.firePropertyChange(PROPERTY_SELECTED_VALUE, oldValue, this.selectedValues);
    }

    public void addSelectedItem(B toSelect) {
        ArrayList oldValue = Lists.newArrayList(this.selectedValues);
        this.selectedValues.add(toSelect);
        int index = this.selectedValues.indexOf(toSelect);
        super.addSelectionInterval(index, index);
        this.fireSelectionAdded(Lists.newArrayList((Object[])new Object[]{toSelect}));
        this.firePropertyChange(PROPERTY_SELECTED_VALUE, oldValue, this.selectedValues);
    }

    public boolean hasSelectedIndex() {
        return !this.selectedValues.isEmpty();
    }

    @Override
    public void addSelectionInterval(int index0, int index1) {
        ArrayList oldValue = Lists.newArrayList(this.selectedValues);
        this.addSelectionIntervalWithFire(index0, index1);
        super.addSelectionInterval(index0, index1);
        ArrayList newValue = Lists.newArrayList(this.selectedValues);
        newValue.removeAll(oldValue);
        this.fireSelectionAdded(newValue);
        this.firePropertyChange(PROPERTY_SELECTED_VALUE, oldValue, this.selectedValues);
    }

    @Override
    public void setSelectionInterval(int index0, int index1) {
        ArrayList oldValue = Lists.newArrayList(this.selectedValues);
        this.selectedValues.clear();
        this.addSelectionIntervalWithFire(index0, index1);
        super.setSelectionInterval(index0, index1);
        ArrayList newValue = Lists.newArrayList(this.selectedValues);
        newValue.removeAll(oldValue);
        this.fireSelectionAdded(newValue);
        this.firePropertyChange(PROPERTY_SELECTED_VALUE, oldValue, this.selectedValues);
    }

    @Override
    public void removeSelectionInterval(int index0, int index1) {
        ArrayList oldValue = Lists.newArrayList(this.selectedValues);
        this.removeSelectionIntervalWithoutFire(index0, index1);
        ArrayList newValue = Lists.newArrayList(this.selectedValues);
        newValue.removeAll(oldValue);
        this.fireSelectionRemoved(newValue);
        this.firePropertyChange(PROPERTY_SELECTED_VALUE, oldValue, this.selectedValues);
    }

    protected void removeSelectionIntervalWithoutFire(int index0, int index1) {
        if (index0 > index1) {
            int tmp = index1;
            index1 = index0;
            index0 = tmp;
        }
        for (int i = index0; i <= index1; ++i) {
            if (this.selectedValues.size() <= i || i == -1) continue;
            this.selectedValues.remove(i);
        }
        super.removeSelectionInterval(index0, index1);
    }

    protected void addSelectionIntervalWithFire(int index0, int index1) {
        if (index0 > index1) {
            int tmp = index1;
            index1 = index0;
            index0 = tmp;
        }
        for (int i = index0; i <= index1; ++i) {
            if (this.delegate.size() <= i || i == -1) continue;
            Object value = this.delegate.getElementAt(i);
            this.selectedValues.add(value);
        }
    }

    @Override
    public void clearSelection() {
        ArrayList oldValue = Lists.newArrayList(this.selectedValues);
        this.selectedValues.clear();
        super.clearSelection();
        this.fireSelectionRemoved(oldValue);
        this.firePropertyChange(PROPERTY_SELECTED_VALUE, oldValue, this.selectedValues);
    }

    @Override
    public int getSelectionMode() {
        return 2;
    }

    @Override
    public void setSelectedItem(Object anItem) {
        List<B> oldValue = this.selectedValues;
        this.fireSelectionRemoved(this.selectedValues);
        this.selectedValues = Lists.newArrayList((Object[])new Object[]{anItem});
        this.fireSelectionAdded(this.selectedValues);
        this.firePropertyChange(PROPERTY_SELECTED_VALUE, oldValue, this.selectedValues);
    }

    @Override
    public Object getSelectedItem() {
        if (this.selectedValues.isEmpty()) {
            return null;
        }
        return this.selectedValues.get(0);
    }

    @Override
    public int getSize() {
        return this.delegate.size();
    }

    @Override
    public Object getElementAt(int index) {
        return this.delegate.get(index);
    }

    @Override
    public void addListDataListener(ListDataListener l) {
        this.delegate.addListDataListener(l);
    }

    @Override
    public void removeListDataListener(ListDataListener l) {
        this.delegate.removeListDataListener(l);
    }

    public void addGenericListListener(GenericListListener l) {
        this.listenerList.add(GenericListListener.class, l);
    }

    public void removeGenericListListener(GenericListListener l) {
        this.listenerList.remove(GenericListListener.class, l);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(propertyName, listener);
    }

    protected void fireValuesAdded(Collection<B> values) {
        if (values.isEmpty()) {
            return;
        }
        Object[] listeners = this.listenerList.getListenerList();
        GenericListEvent<B> e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != GenericListListener.class) continue;
            if (e == null) {
                e = new GenericListEvent<B>(this, values);
            }
            ((GenericListListener)listeners[i + 1]).valuesAdded(e);
        }
    }

    protected void fireValuesRemoved(Collection<B> values) {
        if (values.isEmpty()) {
            return;
        }
        Object[] listeners = this.listenerList.getListenerList();
        GenericListEvent<B> e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != GenericListListener.class) continue;
            if (e == null) {
                e = new GenericListEvent<B>(this, values);
            }
            ((GenericListListener)listeners[i + 1]).valuesRemoved(e);
        }
    }

    protected void fireSelectionAdded(Collection<B> selectedValues) {
        if (selectedValues.isEmpty()) {
            return;
        }
        Object[] listeners = this.listenerList.getListenerList();
        GenericListEvent<B> e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != GenericListListener.class) continue;
            if (e == null) {
                e = new GenericListEvent<B>(this, selectedValues);
            }
            ((GenericListListener)listeners[i + 1]).selectionAdded(e);
        }
    }

    protected void fireSelectionRemoved(Collection<B> selectedValues) {
        if (selectedValues.isEmpty()) {
            return;
        }
        Object[] listeners = this.listenerList.getListenerList();
        GenericListEvent<B> e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != GenericListListener.class) continue;
            if (e == null) {
                e = new GenericListEvent<B>(this, selectedValues);
            }
            ((GenericListListener)listeners[i + 1]).selectionAdded(e);
        }
    }

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        this.pcs.firePropertyChange(propertyName, oldValue, newValue);
    }
}

