/*
 * #%L
 * JAXX :: Runtime
 * 
 * $Id: JAXXBinding.java 2225 2011-02-19 20:15:00Z tchemit $
 * $HeadURL: http://svn.nuiton.org/svn/jaxx/tags/jaxx-2.5.25/jaxx-runtime/src/main/java/jaxx/runtime/JAXXBinding.java $
 * %%
 * Copyright (C) 2008 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package jaxx.runtime;

import java.beans.PropertyChangeListener;

/**
 * Created: 5 déc. 2009
 *
 * @author tchemit <chemit@codelutin.com>
 * @version $Revision: 2225 $
 *          <p/>
 *          Mise a jour: $Date: 2011-02-19 21:15:00 +0100 (Sat, 19 Feb 2011) $ par :
 *          $Author: tchemit $
 */
public interface JAXXBinding extends PropertyChangeListener {
    /** @return the unique id of a binding */
    String getId();

    /** @return the {@link JAXXObject} which owns the binding */
    JAXXObject getSource();

    /**
     * This state is not used actually, but will be usefull later...
     *
     * @return {@code true} if binding was registred as a default binding, {@code false} otherwise
     */
    boolean isDefaultBinding();

    /** Apply the binding without processing it (say just install listeners). */
    void applyDataBinding();

    /** Processes the binding. */
    void processDataBinding();

    /** Remove the binding. */
    void removeDataBinding();
}
