/*
 * #%L
 * JAXX :: Runtime
 * 
 * $Id: NavigationNode.java 1986 2010-06-23 08:58:14Z tchemit $
 * $HeadURL: http://svn.nuiton.org/svn/jaxx/tags/jaxx-2.1/jaxx-runtime/src/main/java/jaxx/runtime/swing/navigation/NavigationNode.java $
 * %%
 * Copyright (C) 2008 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package jaxx.runtime.swing.navigation;

import jaxx.runtime.JAXXAction;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.context.JAXXContextEntryDef;

import java.io.Serializable;
import java.util.Enumeration;

/**
 * Contract of a navigation node.
 *
 * @author tchemit <chemit@codelutin.com>
 * @param <E> type of the node
 * @since 2.0.1
 * @deprecated since 2.1, prefer use the simplify api {@code jaxx.runtime.swing.tree}.
 */
@Deprecated
public interface NavigationNode<E extends NavigationNode<E>> extends Cloneable, Serializable {

    NavigationNodeRenderer getRenderer();

    String getPathSeparator();

    String getNodePath();

    Class<? extends JAXXObject> getUIClass();

    Class<? extends JAXXAction> getUIHandlerClass();

    JAXXContextEntryDef<?> getJaxxContextEntryDef();

    String getJaxxContextEntryPath();

    Class<?> getInternalClass();

    String getFullPath();

    E getChildAt(int index);

    E getParent();

    E getChild(String path);

    Object getBean();

    Object getBean(JAXXContext context);

    int getChildCount();

    int getIndex(E node);

    boolean getAllowsChildren();

    boolean isLeaf();

    Enumeration<? extends E> children();

    boolean isRoot();

    Object getUserObject();

    E[] getPathToRoot(E aNode, int depth);

    E[] getPath();

    void setRenderer(NavigationNodeRenderer renderer);

    void setNodePath(String navigationPath);

    void setUIClass(Class<? extends JAXXObject> uIClass);

    void setInternalClass(Class<?> internalClass);

    void setUIHandlerClass(Class<? extends JAXXAction> uIHandlerClass);

    void setJaxxContextEntryDef(JAXXContextEntryDef<?> jaxxContextEntryDef);

    void setJaxxContextEntryPath(String jaxxContextEntryPath);

    void setParent(E newParent);

    void setBean(Object bean);

    void setUserObject(Object object);

    void reload(JAXXContext context);

    void add(E node);

    void insert(E child, int index);

    void remove(int index);

    void remove(E node);

    void removeFromParent();

}
