/*
 * #%L
 * JAXX :: Runtime
 * 
 * $Id: HBoxBeanInfo.java 1847 2010-04-16 12:27:48Z tchemit $
 * $HeadURL: http://svn.nuiton.org/svn/jaxx/tags/jaxx-2.1/jaxx-runtime/src/main/java/jaxx/runtime/swing/HBoxBeanInfo.java $
 * %%
 * Copyright (C) 2008 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package jaxx.runtime.swing;

import javax.swing.JPanel;
import javax.swing.SwingConstants;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.beans.SimpleBeanInfo;

public class HBoxBeanInfo extends SimpleBeanInfo {

    @Override
    public BeanInfo[] getAdditionalBeanInfo() {
        try {
            return new BeanInfo[]{Introspector.getBeanInfo(JPanel.class)};
        } catch (IntrospectionException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public PropertyDescriptor[] getPropertyDescriptors() {
        try {
            PropertyDescriptor spacing = new PropertyDescriptor("spacing", HBox.class);
            spacing.setBound(true);

            PropertyDescriptor margin = new PropertyDescriptor("margin", HBox.class);
            margin.setBound(true);

            PropertyDescriptor horizontalAlignment = new PropertyDescriptor("horizontalAlignment", HBox.class);
            horizontalAlignment.setBound(true);
            horizontalAlignment.setValue("enumerationValues", new Object[]{
                        "left", SwingConstants.LEFT, "SwingConstants.LEFT",
                        "center", SwingConstants.CENTER, "SwingConstants.CENTER",
                        "right", SwingConstants.RIGHT, "SwingConstants.RIGHT"
                    });

            PropertyDescriptor verticalAlignment = new PropertyDescriptor("verticalAlignment", HBox.class);
            verticalAlignment.setBound(true);
            verticalAlignment.setValue("enumerationValues", new Object[]{
                        "top", SwingConstants.TOP, "SwingConstants.TOP",
                        "middle", SwingConstants.CENTER, "SwingConstants.CENTER",
                        "bottom", SwingConstants.BOTTOM, "SwingConstants.BOTTOM"
                    });

            return new PropertyDescriptor[]{spacing, margin, horizontalAlignment, verticalAlignment};
        } catch (IntrospectionException e) {
            throw new RuntimeException(e);
        }
    }
}
