package jaxx.demo.component.jaxx.editor.gis;

import java.awt.BorderLayout;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jaxx.demo.DemoPanel;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.swing.JAXXButtonGroup;
import jaxx.runtime.swing.Table;
import jaxx.runtime.swing.editor.NumberEditor;
import jaxx.runtime.swing.editor.gis.DmdCoordinate;
import jaxx.runtime.swing.editor.gis.DmdCoordinateEditor;
import jaxx.runtime.swing.editor.gis.DmsCoordinate;
import jaxx.runtime.swing.editor.gis.DmsCoordinateEditor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static org.nuiton.i18n.I18n.t;

public class CoordinateDemo extends DemoPanel {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_LATITUDE_DD = "latitudeDd";
    public static final String PROPERTY_LONGITUDE_DD = "longitudeDd";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_LATITUDE_DD_EDITOR_SHOW_RESET = "latitudeDdEditor.showReset";
    public static final String BINDING_LATITUDE_DMD_EDITOR_SHOW_RESET = "latitudeDmdEditor.showReset";
    public static final String BINDING_LATITUDE_DMS_EDITOR_SHOW_RESET = "latitudeDmsEditor.showReset";
    public static final String BINDING_LONGITUDE_DD_EDITOR_SHOW_RESET = "longitudeDdEditor.showReset";
    public static final String BINDING_LONGITUDE_DMD_EDITOR_SHOW_RESET = "longitudeDmdEditor.showReset";
    public static final String BINDING_LONGITUDE_DMS_EDITOR_SHOW_RESET = "longitudeDmsEditor.showReset";
    public static final String BINDING_RESULT_LATITUDE_TEXT = "resultLatitude.text";
    public static final String BINDING_RESULT_LONGITUDE_TEXT = "resultLongitude.text";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAM1YT28bRRSfOLHzr3GalJYgQpqkoXJUaZOCAIkECIlJS+UkVZxKEbl07BnsDevdZXe2cWQV8RH4CHDngsSNE+LAmQMXxFdAiAPXijezu7O79jhex0FqD1tr3nu/+b037817k+//QlnXQUunuNnUHM9keoNqjz4+Pj6onNIqK1K36ug2sxzk/xvKoMwJmiRy3WXozkmJm68F5ms7VsO2TGrGrDdKaMJl5wZ165Qyht5IWlRdd60sxRtN23NCVElKhfrtP39nviFff5dBqGkDu2VwZbGXVeTJSAlldMLQLOz0DK8Z2KwBDUc3a8B3iq/tGNh193GDfom+QqMllLOxA2AMLad3WWAI+6bN0ORKkTasx9ikxjpDbwmyBFa0agihiTVKdADRaroLPlgO0U3MKDe1bQGWYyjbsAg1GHqvf5A9bhkhTRqY6cwjtNiA87yXiKB7BvGII4FOBKbEICkwiApjQmIAxDQ/AI0firZrWJhFatcMy6yFfPnajFpG+NorcYpSJkSvRqLRlSNcMSgcyZyCuZBxzXFpkKta5ud6DZKH02wGio/EwXKVBamZ9zVLgWt89Q7/LEmNmdDtct06O6Qur5CbCdidOq1+sW01ucFKhBzaPXH9k5tLGB1iolvbHmOWeZGdCMW9pMZUXEOlMB04FQZU4dWsjLZ0i0sK/LMeAUkt3wm5V1cVolDJJ1RUGmMr/tmsS6YLsZwJvOUaUv5+5/kAv09EEjN0v48i8W042KYKk6TGJBdjXo/KJ4S82x1y32tUqKPCmZLR7BKQ2XgBRghb/PNAqUUirZ2k1kysKCOl3aRSzqGuZzDF2eV9SVhd7fVYwhW/Hg+idAos4qlbTqrIAgnDuKwII++SfnU9cCzPthX5GvlzDGIHvZ6Aga6nRV0vaktDJyjreLAMBX3S2SgPQeS3yLm2FskBhfTFrRu///Tnj7thX5yHvW8qVWNtHfqV7Vg2dZjOt572m6LHdGNtD9sbJ2jcpQbMBKLnzyuIlQMxkIP9ZsT1zc21h9itA0R29I+ff7n19LdhlNmFq97CZBdz/U/ROKvDodQtgzTtj7YEo2tnY/C9zrnB8Vcg7YEY2myZ9GzxSGcGJdtircAK4nBE+zNFSgf57d9QngNHaZnLq6vPmxCyeUXIJO/K+K//3ij/sBWGbQjceK2rehS67Gcop5uGblIxUASzgnKAmLRd6hErmglUUwKS7SXMqqfiSzpik2FohNEmn6hkEKryjtDcqJ+M+YdHCbdwPNr0OGJdeMl/nSJVH+q1/wg01UpUA4rKCejdVtFLTB3ZZ9jwoAyGi3vldHTb2l8vrsNXxJUkuBZ7MyNXFsWFC5nFiGWKxXQxTDb69Ol2W11zfSacYkToO1btt62kuKgMVqxxXSbn2seVvpPu0nRTpF37oHR15NQlETXuROapKyIxoPViFr/z37n4zldUgn/Zd5JIzHm9KPC5MOiH52W9ZkIsXPFfPlzd002Pgcu5RvBDSsoUrm8ISs4NfkhJkdYc3uxzJPgxHiuZxVbHBazpbjnIysLqc+BQoRg4TLVid6fS186ZNYXD0xHNqt7A8LYcJeGvSwfjf3CZ9HKZpHM5C0Uf0mx7fY56Lg085XcBKMKCeIfKlcv5kWuxuq4+s475vZ8yeTd9mYSl2K1OkvP/S1goS63OxtEl3PlW/MpXuqt4zbyUtXJZr9XVonid9Vcuk4n7v8966cOXCwqm8+3YT8W8nbpi/Bdjt3IJHqcptg66qdaqY5MYFJ71VL5cj0BUEH/Ri68WuuzZ9uxNv/d6Yu8wfG2bh8vddm9/QqeJuoHPLZg1UH6TYIYXK7oJwa192AE/xL8TPRFheWiffw7UCMsDI7w5MML9gRE2Bkb4YGCEhwMjPAaE/wBRwgVlaRgAAA==";
    private static final Log log = LogFactory.getLog(CoordinateDemo.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    private boolean allComponentsCreated;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JPanel config;
    protected JPanel configLatitude;
    protected JPanel configLongitude;
    protected final CoordinateDemoHandler handler = createHandler();
    protected Float latitudeDd;
    protected NumberEditor latitudeDdEditor;
    protected DmdCoordinate latitudeDmd;
    protected DmdCoordinateEditor latitudeDmdEditor;
    protected DmsCoordinate latitudeDms;
    protected DmsCoordinateEditor latitudeDmsEditor;
    protected JAXXButtonGroup latitudeEditor;
    protected JPanel latitudePane;
    protected JCheckBox latitudeShowReset;
    protected JRadioButton latitudeUseDd;
    protected JRadioButton latitudeUseDmd;
    protected JRadioButton latitudeUseDms;
    protected Float longitudeDd;
    protected NumberEditor longitudeDdEditor;
    protected DmdCoordinate longitudeDmd;
    protected DmdCoordinateEditor longitudeDmdEditor;
    protected DmsCoordinate longitudeDms;
    protected DmsCoordinateEditor longitudeDmsEditor;
    protected JAXXButtonGroup longitudeEditor;
    protected JPanel longitudePane;
    protected JCheckBox longitudeShowReset;
    protected JRadioButton longitudeUseDd;
    protected JRadioButton longitudeUseDmd;
    protected JRadioButton longitudeUseDms;
    protected CoordinateDemoModel model;
    protected JPanel result;
    protected JLabel resultLatitude;
    protected JLabel resultLongitude;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private CoordinateDemo $DemoPanel0 = this;
    private JPanel $JPanel0;
    private Table $Table0;

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public CoordinateDemo() {
        $initialize();
    }

    public CoordinateDemo(JAXXContext param0) {
        super(param0);
        $initialize();
    }

    public CoordinateDemo(boolean param0) {
        super(param0);
        $initialize();
    }

    public CoordinateDemo(JAXXContext param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public CoordinateDemo(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public CoordinateDemo(JAXXContext param0, LayoutManager param1) {
        super(param0 ,param1);
        $initialize();
    }

    public CoordinateDemo(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public CoordinateDemo(JAXXContext param0, LayoutManager param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__latitudeUseDd(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.useLatitudeDdEditor();
    }

    public void doActionPerformed__on__latitudeUseDmd(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.useLatitudeDmdEditor();
    }

    public void doActionPerformed__on__latitudeUseDms(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.useLatitudeDmsEditor();
    }

    public void doActionPerformed__on__longitudeUseDd(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.useLongitudeDdEditor();
    }

    public void doActionPerformed__on__longitudeUseDmd(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.useLongitudeDmdEditor();
    }

    public void doActionPerformed__on__longitudeUseDms(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.useLongitudeDmsEditor();
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JPanel getConfig() {
        return config;
    }

    public JPanel getConfigLatitude() {
        return configLatitude;
    }

    public JPanel getConfigLongitude() {
        return configLongitude;
    }

    public CoordinateDemoHandler getHandler() {
        return handler;
    }

    public Float getLatitudeDd() {
        return latitudeDd;
    }

    public NumberEditor getLatitudeDdEditor() {
        return latitudeDdEditor;
    }

    public DmdCoordinate getLatitudeDmd() {
        return latitudeDmd;
    }

    public DmdCoordinateEditor getLatitudeDmdEditor() {
        return latitudeDmdEditor;
    }

    public DmsCoordinate getLatitudeDms() {
        return latitudeDms;
    }

    public DmsCoordinateEditor getLatitudeDmsEditor() {
        return latitudeDmsEditor;
    }

    public JAXXButtonGroup getLatitudeEditor() {
        return latitudeEditor;
    }

    public JPanel getLatitudePane() {
        return latitudePane;
    }

    public JCheckBox getLatitudeShowReset() {
        return latitudeShowReset;
    }

    public JRadioButton getLatitudeUseDd() {
        return latitudeUseDd;
    }

    public JRadioButton getLatitudeUseDmd() {
        return latitudeUseDmd;
    }

    public JRadioButton getLatitudeUseDms() {
        return latitudeUseDms;
    }

    public Float getLongitudeDd() {
        return longitudeDd;
    }

    public NumberEditor getLongitudeDdEditor() {
        return longitudeDdEditor;
    }

    public DmdCoordinate getLongitudeDmd() {
        return longitudeDmd;
    }

    public DmdCoordinateEditor getLongitudeDmdEditor() {
        return longitudeDmdEditor;
    }

    public DmsCoordinate getLongitudeDms() {
        return longitudeDms;
    }

    public DmsCoordinateEditor getLongitudeDmsEditor() {
        return longitudeDmsEditor;
    }

    public JAXXButtonGroup getLongitudeEditor() {
        return longitudeEditor;
    }

    public JPanel getLongitudePane() {
        return longitudePane;
    }

    public JCheckBox getLongitudeShowReset() {
        return longitudeShowReset;
    }

    public JRadioButton getLongitudeUseDd() {
        return longitudeUseDd;
    }

    public JRadioButton getLongitudeUseDmd() {
        return longitudeUseDmd;
    }

    public JRadioButton getLongitudeUseDms() {
        return longitudeUseDms;
    }

    public CoordinateDemoModel getModel() {
        return model;
    }

    public JPanel getResult() {
        return result;
    }

    public JLabel getResultLatitude() {
        return resultLatitude;
    }

    public JLabel getResultLongitude() {
        return resultLongitude;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setLatitudeDd(Float latitudeDd) {
        Float oldValue = this.latitudeDd;
        this.latitudeDd = latitudeDd;
        firePropertyChange(PROPERTY_LATITUDE_DD, oldValue, latitudeDd);
    }

    public void setLongitudeDd(Float longitudeDd) {
        Float oldValue = this.longitudeDd;
        this.longitudeDd = longitudeDd;
        firePropertyChange(PROPERTY_LONGITUDE_DD, oldValue, longitudeDd);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JPanel get$JPanel0() {
        return $JPanel0;
    }

    protected Table get$Table0() {
        return $Table0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToConfig() {
        if (!allComponentsCreated) {
            return;
        }
        config.add(configLatitude);
        config.add(configLongitude);
    }

    protected void addChildrenToConfigLatitude() {
        if (!allComponentsCreated) {
            return;
        }
        configLatitude.add(latitudeShowReset);
        configLatitude.add(latitudeUseDms);
        configLatitude.add(latitudeUseDmd);
        configLatitude.add(latitudeUseDd);
    }

    protected void addChildrenToConfigLongitude() {
        if (!allComponentsCreated) {
            return;
        }
        configLongitude.add(longitudeShowReset);
        configLongitude.add(longitudeUseDms);
        configLongitude.add(longitudeUseDmd);
        configLongitude.add(longitudeUseDd);
    }

    protected void addChildrenToLatitudePane() {
        if (!allComponentsCreated) {
            return;
        }
        latitudePane.add(latitudeDmsEditor);
        latitudePane.add(latitudeDmdEditor);
        latitudePane.add(latitudeDdEditor);
    }

    protected void addChildrenToLatitudeUseDd() {
        if (!allComponentsCreated) {
            return;
        }
        { ButtonGroup $buttonGroup = latitudeEditor; latitudeUseDd.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add(latitudeUseDd); }
    }

    protected void addChildrenToLatitudeUseDmd() {
        if (!allComponentsCreated) {
            return;
        }
        { ButtonGroup $buttonGroup = latitudeEditor; latitudeUseDmd.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add(latitudeUseDmd); }
    }

    protected void addChildrenToLatitudeUseDms() {
        if (!allComponentsCreated) {
            return;
        }
        { ButtonGroup $buttonGroup = latitudeEditor; latitudeUseDms.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add(latitudeUseDms); }
    }

    protected void addChildrenToLongitudePane() {
        if (!allComponentsCreated) {
            return;
        }
        longitudePane.add(longitudeDmsEditor);
        longitudePane.add(longitudeDmdEditor);
        longitudePane.add(longitudeDdEditor);
    }

    protected void addChildrenToLongitudeUseDd() {
        if (!allComponentsCreated) {
            return;
        }
        { ButtonGroup $buttonGroup = longitudeEditor; longitudeUseDd.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add(longitudeUseDd); }
    }

    protected void addChildrenToLongitudeUseDmd() {
        if (!allComponentsCreated) {
            return;
        }
        { ButtonGroup $buttonGroup = longitudeEditor; longitudeUseDmd.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add(longitudeUseDmd); }
    }

    protected void addChildrenToLongitudeUseDms() {
        if (!allComponentsCreated) {
            return;
        }
        { ButtonGroup $buttonGroup = longitudeEditor; longitudeUseDms.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add(longitudeUseDms); }
    }

    protected void addChildrenToResult() {
        if (!allComponentsCreated) {
            return;
        }
        result.add(resultLatitude);
        result.add(resultLongitude);
    }

    protected void createConfig() {
        $objectMap.put("config", config = new JPanel());
        
        config.setName("config");
        config.setLayout(new GridLayout(1,0));
    }

    protected void createConfigLatitude() {
        $objectMap.put("configLatitude", configLatitude = new JPanel());
        
        configLatitude.setName("configLatitude");
        configLatitude.setLayout(new GridLayout(0,1));
    }

    protected void createConfigLongitude() {
        $objectMap.put("configLongitude", configLongitude = new JPanel());
        
        configLongitude.setName("configLongitude");
        configLongitude.setLayout(new GridLayout(0,1));
    }

    protected CoordinateDemoHandler createHandler() {
        return new CoordinateDemoHandler();
    }

    protected void createLatitudeDd() {
        $objectMap.put("latitudeDd", latitudeDd = null);
    }

    protected void createLatitudeDdEditor() {
        $objectMap.put("latitudeDdEditor", latitudeDdEditor = new NumberEditor(this));
        
        latitudeDdEditor.setName("latitudeDdEditor");
        latitudeDdEditor.setProperty("latitudeDd");
        latitudeDdEditor.setUseSign(true);
        latitudeDdEditor.setUseFloat(true);
    }

    protected void createLatitudeDmd() {
        $objectMap.put("latitudeDmd", latitudeDmd = new DmdCoordinate());
    }

    protected void createLatitudeDmdEditor() {
        $objectMap.put("latitudeDmdEditor", latitudeDmdEditor = new DmdCoordinateEditor(this));
        
        latitudeDmdEditor.setName("latitudeDmdEditor");
        latitudeDmdEditor.setPropertyDecimal("decimal");
        latitudeDmdEditor.setPropertySign("sign");
        latitudeDmdEditor.setPropertyMinute("minute");
        latitudeDmdEditor.setPropertyDegree("degree");
    }

    protected void createLatitudeDms() {
        $objectMap.put("latitudeDms", latitudeDms = new DmsCoordinate());
    }

    protected void createLatitudeDmsEditor() {
        $objectMap.put("latitudeDmsEditor", latitudeDmsEditor = new DmsCoordinateEditor(this));
        
        latitudeDmsEditor.setName("latitudeDmsEditor");
        latitudeDmsEditor.setPropertySign("sign");
        latitudeDmsEditor.setPropertyMinute("minute");
        latitudeDmsEditor.setPropertySecond("second");
        latitudeDmsEditor.setPropertyDegree("degree");
    }

    protected void createLatitudeEditor() {
        $objectMap.put("latitudeEditor", latitudeEditor = new JAXXButtonGroup());
    }

    protected void createLatitudePane() {
        $objectMap.put("latitudePane", latitudePane = new JPanel());
        
        latitudePane.setName("latitudePane");
        latitudePane.setLayout(new GridLayout(0,1));
    }

    protected void createLatitudeShowReset() {
        $objectMap.put("latitudeShowReset", latitudeShowReset = new JCheckBox());
        
        latitudeShowReset.setName("latitudeShowReset");
        latitudeShowReset.setText(t("jaxxdemo.coordinate.showReset"));
        latitudeShowReset.setSelected(true);
    }

    protected void createLatitudeUseDd() {
        $objectMap.put("latitudeUseDd", latitudeUseDd = new JRadioButton());
        
        latitudeUseDd.setName("latitudeUseDd");
        latitudeUseDd.setText(t("jaxxdemo.coordinate.latitudeDd"));
        { latitudeUseDd.putClientProperty("$value", "DD");  Object $buttonGroup = latitudeUseDd.getClientProperty("$buttonGroup"); if ($buttonGroup instanceof JAXXButtonGroup) { ((JAXXButtonGroup) $buttonGroup).updateSelectedValue(); } }
        
        latitudeUseDd.setSelected(true);
        latitudeUseDd.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__latitudeUseDd"));
    }

    protected void createLatitudeUseDmd() {
        $objectMap.put("latitudeUseDmd", latitudeUseDmd = new JRadioButton());
        
        latitudeUseDmd.setName("latitudeUseDmd");
        latitudeUseDmd.setText(t("jaxxdemo.coordinate.latitudeDmd"));
        { latitudeUseDmd.putClientProperty("$value", "DMD");  Object $buttonGroup = latitudeUseDmd.getClientProperty("$buttonGroup"); if ($buttonGroup instanceof JAXXButtonGroup) { ((JAXXButtonGroup) $buttonGroup).updateSelectedValue(); } }
        
        latitudeUseDmd.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__latitudeUseDmd"));
    }

    protected void createLatitudeUseDms() {
        $objectMap.put("latitudeUseDms", latitudeUseDms = new JRadioButton());
        
        latitudeUseDms.setName("latitudeUseDms");
        latitudeUseDms.setText(t("jaxxdemo.coordinate.latitudeDms"));
        { latitudeUseDms.putClientProperty("$value", "DMS");  Object $buttonGroup = latitudeUseDms.getClientProperty("$buttonGroup"); if ($buttonGroup instanceof JAXXButtonGroup) { ((JAXXButtonGroup) $buttonGroup).updateSelectedValue(); } }
        
        latitudeUseDms.setSelected(true);
        latitudeUseDms.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__latitudeUseDms"));
    }

    protected void createLongitudeDd() {
        $objectMap.put("longitudeDd", longitudeDd = null);
    }

    protected void createLongitudeDdEditor() {
        $objectMap.put("longitudeDdEditor", longitudeDdEditor = new NumberEditor(this));
        
        longitudeDdEditor.setName("longitudeDdEditor");
        longitudeDdEditor.setProperty("longitudeDd");
        longitudeDdEditor.setUseSign(true);
        longitudeDdEditor.setUseFloat(true);
    }

    protected void createLongitudeDmd() {
        $objectMap.put("longitudeDmd", longitudeDmd = new DmdCoordinate());
    }

    protected void createLongitudeDmdEditor() {
        $objectMap.put("longitudeDmdEditor", longitudeDmdEditor = new DmdCoordinateEditor(this));
        
        longitudeDmdEditor.setName("longitudeDmdEditor");
        longitudeDmdEditor.setPropertyDecimal("decimal");
        longitudeDmdEditor.setPropertySign("sign");
        longitudeDmdEditor.setPropertyMinute("minute");
        longitudeDmdEditor.setPropertyDegree("degree");
    }

    protected void createLongitudeDms() {
        $objectMap.put("longitudeDms", longitudeDms = new DmsCoordinate());
    }

    protected void createLongitudeDmsEditor() {
        $objectMap.put("longitudeDmsEditor", longitudeDmsEditor = new DmsCoordinateEditor(this));
        
        longitudeDmsEditor.setName("longitudeDmsEditor");
        longitudeDmsEditor.setPropertySign("sign");
        longitudeDmsEditor.setPropertyMinute("minute");
        longitudeDmsEditor.setPropertySecond("second");
        longitudeDmsEditor.setPropertyDegree("degree");
    }

    protected void createLongitudeEditor() {
        $objectMap.put("longitudeEditor", longitudeEditor = new JAXXButtonGroup());
    }

    protected void createLongitudePane() {
        $objectMap.put("longitudePane", longitudePane = new JPanel());
        
        longitudePane.setName("longitudePane");
        longitudePane.setLayout(new GridLayout(0,1));
    }

    protected void createLongitudeShowReset() {
        $objectMap.put("longitudeShowReset", longitudeShowReset = new JCheckBox());
        
        longitudeShowReset.setName("longitudeShowReset");
        longitudeShowReset.setText(t("jaxxdemo.numbereditor.showReset"));
        longitudeShowReset.setSelected(true);
    }

    protected void createLongitudeUseDd() {
        $objectMap.put("longitudeUseDd", longitudeUseDd = new JRadioButton());
        
        longitudeUseDd.setName("longitudeUseDd");
        longitudeUseDd.setText(t("jaxxdemo.coordinate.longitudeDd"));
        { longitudeUseDd.putClientProperty("$value", "DD");  Object $buttonGroup = longitudeUseDd.getClientProperty("$buttonGroup"); if ($buttonGroup instanceof JAXXButtonGroup) { ((JAXXButtonGroup) $buttonGroup).updateSelectedValue(); } }
        
        longitudeUseDd.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__longitudeUseDd"));
    }

    protected void createLongitudeUseDmd() {
        $objectMap.put("longitudeUseDmd", longitudeUseDmd = new JRadioButton());
        
        longitudeUseDmd.setName("longitudeUseDmd");
        longitudeUseDmd.setText(t("jaxxdemo.coordinate.longitudeDmd"));
        { longitudeUseDmd.putClientProperty("$value", "DMD");  Object $buttonGroup = longitudeUseDmd.getClientProperty("$buttonGroup"); if ($buttonGroup instanceof JAXXButtonGroup) { ((JAXXButtonGroup) $buttonGroup).updateSelectedValue(); } }
        
        longitudeUseDmd.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__longitudeUseDmd"));
    }

    protected void createLongitudeUseDms() {
        $objectMap.put("longitudeUseDms", longitudeUseDms = new JRadioButton());
        
        longitudeUseDms.setName("longitudeUseDms");
        longitudeUseDms.setText(t("jaxxdemo.coordinate.longitudeDms"));
        { longitudeUseDms.putClientProperty("$value", "DMS");  Object $buttonGroup = longitudeUseDms.getClientProperty("$buttonGroup"); if ($buttonGroup instanceof JAXXButtonGroup) { ((JAXXButtonGroup) $buttonGroup).updateSelectedValue(); } }
        
        longitudeUseDms.setSelected(true);
        longitudeUseDms.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__longitudeUseDms"));
    }

    protected void createModel() {
        $objectMap.put("model", model = new CoordinateDemoModel());
    }

    protected void createResult() {
        $objectMap.put("result", result = new JPanel());
        
        result.setName("result");
        result.setLayout(new GridLayout(0,1));
    }

    protected void createResultLatitude() {
        $objectMap.put("resultLatitude", resultLatitude = new JLabel());
        
        resultLatitude.setName("resultLatitude");
    }

    protected void createResultLongitude() {
        $objectMap.put("resultLongitude", resultLongitude = new JLabel());
        
        resultLongitude.setName("resultLongitude");
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // inline complete setup of $DemoPanel0
        add($Table0, BorderLayout.NORTH);
        // inline complete setup of $Table0
        $Table0.add(config, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        $Table0.add($JPanel0, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        $Table0.add(result, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        addChildrenToConfig();
        addChildrenToConfigLatitude();
        addChildrenToLatitudeUseDms();
        addChildrenToLatitudeUseDmd();
        addChildrenToLatitudeUseDd();
        addChildrenToConfigLongitude();
        addChildrenToLongitudeUseDms();
        addChildrenToLongitudeUseDmd();
        addChildrenToLongitudeUseDd();
        // inline complete setup of $JPanel0
        $JPanel0.add(latitudePane);
        $JPanel0.add(longitudePane);
        addChildrenToLatitudePane();
        addChildrenToLongitudePane();
        addChildrenToResult();
        
        // apply 8 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 18 property setters
        config.setBorder(new TitledBorder(t("jaxxdemo.numbereditor.configuration")));
        latitudePane.setBorder(new TitledBorder(t("jaxxdemo.coordinate.latitude")));
        latitudeDmsEditor.setBean(latitudeDms);
        latitudeDmdEditor.setBean(latitudeDmd);
        latitudeDdEditor.setBean(this);
        longitudePane.setBorder(new TitledBorder(t("jaxxdemo.coordinate.longitude")));
        longitudeDmsEditor.setBean(longitudeDms);
        longitudeDmdEditor.setBean(longitudeDmd);
        longitudeDdEditor.setBean(this);
        result.setBorder(new TitledBorder(t("jaxxdemo.coordinate.result")));
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        handler.beforeInit(this);
        $objectMap.put("$DemoPanel0", $DemoPanel0);
        createModel();
        createLatitudeDms();
        createLatitudeDmd();
        createLatitudeDd();
        createLongitudeDms();
        createLongitudeDmd();
        createLongitudeDd();
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new Table());
        
        $Table0.setName("$Table0");
        createConfig();
        createConfigLatitude();
        createLatitudeShowReset();
        createLatitudeUseDms();
        createLatitudeUseDmd();
        createLatitudeUseDd();
        createConfigLongitude();
        createLongitudeShowReset();
        createLongitudeUseDms();
        createLongitudeUseDmd();
        createLongitudeUseDd();
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new JPanel());
        
        $JPanel0.setName("$JPanel0");
        $JPanel0.setLayout(new GridLayout(1,0));
        createLatitudePane();
        createLatitudeDmsEditor();
        createLatitudeDmdEditor();
        createLatitudeDdEditor();
        createLongitudePane();
        createLongitudeDmsEditor();
        createLongitudeDmdEditor();
        createLongitudeDdEditor();
        createResult();
        createResultLatitude();
        createResultLongitude();
        createLatitudeEditor();
        createLongitudeEditor();
        // inline creation of $DemoPanel0
        setName("$DemoPanel0");
        setLayout(new BorderLayout());
        
        // registers 8 data bindings
        $registerDefaultBindings();
        $completeSetup();
        handler.afterInit(this);
    }

    private void $registerDefaultBindings() {
        // register 8 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_LATITUDE_DMS_EDITOR_SHOW_RESET, true) {
        
            @Override
            public void applyDataBinding() {
                if (latitudeShowReset != null) {
                    $bindingSources.put("latitudeShowReset.getModel()", latitudeShowReset.getModel());
                    latitudeShowReset.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u0"));
                    latitudeShowReset.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.component.jaxx.editor.gis.CoordinateDemo.this, BINDING_LATITUDE_DMS_EDITOR_SHOW_RESET));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (latitudeShowReset != null) {
                    latitudeDmsEditor.setShowReset(latitudeShowReset.isSelected());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (latitudeShowReset != null) {
                    ButtonModel $target = (ButtonModel) $bindingSources.remove("latitudeShowReset.getModel()");
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u0"));
                    }
                    latitudeShowReset.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.component.jaxx.editor.gis.CoordinateDemo.this, BINDING_LATITUDE_DMS_EDITOR_SHOW_RESET));
                }
            }
        
            public void $pr$u0(ChangeEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_LATITUDE_DMD_EDITOR_SHOW_RESET, true) {
        
            @Override
            public void applyDataBinding() {
                if (latitudeShowReset != null) {
                    $bindingSources.put("latitudeShowReset.getModel()", latitudeShowReset.getModel());
                    latitudeShowReset.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u1"));
                    latitudeShowReset.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.component.jaxx.editor.gis.CoordinateDemo.this, BINDING_LATITUDE_DMD_EDITOR_SHOW_RESET));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (latitudeShowReset != null) {
                    latitudeDmdEditor.setShowReset(latitudeShowReset.isSelected());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (latitudeShowReset != null) {
                    ButtonModel $target = (ButtonModel) $bindingSources.remove("latitudeShowReset.getModel()");
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u1"));
                    }
                    latitudeShowReset.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.component.jaxx.editor.gis.CoordinateDemo.this, BINDING_LATITUDE_DMD_EDITOR_SHOW_RESET));
                }
            }
        
            public void $pr$u1(ChangeEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_LATITUDE_DD_EDITOR_SHOW_RESET, true) {
        
            @Override
            public void applyDataBinding() {
                if (latitudeShowReset != null) {
                    $bindingSources.put("latitudeShowReset.getModel()", latitudeShowReset.getModel());
                    latitudeShowReset.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u2"));
                    latitudeShowReset.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.component.jaxx.editor.gis.CoordinateDemo.this, BINDING_LATITUDE_DD_EDITOR_SHOW_RESET));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (latitudeShowReset != null) {
                    latitudeDdEditor.setShowReset(latitudeShowReset.isSelected());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (latitudeShowReset != null) {
                    ButtonModel $target = (ButtonModel) $bindingSources.remove("latitudeShowReset.getModel()");
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u2"));
                    }
                    latitudeShowReset.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.component.jaxx.editor.gis.CoordinateDemo.this, BINDING_LATITUDE_DD_EDITOR_SHOW_RESET));
                }
            }
        
            public void $pr$u2(ChangeEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_LONGITUDE_DMS_EDITOR_SHOW_RESET, true) {
        
            @Override
            public void applyDataBinding() {
                if (longitudeShowReset != null) {
                    $bindingSources.put("longitudeShowReset.getModel()", longitudeShowReset.getModel());
                    longitudeShowReset.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u3"));
                    longitudeShowReset.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.component.jaxx.editor.gis.CoordinateDemo.this, BINDING_LONGITUDE_DMS_EDITOR_SHOW_RESET));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (longitudeShowReset != null) {
                    longitudeDmsEditor.setShowReset(longitudeShowReset.isSelected());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (longitudeShowReset != null) {
                    ButtonModel $target = (ButtonModel) $bindingSources.remove("longitudeShowReset.getModel()");
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u3"));
                    }
                    longitudeShowReset.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.component.jaxx.editor.gis.CoordinateDemo.this, BINDING_LONGITUDE_DMS_EDITOR_SHOW_RESET));
                }
            }
        
            public void $pr$u3(ChangeEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_LONGITUDE_DMD_EDITOR_SHOW_RESET, true) {
        
            @Override
            public void applyDataBinding() {
                if (longitudeShowReset != null) {
                    $bindingSources.put("longitudeShowReset.getModel()", longitudeShowReset.getModel());
                    longitudeShowReset.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u4"));
                    longitudeShowReset.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.component.jaxx.editor.gis.CoordinateDemo.this, BINDING_LONGITUDE_DMD_EDITOR_SHOW_RESET));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (longitudeShowReset != null) {
                    longitudeDmdEditor.setShowReset(longitudeShowReset.isSelected());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (longitudeShowReset != null) {
                    ButtonModel $target = (ButtonModel) $bindingSources.remove("longitudeShowReset.getModel()");
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u4"));
                    }
                    longitudeShowReset.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.component.jaxx.editor.gis.CoordinateDemo.this, BINDING_LONGITUDE_DMD_EDITOR_SHOW_RESET));
                }
            }
        
            public void $pr$u4(ChangeEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_LONGITUDE_DD_EDITOR_SHOW_RESET, true) {
        
            @Override
            public void applyDataBinding() {
                if (longitudeShowReset != null) {
                    $bindingSources.put("longitudeShowReset.getModel()", longitudeShowReset.getModel());
                    longitudeShowReset.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u5"));
                    longitudeShowReset.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.component.jaxx.editor.gis.CoordinateDemo.this, BINDING_LONGITUDE_DD_EDITOR_SHOW_RESET));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (longitudeShowReset != null) {
                    longitudeDdEditor.setShowReset(longitudeShowReset.isSelected());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (longitudeShowReset != null) {
                    ButtonModel $target = (ButtonModel) $bindingSources.remove("longitudeShowReset.getModel()");
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u5"));
                    }
                    longitudeShowReset.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.component.jaxx.editor.gis.CoordinateDemo.this, BINDING_LONGITUDE_DD_EDITOR_SHOW_RESET));
                }
            }
        
            public void $pr$u5(ChangeEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_RESULT_LATITUDE_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("latitude", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    resultLatitude.setText(t(handler.getLatitudeText(model.getLatitude())));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("latitude", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_RESULT_LONGITUDE_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("longitude", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    resultLongitude.setText(t(handler.getLongitudeText(model.getLongitude())));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("longitude", this);
                }
            }
        });
    }

}