/*
 * #%L
 * JAXX :: Compiler
 * 
 * $Id: InitTask.java 2225 2011-02-19 20:15:00Z tchemit $
 * $HeadURL: http://svn.nuiton.org/svn/jaxx/tags/jaxx-2.5.10/jaxx-compiler/src/main/java/jaxx/compiler/tasks/InitTask.java $
 * %%
 * Copyright (C) 2008 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package jaxx.compiler.tasks;

import jaxx.compiler.CompilerConfiguration;
import jaxx.compiler.JAXXEngine;
import jaxx.compiler.JAXXFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * The init task to be launched first.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 2.0.2
 */
public class InitTask extends JAXXEngineTask {

    /** Logger */
    private static final Log log = LogFactory.getLog(InitTask.class);

    /** Task name */
    public static final String TASK_NAME = "Init";

    public InitTask() {
        super(TASK_NAME);
    }

    @Override
    public boolean perform(JAXXEngine engine) throws Exception {
        boolean success = true;

        CompilerConfiguration configuration = engine.getConfiguration();

        // check initializers
        if (configuration.getInitializers() == null) {
            throw new NullPointerException(
                    "no initializers found in configuration.");
        }

        // check decorators
        if (configuration.getDecorators() == null) {

            throw new NullPointerException(
                    "no decorators found in configuration.");
        }

        // check finalizers
        if (configuration.getFinalizers() == null) {

            throw new NullPointerException(
                    "no finalizers found in configuration.");
        }

        if (configuration.isVerbose()) {
            log.info("Will init " + JAXXFactory.class.getName());
        }
        JAXXFactory.initFactory();

        engine.clearReports();

        return success;
    }
}
