/*
 * Decompiled with CFR 0.152.
 */
package jaxx.compiler;

import java.util.Arrays;
import java.util.List;
import jaxx.compiler.CompiledObject;
import jaxx.compiler.JAXXCompiler;
import jaxx.runtime.SwingUtil;
import org.apache.commons.lang3.CharUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

public class I18nHelper {
    protected static final Log log = LogFactory.getLog(I18nHelper.class);
    public static final List<String> I18N_ATTRIBUTES = Arrays.asList("text", "title", "toolTipText");

    public static boolean isI18nableAttribute(String attributeName, JAXXCompiler compiler) {
        return compiler.getConfiguration().isI18nable() && I18nHelper.isI18nAttribute(attributeName);
    }

    public static boolean isI18nAttribute(String attributeName) {
        return I18N_ATTRIBUTES.contains(attributeName);
    }

    public static String addI18nInvocation(String widgetId, String attributeName, String attributeValueCode, JAXXCompiler compiler) {
        if (log.isDebugEnabled()) {
            log.debug((Object)(" try i18n support for [" + widgetId + ":" + attributeName + "] : " + attributeValueCode));
        }
        boolean doWarn = false;
        int indexOf = attributeValueCode.indexOf("t(");
        if (indexOf > -1 && !attributeValueCode.contains(",")) {
            char charBefore;
            doWarn = indexOf == 0 ? true : !CharUtils.isAsciiAlphanumeric((char)(charBefore = attributeValueCode.charAt(indexOf - 1)));
        }
        if (doWarn) {
            compiler.reportWarning("\n\tjaxx supports i18n, no need to add explicit call to I18n.t for attribute '" + attributeName + "' in component '" + widgetId + "' : [" + attributeValueCode + "]");
        } else {
            compiler.addImport("static " + I18n.class.getName() + ".t");
            attributeValueCode = "t(" + attributeValueCode + ")";
        }
        return attributeValueCode;
    }

    public static String addI18nMnemonicInvocation(CompiledObject object, String attributeName, String attributeValueCode, JAXXCompiler compiler) {
        String stringValue = I18nHelper.addI18nInvocation(object.getId(), attributeName, attributeValueCode, compiler);
        compiler.addImport(SwingUtil.class.getName());
        return "{" + SwingUtil.class.getSimpleName() + ".getFirstCharAt(" + stringValue + ",'Z')}";
    }
}

