/*
 * Decompiled with CFR 0.152.
 */
package jaxx.compiler.tools;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import jaxx.compiler.JAXXCompiler;
import jaxx.compiler.JAXXEngine;
import jaxx.compiler.beans.JAXXPropertyDescriptor;
import jaxx.compiler.reflect.ClassDescriptor;
import jaxx.compiler.reflect.ClassDescriptorLoader;
import jaxx.compiler.reflect.MethodDescriptor;
import jaxx.compiler.tags.DefaultObjectHandler;
import jaxx.compiler.tags.TagManager;
import org.apache.commons.lang.StringUtils;

public class PrintTagInfo {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] arg) throws Exception {
        BufferedWriter w;
        if (arg.length < 1) {
            throw new IllegalArgumentException("programm needs at least two parameters : the file where to put the result, and at least one fqn class to treate");
        }
        String firstarg = arg[0];
        boolean toFile = false;
        if (firstarg.startsWith("file:")) {
            w = new BufferedWriter(new FileWriter(firstarg.substring(5)));
            toFile = true;
        } else {
            w = new BufferedWriter(new OutputStreamWriter(System.out));
        }
        try {
            int i;
            JAXXEngine.loadLibraries(false);
            int n = i = toFile ? 1 : 0;
            while (i < arg.length) {
                String className = arg[i];
                PrintTagInfo.treateClass(w, className);
                ++i;
            }
        }
        finally {
            w.flush();
            w.close();
        }
    }

    protected static void treateClass(BufferedWriter w, String className) throws ClassNotFoundException, IOException {
        ClassDescriptor beanClass = ClassDescriptorLoader.getClassDescriptor(className);
        DefaultObjectHandler handler = TagManager.getTagHandler(beanClass);
        DefaultObjectHandler superHandler = TagManager.getTagHandler(beanClass.getSuperclass());
        w.append("Properties in ").append(String.valueOf(beanClass));
        w.newLine();
        JAXXPropertyDescriptor[] properties = handler.getJAXXBeanInfo().getJAXXPropertyDescriptors();
        JAXXPropertyDescriptor[] superProperties = superHandler.getJAXXBeanInfo().getJAXXPropertyDescriptors();
        for (JAXXPropertyDescriptor property : properties) {
            if (property.getWriteMethodDescriptor() == null) continue;
            boolean found = false;
            String name = property.getName();
            for (JAXXPropertyDescriptor superProperty : superProperties) {
                if (!superProperty.getName().equals(name)) continue;
                found = true;
                break;
            }
            if (found) continue;
            if (property.getPropertyType() == null) {
                System.err.println(name + " has null type");
                continue;
            }
            w.append("{{EquivalentAttribute|");
            w.append(name);
            w.append("|");
            w.append(className.replace('.', '/'));
            w.append("|set");
            w.append(StringUtils.capitalize((String)name));
            w.append("|");
            w.append(JAXXCompiler.getCanonicalName(property.getPropertyType()));
            w.append("}}");
            w.append("|-");
            w.newLine();
        }
        w.newLine();
        w.newLine();
        PrintTagInfo.dumpMethods(w, beanClass, handler);
    }

    protected static void dumpMethods(BufferedWriter w, ClassDescriptor beanClass, DefaultObjectHandler handler) throws IOException {
        MethodDescriptor[] methods = beanClass.getMethodDescriptors();
        w.append("Bound methods in ").append(String.valueOf(beanClass));
        w.newLine();
        for (MethodDescriptor method : methods) {
            try {
                if (!handler.isMemberBound(method.getName())) continue;
                w.append("* <tt>").append(method.getName()).append("()</tt>");
                w.newLine();
            }
            catch (Throwable e) {
                // empty catch block
            }
        }
    }
}

