/*
 * Decompiled with CFR 0.152.
 */
package jaxx.compiler.tags.swing;

import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.List;
import jaxx.compiler.CompiledObject;
import jaxx.compiler.CompilerException;
import jaxx.compiler.JAXXCompiler;
import jaxx.compiler.UnsupportedAttributeException;
import jaxx.compiler.reflect.ClassDescriptor;
import jaxx.compiler.reflect.ClassDescriptorLoader;
import jaxx.compiler.tags.DefaultComponentHandler;
import jaxx.compiler.tags.swing.CellHandler;
import jaxx.compiler.types.TypeManager;
import jaxx.runtime.swing.Table;

public class TableHandler
extends DefaultComponentHandler {
    public static final Insets DEFAULT_INSETS = new Insets(3, 3, 3, 3);

    public TableHandler(ClassDescriptor beanClass) {
        super(beanClass);
        ClassDescriptorLoader.checkSupportClass(this.getClass(), beanClass, Table.class);
    }

    @Override
    public void setAttribute(CompiledObject object, String propertyName, String stringValue, boolean inline, JAXXCompiler compiler) throws CompilerException {
        try {
            if (object instanceof CompiledTable) {
                CellHandler.setAttribute(((CompiledTable)object).getTableConstraints(), propertyName, stringValue);
            } else {
                super.setAttribute(object, propertyName, stringValue, inline, compiler);
            }
        }
        catch (UnsupportedAttributeException e) {
            super.setAttribute(object, propertyName, stringValue, inline, compiler);
        }
    }

    @Override
    public CompiledObject createCompiledObject(String id, JAXXCompiler compiler) throws CompilerException {
        return new CompiledTable(id, this.getBeanClass(), compiler);
    }

    class CompiledTable
    extends CompiledObject {
        private List<Integer> rowSpans;
        private GridBagConstraints tableConstraints;
        private GridBagConstraints rowConstraints;
        private GridBagConstraints cellConstraints;
        private boolean emptyCell;

        public CompiledTable(String id, ClassDescriptor objectClass, JAXXCompiler compiler) throws CompilerException {
            super(id, objectClass, compiler);
            this.rowSpans = new ArrayList<Integer>();
            this.rowConstraints = null;
            this.cellConstraints = null;
            this.tableConstraints = new GridBagConstraints();
            this.tableConstraints.gridx = -1;
            this.tableConstraints.gridy = -1;
            this.tableConstraints.insets = DEFAULT_INSETS;
        }

        @Override
        public void addChild(CompiledObject child, String constraints, JAXXCompiler compiler) throws CompilerException {
            GridBagConstraints c;
            if (constraints != null) {
                compiler.reportError("Table does not accept constraints");
            }
            if ((c = this.getCellConstraints()) == null) {
                compiler.reportError("Table tag may only contain row tags");
                return;
            }
            if (!this.emptyCell) {
                compiler.reportError("Table cells may only have one child component");
            }
            while (this.rowSpans.size() < c.gridx + c.gridwidth) {
                this.rowSpans.add(null);
            }
            for (int x = c.gridx; x < c.gridx + c.gridwidth; ++x) {
                this.rowSpans.set(x, c.gridheight);
            }
            super.addChild(child, TypeManager.getJavaCode(c), compiler);
            this.emptyCell = false;
        }

        public GridBagConstraints getTableConstraints() {
            return this.tableConstraints;
        }

        public GridBagConstraints getRowConstraints() {
            return this.rowConstraints;
        }

        public GridBagConstraints getCellConstraints() {
            return this.cellConstraints;
        }

        public void newRow() {
            ++this.tableConstraints.gridy;
            this.tableConstraints.gridx = -1;
            this.rowConstraints = (GridBagConstraints)this.tableConstraints.clone();
            for (int x = 0; x < this.rowSpans.size(); ++x) {
                int rowSpan = this.rowSpans.get(x);
                if (rowSpan <= 0) continue;
                this.rowSpans.set(x, rowSpan - 1);
            }
        }

        public void newCell() {
            this.emptyCell = true;
            ++this.rowConstraints.gridx;
            while (this.rowConstraints.gridx < this.rowSpans.size() && this.rowSpans.get(this.rowConstraints.gridx) > 0) {
                ++this.rowConstraints.gridx;
            }
            this.cellConstraints = (GridBagConstraints)this.rowConstraints.clone();
        }
    }
}

