/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.i18n.plugin.parser;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.maven.plugins.annotations.Parameter;
import org.nuiton.i18n.plugin.AbstractI18nGenerateMojo;
import org.nuiton.i18n.plugin.I18nUtil;
import org.nuiton.i18n.plugin.parser.FileParser;
import org.nuiton.i18n.plugin.parser.I18nParserConfiguration;
import org.nuiton.i18n.plugin.parser.I18nSourceEntry;
import org.nuiton.i18n.plugin.parser.ParserExecutor;
import org.nuiton.i18n.plugin.parser.SourceEntry;
import org.nuiton.io.FileUpdater;
import org.nuiton.io.SortedProperties;
import org.nuiton.plugin.PluginHelper;

public abstract class AbstractI18nParserMojo
extends AbstractI18nGenerateMojo
implements I18nParserConfiguration {
    @Parameter(property="i18n.src", defaultValue="${basedir}/src/main/resources/i18n", required=true)
    protected File src;
    @Parameter(property="i18n.strictMode", defaultValue="false")
    protected boolean strictMode;
    @Parameter(property="i18n.cp", defaultValue="${basedir}/target/classes")
    protected File cp;
    @Parameter(property="i18n.treateDefaultEntry", defaultValue="true")
    protected boolean treateDefaultEntry;
    @Parameter(property="i18n.entries")
    protected I18nSourceEntry[] entries;
    @Parameter(property="i18n.showTouchedFiles", defaultValue="${maven.verbose}")
    protected boolean showTouchedFiles;
    @Parameter(property="i18n.backupGetter", defaultValue="false")
    protected boolean backupGetter;
    @Parameter(property="i18n.force", defaultValue="false")
    protected boolean force;
    @Parameter(property="i18n.acceptKeyFormat")
    protected String acceptKeyFormat;
    protected Pattern acceptPattern;
    private SortedProperties result;
    protected SortedProperties oldParser;
    protected SortedProperties oldLanguage;
    protected long t0;
    ParserExecutor parserExecutor;

    protected abstract String getOutGetter();

    protected abstract String[] getDefaultIncludes();

    protected abstract String[] getDefaultExcludes();

    protected abstract File getDefaultBasedir();

    public abstract FileParser newFileParser(Pattern var1);

    public abstract FileUpdater newFileUpdater(SourceEntry var1);

    public boolean isForce() {
        return this.force;
    }

    @Override
    public void init() throws Exception {
        super.init();
        this.t0 = System.nanoTime();
        this.result = new SortedProperties(this.encoding);
        this.oldParser = new SortedProperties(this.encoding);
        this.oldLanguage = new SortedProperties(this.encoding);
        this.createDirectoryIfNecessary(this.out);
        if (!(this.entries != null && this.entries.length != 0 || this.treateDefaultEntry)) {
            throw new IllegalStateException("No entry defined and treateDefaultEntry is false, will skip the goal.");
        }
        if (this.verbose && this.entries != null && this.entries.length > 0 && this.getLog().isInfoEnabled()) {
            this.getLog().info((CharSequence)("detected entries : " + this.entries.length));
            for (I18nSourceEntry e : this.entries) {
                this.getLog().info((CharSequence)(e.toString() + ", specific goal ? " + e.getSpecificGoal()));
            }
        }
        if (this.acceptKeyFormat != null) {
            this.acceptPattern = Pattern.compile(this.acceptKeyFormat);
        }
        this.parserExecutor = new ParserExecutor(this);
    }

    protected boolean onEnterEntry(I18nSourceEntry entry) {
        boolean skip = entry.init(this);
        return skip;
    }

    protected void doAction() throws Exception {
        if (!this.silent && this.strictMode) {
            this.getLog().info((CharSequence)"config - strictMode is on (all files will be parsed).");
        }
        if (!this.silent && this.force) {
            this.getLog().info((CharSequence)"config - force is on (all files will be parsed).");
        }
        File oldParserFile = this.getGetterFile(this.out, this.getOutGetter(), true);
        File saveFile = this.getBackupFile(oldParserFile);
        this.oldParser.load(oldParserFile);
        if (this.backupGetter) {
            this.backupFile(oldParserFile);
        }
        File oldLanguageFile = I18nUtil.getI18nFile(this.src, this.artifactId, this.locales[0], true);
        this.oldLanguage.load(oldLanguageFile);
        if (this.treateDefaultEntry) {
            this.addDefaultEntry();
        }
        for (I18nSourceEntry entry : this.entries) {
            boolean skip = this.onEnterEntry(entry);
            if (skip) {
                if (this.silent || !this.verbose) continue;
                this.getLog().info((CharSequence)("skip [" + entry + "] - " + entry.getSkipMessage()));
                continue;
            }
            String[] files = entry.getFiles();
            if (!this.silent) {
                this.getLog().info((CharSequence)("start entry " + entry.toString()));
                this.getLog().info((CharSequence)(files.length + " file(s) to process (among " + entry.getFoudFiles() + " files)"));
            }
            for (String file1 : files) {
                String fileName = entry.getBasedir().getAbsolutePath() + File.separator + file1;
                File file = new File(fileName);
                this.parserExecutor.addFile(this.newFileParser(this.acceptPattern), file);
            }
        }
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("ask to terminate " + this.parserExecutor));
        }
        this.parserExecutor.terminatesAndWaits();
        List<File> treadedFiles = this.parserExecutor.getTreatedFiles();
        List<File> touchedFiles = this.parserExecutor.getTouchedFiles();
        if (!this.backupGetter) {
            this.deleteFile(saveFile);
        }
        if (treadedFiles.isEmpty()) {
            if (!this.silent) {
                this.getLog().info((CharSequence)"Nothing was parsed - all files are up to date.");
            }
        } else {
            if (this.showTouchedFiles) {
                for (File f : touchedFiles) {
                    this.getLog().info((CharSequence)("touch " + f));
                }
            }
            if (!this.silent) {
                int i = touchedFiles.size();
                int max = treadedFiles.size();
                this.getLog().info((CharSequence)AbstractI18nParserMojo.getLogEntry("Parsing is done. [treated file(s) : " + i + '/' + max + "]", max, 0L, this.t0));
            }
            this.saveGetterFile();
            this.addGetter();
        }
        this.parserExecutor.clear();
    }

    @Override
    public boolean isShowTouchedFiles() {
        return this.showTouchedFiles;
    }

    @Override
    public SortedProperties getResult() {
        return this.result;
    }

    public boolean isStrictMode() {
        return this.strictMode;
    }

    protected void addDefaultEntry() {
        if (this.verbose) {
            this.getLog().info((CharSequence)"add default entry");
        }
        boolean hasEntries = this.entries != null && this.entries.length > 0;
        I18nSourceEntry[] tmp = new I18nSourceEntry[hasEntries ? this.entries.length + 1 : 1];
        if (hasEntries) {
            System.arraycopy(this.entries, 0, tmp, 0, this.entries.length);
        }
        tmp[tmp.length - 1] = new I18nSourceEntry();
        this.entries = tmp;
    }

    protected void saveGetterFile() throws IOException {
        File getterFile = this.getGetterFile(this.out, this.getOutGetter(), false);
        this.result.store(getterFile);
    }

    public static String getLogEntry(String msg, int nbFiles, long time, long all) {
        long now = System.nanoTime();
        long delta = now - time;
        String s = msg;
        if (time > 0L && all == 0L) {
            s = s + " (" + PluginHelper.convertTime((long)delta) + ")";
        }
        if (all > 0L) {
            s = s + "(total time:" + PluginHelper.convertTime((long)(now - all)) + ")";
        }
        if (nbFiles > 0) {
            s = s + " ( ~ " + PluginHelper.convertTime((long)((now - all) / (long)nbFiles)) + " / file)";
        }
        return s;
    }
}

