/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.guix.tags.swing;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.guix.model.AttributeDescriptor;
import org.nuiton.guix.model.GuixModelObject;
import org.nuiton.guix.tags.swing.CellHandler;
import org.nuiton.guix.tags.swing.PanelHandler;

public class TableHandler
extends PanelHandler {
    private static Log log = LogFactory.getLog(TableHandler.class);
    public static String DEFAULT_ANCHOR = "java.awt.GridBagConstraints.FIRST_LINE_START";
    public static final String DEFAULT_INSETS = "3, 3, 3, 3";
    public static final HorizontalAlignment DEFAULT_HORIZONTAL_ALIGNMENT = HorizontalAlignment.ALIGN_DEFAULT;
    public static final VerticalAlignment DEFAULT_VERTICAL_ALIGNMENT = VerticalAlignment.ALIGN_TOP;
    public static final String DEFAULT_FILL = "both";
    public static final Integer DEFAULT_IPADX = 1;
    public static final Integer DEFAULT_IPADY = 1;
    public static final Double DEFAULT_WEIGHTX = 0.0;
    public static final Double DEFAULT_WEIGHTY = 0.0;
    protected Double weightx = null;
    protected Double weighty = null;
    protected Integer ipadx = null;
    protected Integer ipady = null;
    protected HorizontalAlignment horizontalAlignment = null;
    protected VerticalAlignment verticalAlignment = null;
    protected String fill = null;
    protected String insets = null;

    public TableHandler() {
    }

    public TableHandler(GuixModelObject table) {
        for (AttributeDescriptor attr : table.getAttributeDescriptors()) {
            if (attr.getName().equalsIgnoreCase("weightx")) {
                this.weightx = Double.valueOf(attr.getValue());
                continue;
            }
            if (attr.getName().equalsIgnoreCase("weighty")) {
                this.weighty = Double.valueOf(attr.getValue());
                continue;
            }
            if (attr.getName().equalsIgnoreCase("ipadx")) {
                this.ipadx = Integer.valueOf(attr.getValue());
                continue;
            }
            if (attr.getName().equalsIgnoreCase("ipady")) {
                this.ipady = Integer.valueOf(attr.getValue());
                continue;
            }
            if (attr.getName().equalsIgnoreCase("horizontalAlignment")) {
                this.horizontalAlignment = this.getHalign(attr.getValue());
                if (this.horizontalAlignment != null) continue;
                if (log.isErrorEnabled()) {
                    log.error((Object)(table.getId() + "'s horizontalAlignment attribute has a wrong value : " + attr.getValue()));
                }
                this.horizontalAlignment = DEFAULT_HORIZONTAL_ALIGNMENT;
                continue;
            }
            if (attr.getName().equalsIgnoreCase("verticalAlignment")) {
                this.verticalAlignment = this.getValign(attr.getValue());
                if (this.verticalAlignment != null) continue;
                if (log.isErrorEnabled()) {
                    log.error((Object)(table.getId() + "'s verticalAlignment attribute has a wrong value : " + attr.getValue()));
                }
                this.verticalAlignment = DEFAULT_VERTICAL_ALIGNMENT;
                continue;
            }
            if (attr.getName().equalsIgnoreCase("fill")) {
                this.fill = attr.getValue();
                continue;
            }
            if (!attr.getName().equalsIgnoreCase("insets")) continue;
            this.insets = attr.getValue();
        }
    }

    public HorizontalAlignment getHorizontalAlignment() {
        return this.horizontalAlignment;
    }

    public void setHorizontalAlignment(HorizontalAlignment horizontalAlignment) {
        this.horizontalAlignment = horizontalAlignment;
    }

    public VerticalAlignment getVerticalAlignment() {
        return this.verticalAlignment;
    }

    public void setVerticalAlignment(VerticalAlignment verticalAlignment) {
        this.verticalAlignment = verticalAlignment;
    }

    public String getFill() {
        return this.fill;
    }

    public void setFill(String fill) {
        this.fill = fill;
    }

    public String getInsets() {
        return this.insets;
    }

    public void setInsets(String insets) {
        this.insets = insets;
    }

    public Integer getIpadx() {
        return this.ipadx;
    }

    public void setIpadx(Integer ipadx) {
        this.ipadx = ipadx;
    }

    public Integer getIpady() {
        return this.ipady;
    }

    public void setIpady(Integer ipady) {
        this.ipady = ipady;
    }

    public Double getWeightx() {
        return this.weightx;
    }

    public void setWeightx(Double weightx) {
        this.weightx = weightx;
    }

    public Double getWeighty() {
        return this.weighty;
    }

    public void setWeighty(Double weighty) {
        this.weighty = weighty;
    }

    public HorizontalAlignment getHalign(String halign) {
        if (halign.equalsIgnoreCase("left")) {
            return HorizontalAlignment.ALIGN_LEFT;
        }
        if (halign.equalsIgnoreCase("right")) {
            return HorizontalAlignment.ALIGN_RIGHT;
        }
        if (halign.equalsIgnoreCase("center")) {
            return HorizontalAlignment.ALIGN_CENTER;
        }
        return null;
    }

    public VerticalAlignment getValign(String valign) {
        if (valign.equalsIgnoreCase("top")) {
            return VerticalAlignment.ALIGN_TOP;
        }
        if (valign.equalsIgnoreCase("bottom")) {
            return VerticalAlignment.ALIGN_BOTTOM;
        }
        if (valign.equalsIgnoreCase("middle")) {
            return VerticalAlignment.ALIGN_MIDDLE;
        }
        return null;
    }

    public static String createCell(String parentId, CellHandler cl, List<List<Boolean>> layout, int iC, int r) {
        StringBuffer result = new StringBuffer();
        boolean columnSetByUser = true;
        boolean rowSetByUser = true;
        if (cl.getColumn() == -1) {
            cl.setColumn(iC);
            columnSetByUser = false;
        } else if (cl.getColumn() < iC && log.isErrorEnabled()) {
            log.error((Object)"Error cell column number");
        }
        if (cl.getRow() == -1) {
            cl.setRow(r);
            rowSetByUser = false;
        } else if (rowSetByUser && cl.getRow() < r && log.isErrorEnabled()) {
            log.error((Object)"Error cell row number");
        }
        if (r >= layout.size()) {
            for (int i = layout.size(); i <= r; ++i) {
                layout.add(new ArrayList());
            }
        }
        boolean enoughPlace = false;
        while (!enoughPlace) {
            enoughPlace = true;
            while (layout.get(r).size() > iC && layout.get(r).get(iC).booleanValue()) {
                if (columnSetByUser && cl.getColumn() == iC && log.isErrorEnabled()) {
                    log.error((Object)"This column is already occupied.");
                }
                ++iC;
            }
            if (layout.get(r).size() <= iC) continue;
            int j = 0;
            for (int i = 0; i < cl.getColumns(); ++i) {
                if (layout.get(r).size() <= iC + i || !layout.get(r).get(iC + i).booleanValue()) continue;
                enoughPlace = false;
                j = iC + i;
            }
            if (enoughPlace) continue;
            iC = j + 1;
        }
        cl.setColumn(iC);
        for (int i = 0; i < cl.getRows(); ++i) {
            int j;
            if (layout.size() <= r + i) {
                for (j = layout.size(); j <= r + i; ++j) {
                    layout.add(new ArrayList());
                }
            }
            for (j = 0; j < cl.getColumns(); ++j) {
                if (layout.get(r + i).size() < iC + j) {
                    for (int k = layout.get(r + i).size(); k < iC + j; ++k) {
                        layout.get(r + i).add(false);
                    }
                }
                if (iC + j < layout.get(r + i).size()) {
                    layout.get(r + i).set(iC + j, true);
                    continue;
                }
                layout.get(r + i).add(true);
            }
        }
        String anchor = TableHandler.getAnchor(cl.getHorizontalAlignment(), cl.getVerticalAlignment());
        result.append(parentId).append(".add(").append(cl.getId()).append(", new java.awt.GridBagConstraints (").append(cl.getColumn()).append(",").append(cl.getRow()).append(",").append(cl.getColumns()).append(",").append(cl.getRows()).append(",").append(cl.getWeightx()).append(",").append(cl.getWeighty()).append(",").append(anchor != null ? anchor : DEFAULT_ANCHOR).append(",").append("GridBagConstraints.").append(cl.getFill().toUpperCase()).append(", new java.awt.Insets(").append(cl.getInsets()).append("),").append(cl.getIpadx()).append(",").append(cl.getIpady()).append("));\n");
        return result.toString();
    }

    private static String getAnchor(HorizontalAlignment halign, VerticalAlignment valign) {
        if (halign == HorizontalAlignment.ALIGN_LEFT) {
            if (valign == VerticalAlignment.ALIGN_TOP) {
                return "java.awt.GridBagConstraints.FIRST_LINE_START";
            }
            if (valign == VerticalAlignment.ALIGN_MIDDLE) {
                return "java.awt.GridBagConstraints.PAGE_START";
            }
            if (valign == VerticalAlignment.ALIGN_BOTTOM) {
                return "java.awt.GridBagConstraints.FIRST_LINE_END";
            }
            return null;
        }
        if (halign == HorizontalAlignment.ALIGN_CENTER) {
            if (valign == VerticalAlignment.ALIGN_TOP) {
                return "java.awt.GridBagConstraints.LINE_START";
            }
            if (valign == VerticalAlignment.ALIGN_MIDDLE) {
                return "java.awt.GridBagConstraints.CENTER";
            }
            if (valign == VerticalAlignment.ALIGN_BOTTOM) {
                return "java.awt.GridBagConstraints.LINE_END";
            }
            return null;
        }
        if (halign == HorizontalAlignment.ALIGN_RIGHT) {
            if (valign == VerticalAlignment.ALIGN_TOP) {
                return "java.awt.GridBagConstraints.LAST_LINE_START";
            }
            if (valign == VerticalAlignment.ALIGN_MIDDLE) {
                return "java.awt.GridBagConstraints.PAGE_END";
            }
            if (valign == VerticalAlignment.ALIGN_BOTTOM) {
                return "java.awt.GridBagConstraints.LAST_LINE_END";
            }
            return null;
        }
        return null;
    }

    protected static enum HorizontalAlignment {
        ALIGN_LEFT,
        ALIGN_CENTER,
        ALIGN_RIGHT,
        ALIGN_DEFAULT;

    }

    protected static enum VerticalAlignment {
        ALIGN_TOP,
        ALIGN_MIDDLE,
        ALIGN_BOTTOM;

    }
}

