
package org.nuiton.guix.tags.swing;
import javax.swing.event.ListSelectionListener;

/**
 * Handles the list tag
 *
 * @author kmorin
 */
public class ListHandler extends ComponentHandler {

    public ListHandler() {
        super();
    }

    @Override
    public Class getClassToGenerate() {
        return javax.swing.JList.class;
    }

    @Override
    protected void configureProxyEventInfo() {
        super.configureProxyEventInfo();
        addProxyEventInfo("getSelectedIndex", ListSelectionListener.class, "selectionModel");
        addProxyEventInfo("getSelectedIndices", ListSelectionListener.class, "selectionModel");
        addProxyEventInfo("getSelectedValue", ListSelectionListener.class, "selectionModel");
        addProxyEventInfo("getSelectedValues", ListSelectionListener.class, "selectionModel");
    }
}
