/**
 * *##% guix-compiler
 * Copyright (C) 2009 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>. ##%*
 */

package org.nuiton.guix;

//~--- non-JDK imports --------------------------------------------------------

import org.nuiton.guix.tags.swing.PanelHandler;
import org.nuiton.guix.tags.swing.FrameHandler;
import org.nuiton.guix.tags.swing.CellHandler;
import org.nuiton.guix.tags.swing.RowHandler;
import org.nuiton.guix.tags.swing.TableHandler;
import org.nuiton.guix.tags.TagManager;
import org.nuiton.guix.tags.swing.ButtonHandler;
import org.nuiton.guix.tags.swing.CheckBoxHandler;
import org.nuiton.guix.tags.swing.ComboBoxHandler;
import org.nuiton.guix.tags.swing.DialogBoxHandler;
import org.nuiton.guix.tags.swing.LabelHandler;
import org.nuiton.guix.tags.swing.ListHandler;
import org.nuiton.guix.tags.swing.MenuBarHandler;
import org.nuiton.guix.tags.swing.MenuHandler;
import org.nuiton.guix.tags.swing.MenuItemHandler;
import org.nuiton.guix.tags.swing.PasswordFieldHandler;
import org.nuiton.guix.tags.swing.ProgressBarHandler;
import org.nuiton.guix.tags.swing.RadioButtonHandler;
import org.nuiton.guix.tags.swing.ScrollPanelHandler;
import org.nuiton.guix.tags.swing.SliderHandler;
import org.nuiton.guix.tags.swing.SpinnerHandler;
import org.nuiton.guix.tags.swing.SplitPanelHandler;
import org.nuiton.guix.tags.swing.TabHandler;
import org.nuiton.guix.tags.swing.TabPanelHandler;
import org.nuiton.guix.tags.swing.TextAreaHandler;
import org.nuiton.guix.tags.swing.TextFieldHandler;
import org.nuiton.guix.tags.swing.ToggleButtonHandler;
import org.nuiton.guix.tags.swing.TreeHandler;
import org.nuiton.guix.tags.swing.TreeNodeHandler;

/**
 * Initialize the application
 *
 * @author morin
 */
public class SwingGuixInitializer {
    public static void initialize() {
       TagManager.registerGuixClassHandler("Application", FrameHandler.class);
       TagManager.registerGuixClassHandler("Frame", FrameHandler.class);
       TagManager.registerGuixClassHandler("DialogBox", DialogBoxHandler.class);    
       TagManager.registerGuixClassHandler("Table", TableHandler.class);
       TagManager.registerGuixClassHandler("Row", RowHandler.class);
       TagManager.registerGuixClassHandler("Cell", CellHandler.class);
       TagManager.registerGuixClassHandler("Panel", PanelHandler.class);
       TagManager.registerGuixClassHandler("HorizontalSplitPanel", SplitPanelHandler.class);
       TagManager.registerGuixClassHandler("VerticalSplitPanel", SplitPanelHandler.class);
       TagManager.registerGuixClassHandler("ScrollPanel", ScrollPanelHandler.class);
       TagManager.registerGuixClassHandler("Button", ButtonHandler.class);
       TagManager.registerGuixClassHandler("TextField", TextFieldHandler.class);
       TagManager.registerGuixClassHandler("TextArea", TextAreaHandler.class);
       TagManager.registerGuixClassHandler("Label", LabelHandler.class);
       TagManager.registerGuixClassHandler("ToggleButton", ToggleButtonHandler.class);
       TagManager.registerGuixClassHandler("CheckBox", CheckBoxHandler.class);
       TagManager.registerGuixClassHandler("ComboBox", ComboBoxHandler.class);
       TagManager.registerGuixClassHandler("List", ListHandler.class);
       TagManager.registerGuixClassHandler("PasswordField", PasswordFieldHandler.class);
       TagManager.registerGuixClassHandler("ProgressBar", ProgressBarHandler.class);
       TagManager.registerGuixClassHandler("RadioButton", RadioButtonHandler.class);
       TagManager.registerGuixClassHandler("Slider", SliderHandler.class);
       TagManager.registerGuixClassHandler("Spinner", SpinnerHandler.class);
       TagManager.registerGuixClassHandler("TabPanel", TabPanelHandler.class);
       TagManager.registerGuixClassHandler("Tab", TabHandler.class);
       TagManager.registerGuixClassHandler("Tree", TreeHandler.class);
       TagManager.registerGuixClassHandler("TreeNode", TreeNodeHandler.class);
       TagManager.registerGuixClassHandler("MenuBar", MenuBarHandler.class);
       TagManager.registerGuixClassHandler("Menu", MenuHandler.class);
       TagManager.registerGuixClassHandler("MenuItem", MenuItemHandler.class);

    }
}


//~ Formatted by Jindent --- http://www.jindent.com
